/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class EffectMachineComponent
extends AbstractMachineComponent {
    public EffectMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public MachineComponentType<EffectMachineComponent> getType() {
        return Registration.EFFECT_MACHINE_COMPONENT.get();
    }

    public void applyEffect(MobEffectInstance effect, int radius, Predicate<Entity> filter) {
        BlockPos machinePos = this.getManager().getTile().getBlockPos();
        AABB bb = new AABB(machinePos).inflate((double)radius);
        this.getManager().getLevel().getEntitiesOfClass(LivingEntity.class, bb, filter).stream().filter(entity -> entity.distanceToSqr((double)machinePos.getX(), (double)machinePos.getY(), (double)machinePos.getZ()) < (double)(radius * radius)).forEach(entity -> entity.addEffect(effect));
    }
}

