/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import fr.frinn.custommachinery.api.component.IDumpComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.item.ItemMachineComponent;
import fr.frinn.custommachinery.common.guielement.SplitButtonGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.transfer.SidedItemHandler;
import fr.frinn.custommachinery.impl.component.AbstractComponentHandler;
import fr.frinn.custommachinery.impl.component.config.IOSideMode;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class ItemComponentHandler
extends AbstractComponentHandler<ItemMachineComponent>
implements ISerializableComponent,
ITickableComponent,
ISyncableStuff,
IDumpComponent,
IItemHandlerModifiable {
    private final Map<Direction, SidedItemHandler> sidedHandlers = Maps.newEnumMap(Direction.class);
    private final Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> neighbourStorages = Maps.newEnumMap(Direction.class);
    private final Map<String, List<String>> slotSplitters = new HashMap<String, List<String>>();
    private final List<ItemMachineComponent> inputs = new ArrayList<ItemMachineComponent>();
    private final List<ItemMachineComponent> outputs = new ArrayList<ItemMachineComponent>();

    public ItemComponentHandler(IMachineComponentManager manager, List<ItemMachineComponent> components) {
        super(manager, components);
        components.forEach(component -> {
            component.getConfig().setCallback(this::configChanged);
            if (component.getMode().isInput()) {
                this.inputs.add((ItemMachineComponent)component);
            }
            if (component.getMode().isOutput()) {
                this.outputs.add((ItemMachineComponent)component);
            }
        });
        for (Direction direction : Direction.values()) {
            this.sidedHandlers.put(direction, new SidedItemHandler(direction, this));
        }
    }

    @Nullable
    public IItemHandler getItemHandlerForSide(@Nullable Direction side) {
        if (side == null) {
            return this;
        }
        if (this.getComponents().stream().anyMatch(component -> !((IOSideMode)component.getConfig().getDirectionMode(side)).isNone())) {
            return this.sidedHandlers.get(side);
        }
        return null;
    }

    public void configChanged(RelativeSide side, IOSideMode oldMode, IOSideMode newMode) {
        if (oldMode.isNone() != newMode.isNone()) {
            this.getManager().getTile().invalidateCapabilities();
        }
    }

    public MachineComponentType<ItemMachineComponent> getType() {
        return Registration.ITEM_MACHINE_COMPONENT.get();
    }

    @Override
    public Optional<ItemMachineComponent> getComponentForID(String id) {
        return this.getComponents().stream().filter(component -> component.getId().equals(id)).findFirst();
    }

    @Override
    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        ListTag components = new ListTag();
        this.getComponents().forEach(component -> {
            CompoundTag componentNBT = new CompoundTag();
            component.serialize(componentNBT, registries);
            componentNBT.putString("slotID", component.getId());
            components.add((Object)componentNBT);
        });
        nbt.put("items", (Tag)components);
        ListTag splitters = new ListTag();
        this.slotSplitters.forEach((id, slots) -> splitters.add((Object)StringTag.valueOf((String)id)));
        nbt.put("splitters", (Tag)splitters);
    }

    @Override
    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("items", 9)) {
            ListTag components = nbt.getList("items", 10);
            components.forEach(tag -> {
                CompoundTag componentNBT;
                if (tag instanceof CompoundTag && (componentNBT = (CompoundTag)tag).contains("slotID", 8)) {
                    this.getComponents().stream().filter(component -> component.getId().equals(componentNBT.getString("slotID"))).findFirst().ifPresent(component -> component.deserialize(componentNBT, registries));
                }
            });
        }
        if (nbt.contains("splitters", 9)) {
            ListTag splitters = nbt.getList("splitters", 8);
            splitters.forEach(tag -> {
                if (tag instanceof StringTag) {
                    StringTag stringTag = (StringTag)tag;
                    this.getManager().getTile().getMachine().getGuiElements().stream().filter(element -> element instanceof SplitButtonGuiElement && element.getId().equals(stringTag.getAsString())).findFirst().ifPresent(element -> this.slotSplitters.put(stringTag.getAsString(), ((SplitButtonGuiElement)element).getSlots()));
                }
            });
        }
    }

    @Override
    public void serverTick() {
        super.serverTick();
        HashSet sortedSlots = new HashSet();
        this.slotSplitters.forEach((id, slots) -> {
            if (sortedSlots.containsAll((Collection<?>)slots)) {
                return;
            }
            List<String> toSort = slots.stream().filter(slot -> !sortedSlots.contains(slot)).collect(Collectors.toList());
            sortedSlots.addAll(toSort);
            ArrayList itemsToSort = new ArrayList();
            toSort.forEach(slot -> this.getComponentForID((String)slot).filter(component -> !component.getItemStack().isEmpty()).ifPresent(component -> {
                Triple alreadyPresent = itemsToSort.stream().filter(triple -> ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)triple.getLeft()), (ItemStack)component.getItemStack())).findFirst().orElse(null);
                if (alreadyPresent == null) {
                    itemsToSort.add(Triple.of((Object)component.getItemStack().copy(), (Object)component.getItemStack().getCount(), Collections.singletonList(slot)));
                } else {
                    itemsToSort.remove(alreadyPresent);
                    itemsToSort.add(Triple.of((Object)((ItemStack)alreadyPresent.getLeft()), (Object)((Integer)alreadyPresent.getMiddle() + component.getItemStack().getCount()), (Object)ImmutableList.builder().addAll((Iterable)alreadyPresent.getRight()).add(slot).build()));
                }
            }));
            Iterator iterator = itemsToSort.iterator();
            while (iterator.hasNext()) {
                if (itemsToSort.size() == toSort.size()) {
                    return;
                }
                Triple sorting = (Triple)iterator.next();
                if ((Integer)sorting.getMiddle() == 1) {
                    toSort.removeAll((Collection)sorting.getRight());
                    iterator.remove();
                    return;
                }
                ArrayList availableSlots = new ArrayList((Collection)sorting.getRight());
                toSort.stream().filter(slot -> this.getComponentForID((String)slot).map(component -> component.getItemStack().isEmpty()).orElse(false)).forEach(availableSlots::add);
                int count = (Integer)sorting.getMiddle() / availableSlots.size();
                AtomicInteger remaining = new AtomicInteger((Integer)sorting.getMiddle() % availableSlots.size());
                availableSlots.forEach(slot -> this.getComponentForID((String)slot).ifPresent(component -> {
                    if (remaining.getAndAdd(-1) > 0) {
                        component.setItemStack(((ItemStack)sorting.getLeft()).copyWithCount(count + 1));
                    } else {
                        component.setItemStack(((ItemStack)sorting.getLeft()).copyWithCount(count));
                    }
                }));
                toSort.removeAll(availableSlots);
                iterator.remove();
            }
        });
        for (Direction side : Direction.values()) {
            IItemHandler neighbour;
            if (this.getComponents().stream().noneMatch(component -> component.getConfig().canAutoIO(side))) continue;
            if (this.neighbourStorages.get(side) == null) {
                this.neighbourStorages.put(side, (BlockCapabilityCache<IItemHandler, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)this.getManager().getLevel()), (BlockPos)this.getManager().getTile().getBlockPos().relative(side), (Object)side.getOpposite(), () -> !this.getManager().getTile().isRemoved(), () -> this.neighbourStorages.remove(side)));
            }
            if ((neighbour = (IItemHandler)this.neighbourStorages.get(side).getCapability()) == null) continue;
            this.sidedHandlers.get(side).getHandler().getComponents().forEach(component -> {
                if (component.getConfig().isAutoInput() && ((IOSideMode)component.getConfig().getDirectionMode(side)).isInput() && component.getItemStack().getCount() < component.getCapacity()) {
                    this.moveStacks(neighbour, (IItemHandler)component, Integer.MAX_VALUE);
                }
                if (component.getConfig().isAutoOutput() && ((IOSideMode)component.getConfig().getDirectionMode(side)).isOutput() && !component.getItemStack().isEmpty()) {
                    this.moveStacks((IItemHandler)component, neighbour, Integer.MAX_VALUE);
                }
            });
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.getComponents().forEach(component -> component.getStuffToSync(container));
    }

    @Override
    public void dump(List<String> ids) {
        this.getComponents().stream().filter(component -> ids.contains(component.getId())).forEach(component -> component.setItemStack(ItemStack.EMPTY));
    }

    public void addSplitter(String id, List<String> slots) {
        this.slotSplitters.put(id, slots);
    }

    public void removeSplitter(String id) {
        this.slotSplitters.remove(id);
    }

    public Set<String> getSplitters() {
        return this.slotSplitters.keySet();
    }

    public int getIngredientAmount(String slot, Ingredient ingredient) {
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        return this.inputs.stream().filter(component -> ingredient.test(component.getItemStack()) && slotPredicate.test((ItemMachineComponent)component)).mapToInt(component -> component.getItemStack().getCount()).sum();
    }

    public int getDurabilityAmount(String slot, ItemStack stack) {
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        return this.inputs.stream().filter(component -> ItemComponentHandler.isSameItem(component.getItemStack(), stack) && component.getItemStack().isDamageableItem() && slotPredicate.test((ItemMachineComponent)component)).mapToInt(component -> component.getItemStack().getMaxDamage() - component.getItemStack().getDamageValue()).sum();
    }

    public int getSpaceForItem(String slot, ItemStack stack) {
        return this.outputs.stream().filter(component -> this.canPlaceOutput((ItemMachineComponent)component, slot, stack)).mapToInt(component -> {
            if (component.getItemStack().isEmpty()) {
                return Math.min(component.getCapacity(), stack.getMaxStackSize());
            }
            return Math.min(component.getCapacity() - component.getItemStack().getCount(), stack.getMaxStackSize() - component.getItemStack().getCount());
        }).sum();
    }

    private boolean canPlaceOutput(ItemMachineComponent component, @Nullable String slot, ItemStack stack) {
        if (slot != null && !slot.isEmpty() && !component.getId().equals(slot)) {
            return false;
        }
        if (!component.isItemValid(0, stack)) {
            return false;
        }
        if (component.getItemStack().isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)component.getItemStack(), (ItemStack)stack)) {
            return false;
        }
        return component.getItemStack().getCount() < Math.min(stack.getMaxStackSize(), component.getCapacity());
    }

    public int getSpaceForDurability(String slot, ItemStack stack) {
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        return this.inputs.stream().filter(component -> ItemComponentHandler.isSameItem(component.getItemStack(), stack) && component.getItemStack().isDamageableItem() && slotPredicate.test((ItemMachineComponent)component)).mapToInt(component -> component.getItemStack().getDamageValue()).sum();
    }

    public void removeFromInputs(String slot, Ingredient ingredient, int amount) {
        AtomicInteger toRemove = new AtomicInteger(amount);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        this.inputs.stream().filter(component -> ingredient.test(component.getItemStack()) && slotPredicate.test((ItemMachineComponent)component)).forEach(component -> {
            int maxExtract = Math.min(component.getItemStack().getCount(), toRemove.get());
            toRemove.addAndGet(-maxExtract);
            component.getItemStack().shrink(maxExtract);
        });
        this.getManager().markDirty();
    }

    public void removeDurability(String slot, ItemStack input, int amount, boolean canBreak) {
        AtomicInteger toRemove = new AtomicInteger(amount);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        this.inputs.stream().filter(component -> ItemComponentHandler.isSameItem(component.getItemStack(), input) && component.getItemStack().isDamageableItem() && slotPredicate.test((ItemMachineComponent)component)).forEach(component -> {
            int maxRemove = Math.min(component.getItemStack().getMaxDamage() - component.getItemStack().getDamageValue(), toRemove.get());
            ItemStack stack = component.getItemStack();
            maxRemove = stack.getItem().damageItem(stack, maxRemove, null, s -> {});
            if (maxRemove > 0 && (maxRemove = EnchantmentHelper.processDurabilityChange((ServerLevel)((ServerLevel)this.getManager().getLevel()), (ItemStack)stack, (int)maxRemove)) <= 0) {
                return;
            }
            toRemove.addAndGet(-maxRemove);
            stack.setDamageValue(stack.getDamageValue() + maxRemove);
            if (stack.getDamageValue() >= stack.getMaxDamage() && canBreak) {
                stack.shrink(1);
            }
        });
        this.getManager().markDirty();
    }

    public void addToOutputs(String slot, ItemStack stack, int amount) {
        AtomicInteger toAdd = new AtomicInteger(amount);
        this.outputs.stream().filter(component -> this.canPlaceOutput((ItemMachineComponent)component, slot, stack)).forEach(component -> {
            int maxInsert = toAdd.get() - component.insertItemBypassLimit(stack, true).getCount();
            toAdd.addAndGet(-maxInsert);
            component.insertItemBypassLimit(stack.copyWithCount(maxInsert), false);
        });
        this.getManager().markDirty();
    }

    public void repairItem(String slot, ItemStack stack, int amount) {
        AtomicInteger toRepair = new AtomicInteger(amount);
        Predicate<ItemMachineComponent> slotPredicate = component -> slot.isEmpty() || component.getId().equals(slot);
        this.inputs.stream().filter(component -> ItemComponentHandler.isSameItem(component.getItemStack(), stack) && component.getItemStack().isDamageableItem() && slotPredicate.test((ItemMachineComponent)component)).forEach(component -> {
            int maxRepair = Math.min(component.getItemStack().getDamageValue(), toRepair.get());
            toRepair.addAndGet(-maxRepair);
            component.getItemStack().setDamageValue(component.getItemStack().getDamageValue() - maxRepair);
        });
        this.getManager().markDirty();
    }

    private static boolean isSameItem(ItemStack toTest, ItemStack ingredient) {
        if (toTest.getItem() != ingredient.getItem()) {
            return false;
        }
        return ingredient.getComponents().stream().allMatch(component -> component.type() == DataComponents.DAMAGE || toTest.has(component.type()) && Objects.equals(toTest.get(component.type()), component.value()));
    }

    public int getSlots() {
        return this.getComponents().size();
    }

    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return ((ItemMachineComponent)this.getComponents().get(slot)).getStackInSlot(0);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        ((ItemMachineComponent)this.getComponents().get(slot)).setStackInSlot(0, stack);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        this.validateSlotIndex(slot);
        return ((ItemMachineComponent)this.getComponents().get(slot)).insertItem(0, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlotIndex(slot);
        return ((ItemMachineComponent)this.getComponents().get(slot)).extractItem(0, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        this.validateSlotIndex(slot);
        return ((ItemMachineComponent)this.getComponents().get(slot)).getSlotLimit(0);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return ((ItemMachineComponent)this.getComponents().get(slot)).isItemValid(0, stack);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    private void moveStacks(IItemHandler from, IItemHandler to, int maxAmount) {
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack canExtract = from.extractItem(i, maxAmount, true);
            if (canExtract.isEmpty()) continue;
            ItemStack canInsert = ItemHandlerHelper.insertItemStacked((IItemHandler)to, (ItemStack)canExtract, (boolean)false);
            if (canInsert.isEmpty()) {
                from.extractItem(i, maxAmount, false);
                continue;
            }
            from.extractItem(i, canExtract.getCount() - canInsert.getCount(), false);
        }
    }
}

