/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.common.crafting.CraftingContext;
import fr.frinn.custommachinery.common.crafting.RecipeChecker;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Comparators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;

public class MachineRecipeFinder {
    private final MachineTile tile;
    private final MachineProcessor processor;
    private final int baseCooldown;
    private final CraftingContext.Mutable mutableCraftingContext;
    private final int core;
    private List<RecipeChecker<CustomMachineRecipe>> recipes;
    private List<RecipeChecker<CustomMachineRecipe>> okToCheck;
    private boolean inventoryChanged = true;
    private int recipeCheckCooldown;

    public MachineRecipeFinder(MachineTile tile, MachineProcessor processor, int baseCooldown, CraftingContext.Mutable mutableCraftingContext, int core) {
        this.tile = tile;
        this.processor = processor;
        this.baseCooldown = baseCooldown;
        this.mutableCraftingContext = mutableCraftingContext;
        this.core = core;
    }

    public void init() {
        if (this.tile.getLevel() == null) {
            throw new IllegalStateException("Broken machine " + String.valueOf(this.tile.getMachine().getId()) + "doesn't have a world");
        }
        this.recipes = this.tile.getLevel().getRecipeManager().getAllRecipesFor((RecipeType)Registration.CUSTOM_MACHINE_RECIPE.get()).stream().filter(recipe -> this.tile.getMachine().getRecipeIds().contains(((CustomMachineRecipe)recipe.value()).getMachineId())).sorted((holder1, holder2) -> Comparators.RECIPE_PRIORITY_COMPARATOR.reversed().compare((IMachineRecipe)holder1.value(), (IMachineRecipe)holder2.value())).map(RecipeChecker::new).toList();
        this.okToCheck = new ArrayList<RecipeChecker<CustomMachineRecipe>>();
        this.recipeCheckCooldown = this.tile.getLevel().random.nextInt(this.baseCooldown);
    }

    public Optional<RecipeHolder<CustomMachineRecipe>> findRecipe(boolean immediately) {
        if (this.tile.getLevel() == null) {
            return Optional.empty();
        }
        if (immediately || this.recipeCheckCooldown-- <= 0) {
            this.recipeCheckCooldown = this.baseCooldown;
            if (this.inventoryChanged || immediately) {
                this.okToCheck.clear();
                this.okToCheck.addAll(this.recipes);
            }
            Iterator<RecipeChecker<CustomMachineRecipe>> iterator = this.okToCheck.iterator();
            while (iterator.hasNext()) {
                RecipeChecker<CustomMachineRecipe> checker = iterator.next();
                if (!this.inventoryChanged && checker.isInventoryRequirementsOnly() && !immediately) continue;
                if (checker.check(this.tile, this.mutableCraftingContext.setRecipe((IMachineRecipe)checker.getRecipe().value(), checker.getRecipe().id()), this.inventoryChanged || immediately)) {
                    if (!((CustomMachineRecipe)checker.getRecipe().value()).getAllowedCores().isEmpty() && !((CustomMachineRecipe)checker.getRecipe().value()).getAllowedCores().contains(this.core) || ((CustomMachineRecipe)checker.getRecipe().value()).isSingleCore() && this.processor.getCores().stream().anyMatch(core -> core.getCurrentRecipe() != null && core.getCurrentRecipe().id().equals((Object)checker.getRecipe().id()))) continue;
                    this.setInventoryChanged(false);
                    return Optional.of(checker.getRecipe());
                }
                if (checker.isInventoryRequirementsOk()) continue;
                iterator.remove();
            }
            this.setInventoryChanged(false);
        }
        return Optional.empty();
    }

    public void setInventoryChanged(boolean changed) {
        this.inventoryChanged = changed;
    }
}

