/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.crafting.craft.CraftProcessor;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.SyncableContainer;
import fr.frinn.custommachinery.common.util.slot.ResultSlotItemComponent;
import fr.frinn.custommachinery.common.util.slot.SlotItemComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;

public class CustomMachineContainer
extends SyncableContainer {
    private final Inventory playerInv;
    private final CustomMachineTile tile;
    private int firstComponentSlotIndex = 0;
    private boolean hasPlayerInventory = false;
    private final List<SlotItemComponent> inputSlotComponents = new ArrayList<SlotItemComponent>();

    public static void open(ServerPlayer player, final MachineTile machine) {
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return machine.getMachine().getName();
            }

            public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
                return new CustomMachineContainer(id, inv, (CustomMachineTile)machine);
            }
        }, buf -> buf.writeBlockPos(machine.getBlockPos()));
    }

    public CustomMachineContainer(int id, Inventory playerInv, CustomMachineTile tile) {
        super(Registration.CUSTOM_MACHINE_CONTAINER.get(), id, tile, playerInv.player);
        this.playerInv = playerInv;
        this.tile = tile;
        this.init();
        tile.startInteracting(this.getPlayer());
    }

    public CustomMachineContainer(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv, ClientHandler.getClientSideCustomMachineTile(extraData.readBlockPos()));
    }

    @Override
    public void init() {
        super.init();
        this.slots.clear();
        this.inputSlotComponents.clear();
        AtomicInteger slotIndex = new AtomicInteger(0);
        this.tile.getGuiElements().stream().filter(element -> element.getType() == Registration.PLAYER_INVENTORY_GUI_ELEMENT.get()).findFirst().ifPresent(element -> {
            this.hasPlayerInventory = true;
            int x = element.getX() + 1;
            int y = element.getY() + 1;
            for (int k = 0; k < 9; ++k) {
                this.addSyncedSlot(new Slot((Container)this.playerInv, slotIndex.getAndIncrement(), x + k * 18, y + 58));
            }
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.addSyncedSlot(new Slot((Container)this.playerInv, slotIndex.getAndIncrement(), x + j * 18, y + i * 18));
                }
            }
        });
        this.firstComponentSlotIndex = slotIndex.get() + 1;
        this.tile.getGuiElements().stream().filter(element -> element.getType() == Registration.SLOT_GUI_ELEMENT.get()).map(element -> (SlotGuiElement)element).forEach(element -> this.tile.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(itemHandler -> itemHandler.getComponentForID(element.getComponentId())).ifPresent(component -> {
            int x = element.getX();
            int y = element.getY();
            int width = element.getWidth();
            int height = element.getHeight();
            int slotX = x + (width - 16) / 2;
            int slotY = y + (height - 16) / 2;
            SlotItemComponent slotComponent = component.makeSlot(slotIndex.getAndIncrement(), slotX, slotY);
            this.addSlot(slotComponent);
            if (component.getType() != Registration.ITEM_MACHINE_COMPONENT.get() || component.getMode().isInput()) {
                this.inputSlotComponents.add(slotComponent);
            }
        }));
    }

    public CustomMachineTile getTile() {
        return this.tile;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        SlotItemComponent slot;
        Object object;
        if (slotId >= 0 && slotId < this.slots.size() && (object = this.slots.get(slotId)) instanceof SlotItemComponent && !(slot = (SlotItemComponent)((Object)object)).getItem().isEmpty()) {
            this.tile.getComponentManager().getComponent(Registration.EXPERIENCE_MACHINE_COMPONENT.get()).ifPresent(component -> {
                if (component.canRetrieveFromSlots()) {
                    if (component.slotsFromCanRetrieve().isEmpty()) {
                        player.giveExperiencePoints(component.getXp());
                        component.extractXp(component.getXp(), false);
                    } else {
                        component.slotsFromCanRetrieve().forEach(id -> {
                            if (id.equals(slot.getComponent().getId())) {
                                player.giveExperiencePoints(component.getXp());
                                component.extractXp(component.getXp(), false);
                            }
                        });
                    }
                }
            });
        }
        this.tile.setChanged();
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (!this.hasPlayerInventory) {
            return ItemStack.EMPTY;
        }
        Slot clickedSlot = (Slot)this.slots.get(index);
        if (clickedSlot.getItem().isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (clickedSlot.container == this.playerInv) {
            ItemStack stack = clickedSlot.getItem().copy();
            List<SlotItemComponent> components = !CustomMachinery.UPGRADES.getUpgradesForItemAndMachine(stack.getItem(), this.tile.getId()).isEmpty() ? this.inputSlotComponents.stream().sorted(Comparator.comparingInt(slot -> slot.getComponent().getType() == Registration.ITEM_UPGRADE_MACHINE_COMPONENT.get() ? -1 : 1)).toList() : (stack.getBurnTime(RecipeType.SMELTING) > 0 ? this.inputSlotComponents.stream().sorted(Comparator.comparingInt(slot -> slot.getComponent().getType() == Registration.ITEM_FUEL_MACHINE_COMPONENT.get() ? -1 : 1)).toList() : (stack.getCapability(Capabilities.EnergyStorage.ITEM) != null ? this.inputSlotComponents.stream().sorted(Comparator.comparingInt(slot -> slot.getComponent().getType() == Registration.ITEM_ENERGY_MACHINE_COMPONENT.get() ? -1 : 1)).toList() : (stack.getCapability(Capabilities.FluidHandler.ITEM) != null ? this.inputSlotComponents.stream().sorted(Comparator.comparingInt(slot -> slot.getComponent().getType() == Registration.ITEM_FLUID_MACHINE_COMPONENT.get() ? -1 : 1)).toList() : this.inputSlotComponents)));
            for (SlotItemComponent slotComponent2 : components) {
                if (!slotComponent2.getComponent().isLocked() && (stack = slotComponent2.getComponent().insertItemBypassLimit(stack, false)).isEmpty()) break;
            }
            if (stack.isEmpty()) {
                clickedSlot.remove(clickedSlot.getItem().getCount());
            } else {
                clickedSlot.remove(clickedSlot.getItem().getCount() - stack.getCount());
            }
        } else {
            ItemStack removed;
            SlotItemComponent slotComponent;
            if (!(clickedSlot instanceof SlotItemComponent) || (slotComponent = (SlotItemComponent)clickedSlot).getComponent().isLocked()) {
                return ItemStack.EMPTY;
            }
            if (slotComponent instanceof ResultSlotItemComponent) {
                ResultSlotItemComponent resultSlot = (ResultSlotItemComponent)slotComponent;
                IProcessor slotComponent2 = this.tile.getProcessor();
                if (slotComponent2 instanceof CraftProcessor) {
                    CraftProcessor processor = (CraftProcessor)slotComponent2;
                    ItemStack removed2 = slotComponent.getItem().copy();
                    if (!this.playerInv.add(removed2)) {
                        return ItemStack.EMPTY;
                    }
                    int crafted = 0;
                    while (processor.bulkCraft()) {
                        removed2 = slotComponent.getItem().copy();
                        if (!this.playerInv.add(removed2)) {
                            return ItemStack.EMPTY;
                        }
                        if (crafted++ != 64 || !player.getAbilities().instabuild) continue;
                        return ItemStack.EMPTY;
                    }
                    return ItemStack.EMPTY;
                }
            }
            if (!this.moveItemStackTo(removed = slotComponent.getItem(), 0, this.firstComponentSlotIndex - 1, false)) {
                return ItemStack.EMPTY;
            }
            this.tile.getUpgradeManager().refresh();
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return player.level().getBlockState(this.tile.getBlockPos()) == this.tile.getBlockState() && player.level().getBlockEntity(this.tile.getBlockPos()) == this.tile && player.position().distanceToSqr(Vec3.atCenterOf((Vec3i)this.tile.getBlockPos())) <= 64.0;
    }

    @Override
    public boolean needFullSync() {
        return this.tile.getLevel() != null && this.tile.getLevel().getGameTime() % 100L == 0L;
    }

    public void elementClicked(int element, byte button) {
        if (element < 0 || element >= this.tile.getGuiElements().size()) {
            throw new IllegalArgumentException("Invalid gui element ID: " + element);
        }
        this.tile.getGuiElements().get(element).handleClick(button, this.tile, this, this.getPlayer());
    }

    public List<SlotItemComponent> inputSlots() {
        return this.inputSlotComponents;
    }

    public List<Slot> inventorySlots() {
        if (this.hasPlayerInventory) {
            return this.slots.subList(0, this.firstComponentSlotIndex - 1);
        }
        return Collections.emptyList();
    }

    public void removed(Player player) {
        super.removed(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.tile.stopInteracting(serverPlayer);
        }
    }
}

