/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.op.IDataOps;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipeBuilder;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.integration.crafttweaker.CustomMachineRecipeCTBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.MachineRecipeManager")
public class CustomMachineRecipeCTManager
implements IRecipeManager<CustomMachineRecipe> {
    public static final CustomMachineRecipeCTManager INSTANCE = new CustomMachineRecipeCTManager();

    public RecipeType<CustomMachineRecipe> getRecipeType() {
        return (RecipeType)Registration.CUSTOM_MACHINE_RECIPE.get();
    }

    public ResourceLocation getBracketResourceLocation() {
        return Registration.CUSTOM_MACHINE_RECIPE.getId();
    }

    public void addJsonRecipe(String name, MapData mapData) {
        DataResult result = CustomMachineRecipeBuilder.CODEC.read((DynamicOps)IDataOps.INSTANCE, mapData);
        if (result.error().isPresent() || result.result().isEmpty()) {
            CraftTweakerAPI.getLogger((String)"custommachinery").error("Couldn't add custom machine recipe {} from json: {}", (Object)name, (Object)((DataResult.Error)result.error().get()).message());
            return;
        }
        ResourceLocation id = ResourceLocation.tryParse((String)name);
        if (id == null) {
            CraftTweakerAPI.getLogger((String)"custommachinery").error("Invalid id for custom machine recipe: {}", (Object)name);
            return;
        }
        CustomMachineRecipe recipe = ((CustomMachineRecipeBuilder)result.result().get()).build();
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    public List<RecipeHolder<CustomMachineRecipe>> getRecipesByOutput(IIngredient output) {
        throw new UnsupportedOperationException("Can't get custom machine recipe by output");
    }

    public void remove(IIngredient output) {
        throw new UnsupportedOperationException("Can't remove custom machine recipe by output");
    }

    public void removeByInput(IItemStack input) {
        throw new UnsupportedOperationException("Can't remove custom machine recipe by input");
    }

    @ZenCodeType.Method
    public CustomMachineRecipeCTBuilder create(String machine, int time) {
        return CustomMachineRecipeCTBuilder.create(machine, time);
    }
}

