/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.common.integration.crafttweaker.CTUtils;
import fr.frinn.custommachinery.common.requirement.BiomeRequirement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Biome")
public interface BiomeRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T biomeWhitelist(Biome[] biomes) {
        List<ResourceLocation> biomesID = Arrays.stream(biomes).map(CTUtils::biomeID).toList();
        return this.addRequirement(new BiomeRequirement(biomesID, false));
    }

    @ZenCodeType.Method
    default public T biomeWhitelist(Biome biome) {
        return this.addRequirement(new BiomeRequirement(Collections.singletonList(CTUtils.biomeID(biome)), false));
    }

    @ZenCodeType.Method
    default public T biomeBlacklist(Biome[] biomes) {
        List<ResourceLocation> biomesID = Arrays.stream(biomes).map(CTUtils::biomeID).toList();
        return this.addRequirement(new BiomeRequirement(biomesID, true));
    }

    @ZenCodeType.Method
    default public T biomeBlacklist(Biome biome) {
        return this.addRequirement(new BiomeRequirement(Collections.singletonList(CTUtils.biomeID(biome)), true));
    }
}

