/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.generator.KubeAssetGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.registry.AdditionalObjectRegistry;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.util.ID;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class CustomMachineBlockBuilderJS
extends BuilderBase<Block> {
    public static final List<String> VALID_RENDER_TYPES = List.of("solid", "cutout", "translucent");
    private ResourceLocation machineID;
    private boolean occlusion;

    public CustomMachineBlockBuilderJS(ResourceLocation i) {
        super(i);
        this.machineID = this.id;
        this.occlusion = false;
    }

    public CustomMachineBlockBuilderJS machine(ResourceLocation machineID) {
        this.machineID = machineID;
        return this;
    }

    public CustomMachineBlockBuilderJS occlude() {
        this.occlusion = true;
        return this;
    }

    public Block createObject() {
        CustomMachineBlock block = new CustomMachineBlock(this.occlusion);
        CustomMachinery.CUSTOM_BLOCK_MACHINES.put((Object)this.machineID, (Object)block);
        return block;
    }

    public void createAdditionalObjects(AdditionalObjectRegistry registry) {
        registry.add(Registries.ITEM, (BuilderBase)new ItemBuilder(this.id){

            public Item createObject() {
                return new CustomMachineItem((Block)CustomMachineBlockBuilderJS.this.get(), new Item.Properties(), CustomMachineBlockBuilderJS.this.machineID);
            }

            public void generateAssets(KubeAssetGenerator generator) {
                JsonObject json = new JsonObject();
                json.add("parent", (JsonElement)new JsonPrimitive("custommachinery:block/custom_machine_block"));
                JsonObject defaultJson = new JsonObject();
                defaultJson.add("", (JsonElement)new JsonPrimitive("custommachinery:default/custom_machine_default"));
                json.add("defaults", (JsonElement)defaultJson);
                generator.json(this.id.withPath(ID.ITEM_MODEL), (JsonElement)json);
            }
        });
    }

    public void generateAssets(KubeAssetGenerator generator) {
        generator.blockState(this.id, stateGenerator -> stateGenerator.simpleVariant("", CustomMachinery.rl("block/custom_machine_block")));
    }
}

