/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.crafting.IProcessorTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.ICustomMachine;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.machine.MachineAppearanceManager;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CustomMachine
implements ICustomMachine {
    public static final ResourceLocation DUMMY_ID = CustomMachinery.rl("dummy");
    public static final NamedCodec<CustomMachine> CODEC = NamedCodec.record(machineCodec -> machineCodec.group(TextComponentUtils.CODEC.fieldOf("name").forGetter(machine -> machine.name), MachineAppearanceManager.CODEC.optionalFieldOf("appearance", MachineAppearanceManager.DEFAULT).forGetter(machine -> machine.appearance), TextComponentUtils.CODEC.listOf().optionalFieldOf("tooltips", Collections.emptyList()).forGetter(CustomMachine::getTooltips), IGuiElement.CODEC.listOf().optionalFieldOf("gui", Collections.emptyList()).forGetter(CustomMachine::getGuiElements), IGuiElement.CODEC.listOf().optionalFieldOf("jei", Collections.emptyList()).forGetter(CustomMachine::getJeiElements), DefaultCodecs.RESOURCE_LOCATION.listOf().optionalFieldOf("catalysts", Collections.emptyList()).forGetter(CustomMachine::getCatalysts), IMachineComponentTemplate.CODEC.listOf().optionalFieldOf("components", Collections.emptyList()).forGetter(CustomMachine::getComponentTemplates), IProcessorTemplate.CODEC.optionalFieldOf("processor", MachineProcessor.Template.DEFAULT).forGetter(CustomMachine::getProcessorTemplate)).apply((Applicative)machineCodec, CustomMachine::new), "Custom machine");
    public static final CustomMachine DUMMY = new CustomMachineBuilder().setName((Component)Component.literal((String)"Dummy")).setLocation(MachineLocation.fromDefault(DUMMY_ID, "")).setId(DUMMY_ID).build();
    private final Component name;
    private final MachineAppearanceManager appearance;
    private final List<Component> tooltips;
    private final List<IGuiElement> guiElements;
    private final List<IGuiElement> jeiElements;
    private final List<ResourceLocation> catalysts;
    private final List<IMachineComponentTemplate<? extends IMachineComponent>> componentTemplates;
    private final IProcessorTemplate<? extends IProcessor> processorTemplate;
    private MachineLocation location;

    public CustomMachine(Component name, MachineAppearanceManager appearance, List<Component> tooltips, List<IGuiElement> guiElements, List<IGuiElement> jeiElements, List<ResourceLocation> catalysts, List<IMachineComponentTemplate<? extends IMachineComponent>> componentTemplates, IProcessorTemplate<? extends IProcessor> processorTemplate) {
        this.name = name;
        this.appearance = appearance;
        this.tooltips = tooltips;
        this.guiElements = guiElements;
        this.jeiElements = jeiElements;
        this.catalysts = catalysts;
        this.componentTemplates = componentTemplates;
        this.processorTemplate = processorTemplate;
    }

    @Override
    public ResourceLocation getId() {
        return this.location.id();
    }

    @Override
    public List<ResourceLocation> getRecipeIds() {
        return Collections.singletonList(this.getId());
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public boolean isDummy() {
        return this == DUMMY;
    }

    @Override
    public MachineAppearance getAppearance(MachineStatus status) {
        return this.appearance.getAppearance(status);
    }

    public IProcessorTemplate<? extends IProcessor> getProcessorTemplate() {
        return this.processorTemplate;
    }

    public MachineAppearanceManager getAppearanceManager() {
        return this.appearance;
    }

    public List<Component> getTooltips() {
        return this.tooltips;
    }

    @Override
    public List<IGuiElement> getGuiElements() {
        return this.guiElements;
    }

    public List<IGuiElement> getJeiElements() {
        return this.jeiElements;
    }

    public List<ResourceLocation> getCatalysts() {
        return this.catalysts;
    }

    public List<IMachineComponentTemplate<? extends IMachineComponent>> getComponentTemplates() {
        return this.componentTemplates;
    }

    public CustomMachine setLocation(MachineLocation location) {
        this.location = location;
        return this;
    }

    public MachineLocation getLocation() {
        return this.location;
    }
}

