/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.ItemIngredientWrapper;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record ItemRequirement(RequirementIOMode mode, SizedIngredient ingredient, String slot, boolean consumeOnEnd) implements IRequirement<ItemComponentHandler>,
IJEIIngredientRequirement<ItemStack>
{
    public static final NamedCodec<ItemRequirement> CODEC = NamedCodec.record(itemRequirementInstance -> itemRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(ItemRequirement::getMode), NamedCodec.of(SizedIngredient.FLAT_CODEC).fieldOf("ingredient").aliases("item").forGetter(requirement -> requirement.ingredient), NamedCodec.STRING.optionalFieldOf("slot", "").forGetter(requirement -> requirement.slot), NamedCodec.BOOL.optionalFieldOf("consume_on_end", false).forGetter(requirement -> requirement.consumeOnEnd)).apply((Applicative)itemRequirementInstance, ItemRequirement::new), "Item requirement");

    public ItemRequirement(RequirementIOMode mode, SizedIngredient ingredient, String slot, boolean consumeOnEnd) {
        this.mode = mode;
        if (mode == RequirementIOMode.OUTPUT && ingredient.getItems().length > 1) {
            throw new IllegalArgumentException("You can't use a Tag for an Output Item Requirement");
        }
        this.ingredient = ingredient;
        this.slot = slot == null ? "" : slot;
        this.consumeOnEnd = consumeOnEnd;
    }

    @Override
    public RequirementType<ItemRequirement> getType() {
        return Registration.ITEM_REQUIREMENT.get();
    }

    @Override
    public MachineComponentType getComponentType() {
        return Registration.ITEM_MACHINE_COMPONENT.get();
    }

    @Override
    public RequirementIOMode getMode() {
        return this.mode;
    }

    @Override
    public boolean test(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.ingredient.count(), this, null);
        if (this.getMode() == RequirementIOMode.INPUT) {
            return component.getIngredientAmount(this.slot, this.ingredient.ingredient()) >= amount;
        }
        if (this.ingredient.getItems().length > 0) {
            return component.getSpaceForItem(this.slot, this.ingredient.getItems()[0]) >= amount;
        }
        throw new IllegalStateException("Can't use output empty item");
    }

    @Override
    public void gatherRequirements(IRequirementList<ItemComponentHandler> list) {
        if (this.mode == RequirementIOMode.INPUT) {
            if (this.consumeOnEnd) {
                list.inventoryCondition(this::checkInputs);
                list.processOnEnd(this::processInputs);
            } else {
                list.processOnStart(this::processInputs);
            }
        } else {
            list.processOnEnd(this::processOutputs);
        }
    }

    private CraftingResult checkInputs(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.ingredient.count(), this, null);
        int maxExtract = component.getIngredientAmount(this.slot, this.ingredient.ingredient());
        if (maxExtract >= amount) {
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.item.error.input", (Object[])new Object[]{Utils.itemIngredientName(this.ingredient), amount, maxExtract}));
    }

    private CraftingResult processInputs(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.ingredient.count(), this, null);
        int maxExtract = component.getIngredientAmount(this.slot, this.ingredient.ingredient());
        if (maxExtract >= amount) {
            component.removeFromInputs(this.slot, this.ingredient.ingredient(), amount);
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.item.error.input", (Object[])new Object[]{Utils.itemIngredientName(this.ingredient), amount, maxExtract}));
    }

    private CraftingResult processOutputs(ItemComponentHandler component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.ingredient.count(), this, null);
        if (this.ingredient.getItems().length > 0) {
            ItemStack item = this.ingredient.getItems()[0];
            int canInsert = component.getSpaceForItem(this.slot, item);
            if (canInsert >= amount) {
                component.addToOutputs(this.slot, item.copy(), amount);
                return CraftingResult.success();
            }
            return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.item.error.output", (Object[])new Object[]{amount, item.getHoverName()}));
        }
        throw new IllegalStateException("Can't use output item requirement with item tag");
    }

    @Override
    public List<IJEIIngredientWrapper<ItemStack>> getJEIIngredientWrappers(IMachineRecipe recipe, RecipeRequirement<?, ?> requirement) {
        return Collections.singletonList(new ItemIngredientWrapper(this.getMode(), this.ingredient, requirement.chance(), false, this.slot, true));
    }
}

