/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.upgrade;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.integration.kubejs.KubeJSIntegration;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.UpgradeLocation;
import fr.frinn.custommachinery.common.util.CustomJsonReloadListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Items;
import net.neoforged.fml.ModList;
import org.apache.logging.log4j.Logger;

public class UpgradesCustomReloadListener
extends CustomJsonReloadListener {
    private static final String MAIN_PACKNAME = "main";

    public UpgradesCustomReloadListener() {
        super("upgrade", "upgrades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        Logger logger = ICustomMachineryAPI.INSTANCE.logger();
        HashMap<UpgradeLocation, MachineUpgrade> upgrades = new HashMap<UpgradeLocation, MachineUpgrade>();
        logger.info("Reading Custom Machinery Upgrades json");
        map.forEach((id, json) -> {
            String packName;
            try {
                packName = resourceManager.getResourceOrThrow(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("upgrades/" + id.getPath() + ".json"))).sourcePackId();
            }
            catch (IOException e) {
                packName = MAIN_PACKNAME;
            }
            logger.info("Parsing upgrade json: {} in datapack: {}", id, (Object)packName);
            if (!json.isJsonObject()) {
                logger.error("Bad upgrade JSON: {} must be a json object and not an array or primitive, skipping...", id);
                return;
            }
            DataResult<MachineUpgrade> result = MachineUpgrade.CODEC.read(JsonOps.INSTANCE, json);
            if (result.result().isPresent()) {
                MachineUpgrade upgrade = (MachineUpgrade)result.result().get();
                if (upgrade.item() == Items.AIR) {
                    logger.error("Invalid item: {}, defined for upgrade: {}", (Object)BuiltInRegistries.ITEM.getKey((Object)upgrade.item()), id);
                    return;
                }
                logger.info("Successfully parsed upgrade json: {}", id);
                upgrades.put(this.getUpgradeLocation(resourceManager, (ResourceLocation)id), upgrade);
                return;
            }
            if (result.error().isPresent()) {
                logger.error("Error while parsing upgrade json: {}, skipping...\n{}", id, (Object)((DataResult.Error)result.error().get()).message());
                return;
            }
            throw new IllegalStateException("No success nor error when parsing machine json: " + String.valueOf(id) + ". This can't happen.");
        });
        if (!upgrades.isEmpty()) {
            logger.info("Successfully parsed {} upgrade json.", (Object)upgrades.size());
        } else {
            logger.info("No machine upgrade json found.");
        }
        if (ModList.get().isLoaded("kubejs")) {
            logger.info("Collecting machine upgrades with kubeJS.");
            Map<UpgradeLocation, MachineUpgrade> kubejsUpgrades = KubeJSIntegration.collectMachineUpgrades();
            if (!kubejsUpgrades.isEmpty()) {
                logger.info("Successfully added {} machine upgrades with kubejs", (Object)kubejsUpgrades.size());
            } else {
                logger.info("No machine upgrades found with kubejs");
            }
            upgrades.putAll(kubejsUpgrades);
        }
        logger.info("Finished creating custom machine upgrades.");
        CustomMachinery.UPGRADES.refresh(upgrades);
    }

    /*
     * Exception decompiling
     */
    private UpgradeLocation getUpgradeLocation(ResourceManager resourceManager, ResourceLocation id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK], 12[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

