/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.RecordBuilder;
import java.util.Comparator;
import java.util.Map;

public class MachineJsonOps
extends JsonOps {
    public static final MachineJsonOps INSTANCE = new MachineJsonOps(false);

    private MachineJsonOps(boolean compressed) {
        super(compressed);
    }

    public RecordBuilder<JsonElement> mapBuilder() {
        return new JsonRecordBuilder(this);
    }

    private class JsonRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<JsonElement, JsonObject> {
        protected JsonRecordBuilder(MachineJsonOps machineJsonOps) {
            super((DynamicOps)machineJsonOps);
        }

        protected JsonObject initBuilder() {
            return new JsonObject();
        }

        protected JsonObject append(String key, JsonElement value, JsonObject builder) {
            builder.add(key, value);
            return builder;
        }

        protected DataResult<JsonElement> build(JsonObject builder, JsonElement prefix) {
            JsonObject output = new JsonObject();
            builder.entrySet().stream().sorted(Comparator.comparingInt(entry -> this.compareKeys((String)entry.getKey()))).forEach(entry -> output.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            if (prefix == null || prefix instanceof JsonNull) {
                return DataResult.success((Object)output);
            }
            if (prefix instanceof JsonObject) {
                JsonObject result = new JsonObject();
                for (Map.Entry entry2 : prefix.getAsJsonObject().entrySet()) {
                    result.add((String)entry2.getKey(), (JsonElement)entry2.getValue());
                }
                for (Map.Entry entry2 : output.entrySet()) {
                    result.add((String)entry2.getKey(), (JsonElement)entry2.getValue());
                }
                return DataResult.success((Object)result);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(prefix), (Object)prefix);
        }

        private int compareKeys(String key) {
            return -(switch (key) {
                case "type" -> 10000;
                case "name" -> 1000;
                case "appearance" -> 900;
                case "components" -> 800;
                case "gui" -> 700;
                default -> 0;
            });
        }
    }
}

