/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.transfer;

import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.impl.component.config.IOSideMode;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class SidedFluidHandler
implements IFluidHandler {
    private final Direction side;
    private final FluidComponentHandler handler;

    public SidedFluidHandler(Direction side, FluidComponentHandler handler) {
        this.side = side;
        this.handler = handler;
    }

    public List<FluidMachineComponent> getComponentsForMode(Predicate<IOSideMode> filter) {
        return this.handler.getComponents().stream().filter(component -> filter.test((IOSideMode)component.getConfig().getDirectionMode(this.side))).toList();
    }

    public int getTanks() {
        return this.handler.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.handler.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.handler.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.handler.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack toFill = resource.copy();
        for (FluidMachineComponent component : this.getComponentsForMode(IOSideMode::isInput)) {
            toFill.shrink(component.fill(toFill, action));
            if (!toFill.isEmpty()) continue;
            break;
        }
        return resource.getAmount() - toFill.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int toDrain = 0;
        for (FluidMachineComponent component : this.getComponentsForMode(IOSideMode::isOutput)) {
            if ((toDrain += component.drain(resource.copyWithAmount(resource.getAmount() - toDrain), action).getAmount()) == resource.getAmount()) break;
        }
        return resource.copyWithAmount(toDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (FluidMachineComponent component : this.getComponentsForMode(IOSideMode::isOutput)) {
            FluidStack drained = component.drain(maxDrain, action);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }
}

