/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.transfer;

import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.component.item.ItemMachineComponent;
import fr.frinn.custommachinery.impl.component.config.IOSideMode;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class SidedItemHandler
implements IItemHandler {
    private final Direction direction;
    private final ItemComponentHandler handler;

    public SidedItemHandler(Direction direction, ItemComponentHandler handler) {
        this.direction = direction;
        this.handler = handler;
    }

    public ItemComponentHandler getHandler() {
        return this.handler;
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return ((ItemMachineComponent)this.handler.getComponents().get(slot)).getItemStack();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemMachineComponent component = (ItemMachineComponent)this.handler.getComponents().get(slot);
        if (this.direction != null && !((IOSideMode)component.getConfig().getDirectionMode(this.direction)).isInput()) {
            return stack;
        }
        return component.insertItem(0, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemMachineComponent component = (ItemMachineComponent)this.handler.getComponents().get(slot);
        if (this.direction != null && !((IOSideMode)component.getConfig().getDirectionMode(this.direction)).isOutput() || component.getItemStack().isEmpty()) {
            return ItemStack.EMPTY;
        }
        return component.extractItem(0, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.handler.isItemValid(slot, stack);
    }
}

