/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.integration.jei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;

public record Experience(int xp, int capacity, double chance, boolean isPerTick, Form type) {
    public static final Codec<Experience> CODEC = RecordCodecBuilder.create(experienceInstance -> experienceInstance.group((App)Codec.INT.fieldOf("xp").forGetter(Experience::xp), (App)Codec.INT.fieldOf("capacity").forGetter(Experience::capacity), (App)Codec.DOUBLE.fieldOf("chance").forGetter(Experience::chance), (App)Codec.BOOL.fieldOf("perTick").forGetter(Experience::isPerTick), (App)StringRepresentable.fromEnum(Form::values).fieldOf("form").forGetter(Experience::type)).apply((Applicative)experienceInstance, Experience::new));

    public Experience(int xp, double chance, boolean isPerTick, Form type) {
        this(xp, xp, chance, isPerTick, type);
    }

    public int getLevels() {
        int experienceLevel = 0;
        return experienceLevel;
    }

    public boolean isLevels() {
        return this.type == Form.LEVEL;
    }

    public boolean isPoints() {
        return this.type == Form.POINT;
    }

    private int getXpNeededForNextLevel(int experienceLevel) {
        if (experienceLevel >= 30) {
            return 112 + (experienceLevel - 30) * 9;
        }
        return experienceLevel >= 15 ? 37 + (experienceLevel - 15) * 5 : 7 + experienceLevel * 2;
    }

    private int getFromExperiencePoints(int xp) {
        int experienceLevel = 0;
        xp = Mth.clamp((int)xp, (int)0, (int)Integer.MAX_VALUE);
        float experienceProgress = (float)xp / (float)this.getXpNeededForNextLevel(experienceLevel);
        while (experienceProgress < 0.0f) {
            float f = experienceProgress * (float)this.getXpNeededForNextLevel(experienceLevel);
            if (experienceLevel > 0) {
                experienceProgress = 1.0f + f / (float)this.getXpNeededForNextLevel(--experienceLevel);
                continue;
            }
            --experienceLevel;
            experienceProgress = 0.0f;
        }
        while (experienceProgress >= 1.0f) {
            experienceProgress = (experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel(experienceLevel);
            experienceProgress /= (float)this.getXpNeededForNextLevel(++experienceLevel);
        }
        return experienceLevel;
    }

    public static enum Form implements StringRepresentable
    {
        LEVEL,
        POINT;


        public boolean isLevel() {
            return this == LEVEL;
        }

        public boolean isPoint() {
            return this == POINT;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

