/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.util;

import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class EnumButton<E>
extends Button {
    private final Function<E, Component> messageFunction;
    private final List<E> values;
    private E value;

    public EnumButton(int x, int y, int width, int height, Button.OnPress pressedAction, Function<E, Component> messageFunction, List<E> values, E defaultValue) {
        super(x, y, width, height, (Component)Component.empty(), pressedAction, s -> Component.empty());
        this.messageFunction = messageFunction;
        this.values = values;
        this.value = this.values.contains(defaultValue) ? defaultValue : this.values.get(0);
    }

    public void onPress() {
        this.nextValue();
        super.onPress();
    }

    public Component getMessage() {
        return this.messageFunction.apply(this.value);
    }

    public E getValue() {
        return this.value;
    }

    private void nextValue() {
        int index = this.values.indexOf(this.value);
        index = index < this.values.size() - 1 ? ++index : 0;
        this.value = this.values.get(index);
    }
}

