/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.common.command.CMCommand;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.common.config.CMConfig;
import fr.frinn.custommachinery.common.init.BoxCreatorItem;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.integration.theoneprobe.TOPInfoProvider;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.CustomMachineJsonReloadListener;
import fr.frinn.custommachinery.common.network.SLootTablesPacket;
import fr.frinn.custommachinery.common.network.SUpdateMachinesPacket;
import fr.frinn.custommachinery.common.network.SUpdateTemplatesPacket;
import fr.frinn.custommachinery.common.network.SUpdateUpgradesPacket;
import fr.frinn.custommachinery.common.upgrade.Upgrades;
import fr.frinn.custommachinery.common.upgrade.UpgradesCustomReloadListener;
import fr.frinn.custommachinery.common.util.CMLogger;
import fr.frinn.custommachinery.common.util.LoggingLevel;
import fr.frinn.custommachinery.common.util.LootTableHelper;
import fr.frinn.custommachinery.impl.util.TextureInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.CommandEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="custommachinery")
public class CustomMachinery {
    public static final String MODID = "custommachinery";
    public static Logger LOGGER = LogManager.getLogger((String)"Custom Machinery");
    public static final Map<ResourceLocation, CustomMachine> MACHINES = new HashMap<ResourceLocation, CustomMachine>();
    public static final Map<ResourceLocation, Pair<CustomMachine, Component>> TEMPLATES = new HashMap<ResourceLocation, Pair<CustomMachine, Component>>();
    public static final BiMap<ResourceLocation, CustomMachineBlock> CUSTOM_BLOCK_MACHINES = HashBiMap.create();
    public static final Upgrades UPGRADES = new Upgrades();

    public CustomMachinery(ModContainer CONTAINER, IEventBus MOD_BUS) {
        CONTAINER.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CMConfig.CONFIG_SPEC);
        Registration.BLOCKS.register(MOD_BUS);
        Registration.DATA_COMPONENTS.register(MOD_BUS);
        Registration.ITEMS.register(MOD_BUS);
        Registration.TILE_ENTITIES.register(MOD_BUS);
        Registration.MENUS.register(MOD_BUS);
        Registration.RECIPE_SERIALIZERS.register(MOD_BUS);
        Registration.RECIPE_TYPES.register(MOD_BUS);
        Registration.CREATIVE_TABS.register(MOD_BUS);
        Registration.GUI_ELEMENTS.register(MOD_BUS);
        Registration.MACHINE_COMPONENTS.register(MOD_BUS);
        Registration.REQUIREMENTS.register(MOD_BUS);
        Registration.APPEARANCE_PROPERTIES.register(MOD_BUS);
        Registration.DATAS.register(MOD_BUS);
        Registration.PROCESSORS.register(MOD_BUS);
        MOD_BUS.addListener(this::commonSetup);
        MOD_BUS.addListener(this::sendIMCMessages);
        MOD_BUS.addListener(this::registerCapabilities);
        MOD_BUS.addListener(this::reloadConfig);
        IEventBus GAME_BUS = NeoForge.EVENT_BUS;
        GAME_BUS.addListener(this::serverStarting);
        GAME_BUS.addListener(this::syncDatapacks);
        GAME_BUS.addListener(this::registerReloadListener);
        GAME_BUS.addListener(this::registerCommands);
        GAME_BUS.addListener(this::boxRendererLeftClick);
        GAME_BUS.addListener(this::onReloadStart);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        CMLogger.init();
    }

    private void sendIMCMessages(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPInfoProvider::new);
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Registration.CUSTOM_MACHINE_TILE.get(), (be, side) -> be.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).map(handler -> ((ItemComponentHandler)handler).getItemHandlerForSide((Direction)side)).orElse(null));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Registration.CUSTOM_MACHINE_TILE.get(), (be, side) -> be.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).map(handler -> ((FluidComponentHandler)handler).getFluidHandler((Direction)side)).orElse(null));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Registration.CUSTOM_MACHINE_TILE.get(), (be, side) -> be.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).map(energy -> energy.getEnergyStorage((Direction)side)).orElse(null));
    }

    private void reloadConfig(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == CMConfig.CONFIG_SPEC) {
            CMLogger.setDebugLevel(((LoggingLevel)((Object)CMConfig.CONFIG.debugLevel.get())).getLevel());
        }
    }

    private void serverStarting(ServerStartingEvent event) {
        LootTableHelper.generate(event.getServer());
    }

    private void syncDatapacks(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            CustomMachinery.syncData(event.getPlayer());
        } else {
            LootTableHelper.generate(event.getPlayerList().getServer());
            event.getPlayerList().getPlayers().forEach(CustomMachinery::syncData);
        }
    }

    private void registerReloadListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new CustomMachineJsonReloadListener());
        event.addListener((PreparableReloadListener)new UpgradesCustomReloadListener());
    }

    public static void syncData(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SUpdateMachinesPacket(MACHINES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SUpdateTemplatesPacket(TEMPLATES), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SUpdateUpgradesPacket(UPGRADES.getAllUpgrades()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SLootTablesPacket(LootTableHelper.getLoots()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(CMCommand.register(MODID));
        event.getDispatcher().register(CMCommand.register("cm"));
    }

    private void boxRendererLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).getItemInHand(event.getHand()).getItem() instanceof BoxCreatorItem) {
            BoxCreatorItem.setSelectedBlock(true, player.getItemInHand(event.getHand()), event.getPos());
        }
    }

    private void onReloadStart(CommandEvent event) {
        if (event.getParseResults().getReader().getString().equals("reload") && ((CommandSourceStack)event.getParseResults().getContext().getSource()).hasPermission(2)) {
            CMLogger.reset();
        }
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static TextureInfo texture(String path) {
        return new TextureInfo(CustomMachinery.rl(path));
    }
}

