/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.render.BoxCreatorRenderer;
import fr.frinn.custommachinery.client.render.StructureCreatorRenderer;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.common.upgrade.RecipeModifier;
import fr.frinn.custommachinery.common.util.FileUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="custommachinery", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        CustomMachinery.UPGRADES.getUpgradesForItem(event.getItemStack().getItem()).forEach(upgrade -> {
            block3: {
                block2: {
                    event.getToolTip().addAll(upgrade.getTooltips());
                    if (Screen.hasControlDown()) break block2;
                    if (!Screen.hasShiftDown()) break block3;
                }
                upgrade.getModifiers().stream().map(RecipeModifier::getTooltip).forEach(event.getToolTip()::add);
            }
        });
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            BoxCreatorRenderer.renderSelectedBlocks(event.getPoseStack());
            StructureCreatorRenderer.renderSelectedBlocks(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        MachineEditScreen screen;
        Screen screen2;
        if (event.getPlayer() != null && (screen2 = Minecraft.getInstance().screen) instanceof MachineEditScreen && (screen = (MachineEditScreen)screen2).isChanged()) {
            FileUtils.writeTempMachineJson(Minecraft.getInstance().gameDirectory, screen.getBuilder());
        }
    }
}

