/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import com.google.common.collect.Lists;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.common.component.ExperienceMachineComponent;
import fr.frinn.custommachinery.common.guielement.ExperienceGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.ExperienceUtils;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.guielement.TexturedGuiElementWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ExperienceGuiElementWidget
extends TexturedGuiElementWidget<ExperienceGuiElement> {
    private static final Component TITLE = Component.translatable((String)"custommachinery.gui.element.experience.name");

    public ExperienceGuiElementWidget(ExperienceGuiElement element, IMachineScreen screen) {
        super(element, screen, TITLE);
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!((ExperienceGuiElement)this.getElement()).getMode().isDisplayBar()) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        } else {
            Optional<ExperienceMachineComponent> component = this.getScreen().getTile().getComponentManager().getComponent(Registration.EXPERIENCE_MACHINE_COMPONENT.get());
            int level = component.map(ExperienceMachineComponent::getLevels).orElse(0);
            int xp = component.map(ExperienceMachineComponent::getXp).orElse(0);
            String levels = "" + level;
            int xPos = this.getX() + this.width / 2 - Minecraft.getInstance().font.width(levels) / 2;
            graphics.drawString(Minecraft.getInstance().font, levels, xPos, this.getY(), 8453920, true);
            graphics.fill(this.getX(), this.getY() + 9, this.getX() + this.width, this.getY() + 12, -16777216);
            int xpDiff = xp - ExperienceUtils.getXpFromLevel(level);
            if (xpDiff > 0) {
                double percent = (double)xpDiff / (double)ExperienceUtils.getXpNeededForNextLevel(level);
                graphics.fill(this.getX() + 1, this.getY() + 10, this.getX() + 1 + Math.max((int)Math.ceil((double)this.width * percent) - 2, 0), this.getY() + 11, -8323296);
            }
        }
    }

    @Override
    public List<Component> getTooltips() {
        ArrayList tooltips = Lists.newArrayList();
        this.getScreen().getTile().getComponentManager().getComponent(Registration.EXPERIENCE_MACHINE_COMPONENT.get()).ifPresent(component -> {
            if (((ExperienceGuiElement)this.getElement()).getMode().isDisplay()) {
                tooltips.add(TITLE);
                switch (((ExperienceGuiElement)this.getElement()).getDisplayMode()) {
                    case LITERAL: {
                        String value = Utils.format(component.getXp());
                        String capacityValue = Utils.format(component.getCapacity()) + " XP";
                        tooltips.add(Component.translatable((String)"custommachinery.gui.element.experience.tooltip", (Object[])new Object[]{value, capacityValue}).withStyle(ChatFormatting.GRAY));
                        break;
                    }
                    case LEVEL: {
                        String value = "" + component.getLevels();
                        String capacityValue = component.getCapacityLevels() + " levels";
                        tooltips.add(Component.translatable((String)"custommachinery.gui.element.experience.tooltip", (Object[])new Object[]{value, capacityValue}).withStyle(ChatFormatting.GRAY));
                        break;
                    }
                    case BOTH: {
                        String literal = Utils.format(component.getXp());
                        String capacityLiteral = Utils.format(component.getCapacity()) + "XP";
                        String level = "" + component.getLevels();
                        String capacityLevel = component.getCapacityLevels() + " levels";
                        tooltips.addAll(Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"custommachinery.gui.element.experience.tooltip", (Object[])new Object[]{literal, capacityLiteral}).withStyle(ChatFormatting.GRAY), Component.translatable((String)"custommachinery.gui.element.experience.tooltip", (Object[])new Object[]{level, capacityLevel}).withStyle(ChatFormatting.GRAY)}));
                    }
                }
            } else {
                tooltips.add(((ExperienceGuiElement)this.getElement()).getMode().title());
            }
        });
        return tooltips;
    }
}

