/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.client.integration.jei.AbstractRecipeCategory;
import fr.frinn.custommachinery.client.integration.jei.wrapper.ItemIngredientWrapper;
import fr.frinn.custommachinery.common.component.item.ItemMachineComponent;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import java.util.List;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public class CustomCraftRecipeCategory
extends AbstractRecipeCategory<CustomCraftRecipe> {
    public CustomCraftRecipeCategory(final CustomMachine machine, RecipeType<CustomCraftRecipe> type, IJeiHelpers helpers) {
        super(machine, type, helpers);
        this.wrapperCache = CacheBuilder.newBuilder().build(new CacheLoader<CustomCraftRecipe, List<IJEIIngredientWrapper<?>>>(this){

            public List<IJEIIngredientWrapper<?>> load(CustomCraftRecipe recipe) {
                ImmutableList.Builder wrappers = ImmutableList.builder();
                recipe.getDisplayInfoRequirements().forEach(requirement -> wrappers.addAll(requirement.getJeiIngredientWrappers(recipe)));
                String resultSlot = machine.getComponentTemplates().stream().filter(template -> {
                    ItemMachineComponent.Template slotTemplate;
                    return template instanceof ItemMachineComponent.Template && (slotTemplate = (ItemMachineComponent.Template)template).getType() == Registration.ITEM_RESULT_MACHINE_COMPONENT.get();
                }).findFirst().map(IMachineComponentTemplate::getId).orElse("");
                wrappers.add((Object)new ItemIngredientWrapper(RequirementIOMode.OUTPUT, new SizedIngredient(Ingredient.of((ItemStack[])new ItemStack[]{recipe.getOutput()}), recipe.getOutput().getCount()), 1.0, false, resultSlot, false));
                return wrappers.build();
            }
        });
    }
}

