/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.client.render.BoxRenderer;
import fr.frinn.custommachinery.client.render.StructureRenderer;
import fr.frinn.custommachinery.common.config.CMConfig;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.util.BlockIngredient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CustomMachineRenderer
implements BlockEntityRenderer<CustomMachineTile> {
    private static final Map<ResourceLocation, BoxRenderer> boxToRender = new HashMap<ResourceLocation, BoxRenderer>();
    private static final Map<ResourceLocation, StructureRenderer> blocksToRender = new HashMap<ResourceLocation, StructureRenderer>();

    public CustomMachineRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CustomMachineTile tile, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile.getLevel() == null) {
            return;
        }
        ResourceLocation machineId = tile.getId();
        Direction machineFacing = (Direction)tile.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (boxToRender.containsKey(machineId)) {
            BoxRenderer boxRenderer = boxToRender.get(machineId);
            if (boxRenderer.shouldRender()) {
                boxRenderer.render(matrix, buffer, machineFacing);
            } else {
                boxToRender.remove(machineId);
            }
        }
        if (blocksToRender.containsKey(machineId)) {
            StructureRenderer structureRenderer = blocksToRender.get(machineId);
            if (structureRenderer.shouldRender()) {
                structureRenderer.render(matrix, buffer, machineFacing, tile.getLevel(), tile.getBlockPos());
            } else {
                blocksToRender.remove(machineId);
            }
        }
    }

    public static void addRenderBox(ResourceLocation machine, AABB box) {
        boxToRender.put(machine, new BoxRenderer((Integer)CMConfig.CONFIG.boxRenderTime.get(), box));
    }

    public static void addRenderBlock(ResourceLocation machine, Function<Direction, Map<BlockPos, List<BlockIngredient>>> blocks) {
        blocksToRender.put(machine, new StructureRenderer((Integer)CMConfig.CONFIG.structureRenderTime.get(), blocks));
    }
}

