/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen;

import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.guielement.BackgroundGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import fr.frinn.custommachinery.impl.guielement.GuiElementWidgetSupplierRegistry;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class CustomMachineScreen
extends AbstractContainerScreen<CustomMachineContainer>
implements IMachineScreen {
    private final CustomMachineTile tile;
    private final CustomMachine machine;
    @Nullable
    private final BackgroundGuiElement background;

    public CustomMachineScreen(CustomMachineContainer container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.tile = container.getTile();
        this.machine = container.getTile().getMachine();
        this.imageWidth = 256;
        this.imageHeight = 192;
        this.background = this.tile.getGuiElements().stream().filter(element -> element instanceof BackgroundGuiElement).map(element -> (BackgroundGuiElement)element).findFirst().orElse(null);
        if (this.background != null) {
            this.imageWidth = this.background.getWidth();
            this.imageHeight = this.background.getHeight();
        }
    }

    protected void init() {
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.tile.getGuiElements().stream().filter(element -> GuiElementWidgetSupplierRegistry.hasWidgetSupplier(element.getType())).sorted(Comparators.GUI_ELEMENTS_COMPARATOR.reversed()).forEach(element -> this.addRenderableWidget((GuiEventListener)GuiElementWidgetSupplierRegistry.getWidgetSupplier(element.getType()).get((IGuiElement)element, this)));
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        if (this.background != null && this.background.getTexture() != null) {
            ClientHandler.blit(graphics, this.background.getTexture(), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        this.children().stream().filter(widget -> {
            AbstractGuiElementWidget element;
            return widget instanceof AbstractGuiElementWidget && (element = (AbstractGuiElementWidget)((Object)widget)).isMouseOver(mouseX, mouseY) && !element.getTooltips().isEmpty();
        }).map(widget -> (AbstractGuiElementWidget)((Object)widget)).min((w1, w2) -> Comparators.GUI_ELEMENTS_COMPARATOR.compare((IGuiElement)w1.getElement(), (IGuiElement)w2.getElement())).ifPresent(element -> graphics.renderTooltip(this.font, element.getTooltips().stream().flatMap(tooltip -> this.font.split((FormattedText)tooltip, 100).stream()).toList(), mouseX - this.leftPos, mouseY - this.topPos));
    }

    @Override
    public int getX() {
        return this.leftPos;
    }

    @Override
    public int getY() {
        return this.topPos;
    }

    @Override
    public int getWidth() {
        return this.imageWidth;
    }

    @Override
    public int getHeight() {
        return this.imageHeight;
    }

    @Override
    public CustomMachine getMachine() {
        return this.machine;
    }

    @Override
    public CustomMachineTile getTile() {
        return this.tile;
    }

    public Optional<AbstractGuiElementWidget<?>> getElementUnderMouse(double mouseX, double mouseY) {
        for (GuiEventListener widget : this.children()) {
            AbstractGuiElementWidget elementWidget;
            if (!(widget instanceof AbstractGuiElementWidget) || !(elementWidget = (AbstractGuiElementWidget)widget).isMouseOver(mouseX, mouseY)) continue;
            return Optional.of(elementWidget);
        }
        return Optional.empty();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

