/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineCreationScreen;
import fr.frinn.custommachinery.client.screen.widget.ListWidget;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MachineListWidget
extends ListWidget<MachineEntry> {
    private final MachineCreationScreen parent;

    public MachineListWidget(MachineCreationScreen parent, int x, int y, int width, int height, int itemHeight) {
        super(x, y, width, height, itemHeight, (Component)Component.empty());
        this.parent = parent;
        this.setRenderSelection();
    }

    public void reload() {
        this.clear();
        CustomMachinery.MACHINES.values().stream().sorted(Comparator.comparing(machine -> machine.getName().getString())).forEach(machine -> this.addEntry(new MachineEntry((CustomMachine)machine)));
    }

    public static class MachineEntry
    extends ListWidget.Entry {
        private final Minecraft mc = Minecraft.getInstance();
        private final CustomMachine machine;

        public MachineEntry(CustomMachine machine) {
            this.machine = machine;
        }

        public CustomMachine getMachine() {
            return this.machine;
        }

        @Override
        public void render(GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
            graphics.renderItem(CustomMachineItem.makeMachineItem(this.machine.getId()), x + 2, y + height / 2 - 8);
            Font font = this.mc.font;
            Component component = this.machine.getName();
            int n = y + height / 2;
            Objects.requireNonNull(this.mc.font);
            graphics.drawString(font, component, x + 20, n - 9 / 2 - 6, 0, false);
            Font font2 = this.mc.font;
            MutableComponent mutableComponent = Component.literal((String)this.machine.getId().toString()).withStyle(ChatFormatting.DARK_GRAY);
            int n2 = y + height / 2;
            Objects.requireNonNull(this.mc.font);
            BaseScreen.drawScaledString(graphics, font2, (Component)mutableComponent, x + 20, n2 - 9 / 2 + 2, 0.8f, 0, false);
            Font font3 = this.mc.font;
            MutableComponent mutableComponent2 = this.machine.getLocation().getLoader().getTranslatedName().withStyle(ChatFormatting.ITALIC);
            int n3 = y + height / 2;
            Objects.requireNonNull(this.mc.font);
            BaseScreen.drawScaledString(graphics, font3, (Component)mutableComponent2, x + 20, n3 - 9 / 2 + 9, 0.7f, 0, false);
        }

        public List<? extends GuiEventListener> children() {
            return Collections.emptyList();
        }
    }
}

