/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiEditorWidget;
import fr.frinn.custommachinery.client.screen.widget.GroupWidget;
import fr.frinn.custommachinery.client.screen.widget.IntegerEditBox;
import fr.frinn.custommachinery.client.screen.widget.IntegerSlider;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class ElementConfigWidget
extends GroupWidget {
    private final GuiEditorWidget parent;
    private final StringWidget title;
    private final Button config;
    private final IntegerSlider priority;
    private final EditBox id;
    private final IntegerEditBox xPos;
    private final IntegerEditBox yPos;
    private final IntegerEditBox width;
    private final IntegerEditBox height;
    private final Button delete;
    private GuiEditorWidget.WidgetEditorWidget<?> widget = null;

    public ElementConfigWidget(int x, int y, int width, int height, GuiEditorWidget parent) {
        super(x, y, width, height, (Component)Component.empty());
        this.parent = parent;
        GridLayout layout = new GridLayout(this.getX(), this.getY());
        layout.defaultCellSetting().paddingTop(4).paddingHorizontal(5);
        GridLayout.RowHelper row = layout.createRowHelper(2);
        LayoutSettings tag = layout.newCellSettings().alignHorizontallyLeft().alignVerticallyMiddle();
        LayoutSettings right = layout.newCellSettings().alignHorizontallyRight();
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.title = (StringWidget)row.addChild((LayoutElement)new StringWidget(width - 10, 9, (Component)Component.literal((String)"Dummy"), Minecraft.getInstance().font), 2);
        this.config = (Button)row.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"custommachinery.gui.creation.gui.config"), button -> {
            if (this.widget != null) {
                this.parent.config(this.widget);
            }
        }).size(80, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.config"))).build(), 2);
        this.priority = (IntegerSlider)row.addChild((LayoutElement)IntegerSlider.builder().bounds(-10, 10).create(0, 0, 80, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.priority")), 2);
        this.id = (EditBox)row.addChild((LayoutElement)new EditBox(Minecraft.getInstance().font, 80, 20, (Component)Component.empty()), 2);
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.x"), Minecraft.getInstance().font), tag);
        this.xPos = (IntegerEditBox)row.addChild((LayoutElement)new IntegerEditBox(Minecraft.getInstance().font, 0, 0, 30, 20, (Component)Component.empty()), right);
        this.xPos.bounds(0, this.parent.getWidth());
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.y"), Minecraft.getInstance().font), tag);
        this.yPos = (IntegerEditBox)row.addChild((LayoutElement)new IntegerEditBox(Minecraft.getInstance().font, 0, 0, 30, 20, (Component)Component.empty()), right);
        this.yPos.bounds(0, this.parent.getHeight());
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.width"), Minecraft.getInstance().font), tag);
        this.width = (IntegerEditBox)row.addChild((LayoutElement)new IntegerEditBox(Minecraft.getInstance().font, 0, 0, 30, 20, (Component)Component.empty()), right);
        this.width.bounds(1, this.parent.getWidth());
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.height"), Minecraft.getInstance().font), tag);
        this.height = (IntegerEditBox)row.addChild((LayoutElement)new IntegerEditBox(Minecraft.getInstance().font, 0, 0, 30, 20, (Component)Component.empty()), right);
        this.height.bounds(1, this.parent.getHeight());
        this.delete = (Button)row.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"custommachinery.gui.creation.delete").withStyle(ChatFormatting.RED), button -> this.parent.delete()).size(80, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.delete"))).build(), 2);
        layout.arrangeElements();
        layout.visitWidgets(this::addWidget);
        ((GroupWidget)this).width = layout.getWidth();
        ((GroupWidget)this).height = layout.getHeight() + 5;
    }

    public void show(GuiEditorWidget.WidgetEditorWidget<?> widget) {
        this.hide();
        this.widget = widget;
        this.visible = true;
        this.active = true;
        this.title.setMessage(widget.getBuilder().type().getTranslatedName());
        this.priority.setValue(widget.getProperties().getPriority());
        this.priority.setResponder(priority -> this.parent.changePriority(priority - widget.getProperties().getPriority()));
        this.id.setValue(widget.getProperties().getId());
        this.id.moveCursorToStart(false);
        this.id.moveCursorToEnd(false);
        this.id.setResponder(id -> {
            widget.getProperties().setId((String)id);
            widget.refreshWidget(null);
            this.parent.setChanged();
            if (this.parent.getWidgets(widget.getBuilder().type(), (String)id).size() > 1) {
                this.id.setTextColor(FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0));
                this.id.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.id.duplicate", (Object[])new Object[]{id})));
            } else {
                this.id.setTextColor(FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
                this.id.setTooltip(null);
            }
        });
        this.xPos.setIntValue(widget.getX() - this.parent.getX());
        this.xPos.setIntResponder(x -> {
            if (x + this.parent.getX() == widget.getX()) {
                return;
            }
            this.parent.memorizeChange(widget);
            widget.setX(x + this.parent.getX());
            this.parent.setChanged();
        });
        this.yPos.setIntValue(widget.getY() - this.parent.getY());
        this.yPos.setIntResponder(y -> {
            if (y + this.parent.getY() == widget.getY()) {
                return;
            }
            this.parent.memorizeChange(widget);
            widget.setY(y + this.parent.getY());
            this.parent.setChanged();
        });
        this.width.setIntValue(widget.getWidth());
        this.width.setIntResponder(width -> {
            if (width.intValue() == widget.getWidth()) {
                return;
            }
            this.parent.memorizeChange(widget);
            widget.setWidth((int)width);
            this.parent.setChanged();
        });
        this.height.setIntValue(widget.getHeight());
        this.height.setIntResponder(height -> {
            if (height.intValue() == widget.getHeight()) {
                return;
            }
            this.parent.memorizeChange(widget);
            widget.setHeight((int)height);
            this.parent.setChanged();
        });
    }

    public void hide() {
        this.widget = null;
        this.visible = false;
        this.active = false;
        this.priority.setResponder(priority -> {});
        this.id.setResponder(id -> {});
        this.xPos.setIntResponder(x -> {});
        this.yPos.setIntResponder(y -> {});
        this.width.setIntResponder(width -> {});
        this.height.setIntResponder(height -> {});
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        BaseScreen.blankBackground(graphics, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
    }
}

