/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiEditorWidget;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.FloatSlider;
import fr.frinn.custommachinery.client.screen.widget.IntegerSlider;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;

public class GridEditorPopup
extends PopupScreen {
    private final GuiEditorWidget editor;
    private Checkbox enabled;
    private IntegerSlider xSpacing;
    private IntegerSlider ySpacing;
    private FloatSlider opacity;

    public GridEditorPopup(BaseScreen parent, GuiEditorWidget editor) {
        super(parent, 256, 128);
        this.editor = editor;
    }

    @Override
    protected void init() {
        super.init();
        GuiEditorWidget.GridSettings defaultSettings = this.editor.getGridSettings();
        GridLayout layout = new GridLayout(this.x + 5, this.y + 5).spacing(5);
        GridLayout.RowHelper row = layout.createRowHelper(2);
        LayoutSettings center = row.newCellSettings().alignHorizontallyCenter();
        LayoutSettings middle = row.newCellSettings().alignVerticallyMiddle();
        Objects.requireNonNull(this.font);
        row.addChild((LayoutElement)new StringWidget(this.xSize - 10, 9, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.grid"), this.font), 2, center);
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.grid.enable"), this.font), middle);
        this.enabled = (Checkbox)row.addChild((LayoutElement)Checkbox.builder((Component)Component.empty(), (Font)this.font).selected(defaultSettings.enabled()).onValueChange((button, value) -> this.applySettings()).build());
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.grid.spacing.x"), this.font), middle);
        this.xSpacing = (IntegerSlider)row.addChild((LayoutElement)IntegerSlider.builder().displayOnlyValue().bounds(1, 50).defaultValue(defaultSettings.xSpacing()).setResponder(value -> this.applySettings()).create(0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.grid.spacing.x")));
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.grid.spacing.y"), this.font), middle);
        this.ySpacing = (IntegerSlider)row.addChild((LayoutElement)IntegerSlider.builder().displayOnlyValue().bounds(1, 50).defaultValue(defaultSettings.ySpacing()).setResponder(value -> this.applySettings()).create(0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.grid.spacing.y")));
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.grid.opacity"), this.font), middle);
        this.opacity = (FloatSlider)row.addChild((LayoutElement)FloatSlider.builder().displayOnlyValue().decimalsToShow(2).bounds(0.0f, 1.0f).defaultValue(defaultSettings.opacity()).setResponder(value -> this.applySettings()).create(0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.grid.opacity")));
        row.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.close"), button -> this.parent.closePopup(this)).size(50, 20).build(), 2, center);
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.ySize = layout.getHeight() + 10;
    }

    private void applySettings() {
        this.editor.setGridSettings(new GuiEditorWidget.GridSettings(this.enabled.selected(), this.xSpacing.intValue(), this.ySpacing.intValue(), this.opacity.floatValue()));
    }
}

