/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class DoubleSlider
extends AbstractSliderButton {
    private final Component baseMessage;
    private final double min;
    private final double max;
    private final boolean onlyValue;
    private final Consumer<Double> responder;

    public static Builder builder() {
        return new Builder();
    }

    private DoubleSlider(int x, int y, int width, int height, Component message, double value, double min, double max, boolean onlyValue, Consumer<Double> responder) {
        super(x, y, width, height, (Component)(onlyValue ? Component.literal((String)String.format("%.2f", Mth.map((double)value, (double)0.0, (double)1.0, (double)min, (double)max))) : Component.empty().append(message).append(": " + (int)Mth.map((double)value, (double)0.0, (double)1.0, (double)min, (double)max))), value);
        this.baseMessage = message;
        this.min = min;
        this.max = max;
        this.onlyValue = onlyValue;
        this.responder = responder;
    }

    public double doubleValue() {
        return Mth.map((double)this.value, (double)0.0, (double)1.0, (double)this.min, (double)this.max);
    }

    public void setValue(double value) {
        this.value = Mth.map((double)value, (double)this.min, (double)this.max, (double)0.0, (double)1.0);
        this.applyValue();
        this.updateMessage();
    }

    protected void updateMessage() {
        if (this.onlyValue) {
            this.setMessage((Component)Component.literal((String)String.format("%.2f", this.doubleValue())));
        } else {
            this.setMessage((Component)Component.empty().append(this.baseMessage).append(String.format(": %.2f", this.doubleValue())));
        }
    }

    protected void applyValue() {
        this.responder.accept(this.doubleValue());
    }

    public static class Builder {
        private double defaultValue = 0.0;
        private double min = 0.0;
        private double max = 1000.0;
        private boolean onlyValue = false;
        private Consumer<Double> responder = value -> {};

        public Builder bounds(double min, double max) {
            this.min = min;
            this.max = max;
            this.defaultValue = Mth.clamp((double)this.defaultValue, (double)this.min, (double)this.max);
            return this;
        }

        public Builder defaultValue(double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder displayOnlyValue() {
            this.onlyValue = true;
            return this;
        }

        public Builder setResponder(Consumer<Double> responder) {
            this.responder = responder;
            return this;
        }

        public DoubleSlider create(int x, int y, int width, int height, Component message) {
            return new DoubleSlider(x, y, width, height, message, Mth.map((double)Mth.clamp((double)this.defaultValue, (double)this.min, (double)this.max), (double)this.min, (double)this.max, (double)0.0, (double)1.0), this.min, this.max, this.onlyValue, this.responder);
        }
    }
}

