/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.creation.tabs.TooltipsTab;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class CustomMachineItem
extends BlockItem {
    public static final TooltipFlag NO_TOOLTIP = new TooltipFlag.Default(true, true);
    @Nullable
    private final ResourceLocation machineID;

    public CustomMachineItem(Block block, Item.Properties properties, @Nullable ResourceLocation machineID) {
        super(block, properties);
        this.machineID = machineID;
    }

    public static Optional<CustomMachine> getMachine(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof CustomMachineItem) {
            CustomMachineItem customMachineItem = (CustomMachineItem)item;
            if (customMachineItem.machineID != null) {
                return Optional.ofNullable(CustomMachinery.MACHINES.get(customMachineItem.machineID));
            }
        }
        return Optional.ofNullable((ResourceLocation)stack.get(Registration.MACHINE_DATA)).flatMap(id -> Optional.ofNullable(CustomMachinery.MACHINES.get(id))).or(() -> Optional.of(CustomMachine.DUMMY));
    }

    public static ItemStack makeMachineItem(ResourceLocation machineId) {
        if (CustomMachinery.CUSTOM_BLOCK_MACHINES.containsKey((Object)machineId)) {
            return ((CustomMachineBlock)((Object)CustomMachinery.CUSTOM_BLOCK_MACHINES.get((Object)machineId))).asItem().getDefaultInstance();
        }
        ItemStack stack = ((CustomMachineItem)((Object)Registration.CUSTOM_MACHINE_ITEM.get())).getDefaultInstance();
        stack.set(Registration.MACHINE_DATA, (Object)machineId);
        return stack;
    }

    public Component getName(ItemStack stack) {
        return CustomMachineItem.getMachine(stack).map(CustomMachine::getName).orElse(super.getName(stack));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!(flag instanceof TooltipsTab.EditorTooltipFlag)) {
            CustomMachineItem.getMachine(stack).map(CustomMachine::getTooltips).ifPresent(tooltip::addAll);
            return;
        }
        TooltipsTab.EditorTooltipFlag editorTooltipFlag = (TooltipsTab.EditorTooltipFlag)flag;
        try {
            List<Component> list;
            List<Component> tooltips = list = editorTooltipFlag.tooltips();
            tooltip.addAll(tooltips);
            return;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public InteractionResult place(BlockPlaceContext blockPlaceContext) {
        Block block;
        if (!blockPlaceContext.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockPlaceContext2 = this.updatePlacementContext(blockPlaceContext);
        if (blockPlaceContext2 == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockState = this.getPlacementState(blockPlaceContext2);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockPlaceContext2, blockState)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockPos = blockPlaceContext2.getClickedPos();
        Level level = blockPlaceContext2.getLevel();
        Player player = blockPlaceContext2.getPlayer();
        ItemStack itemStack = blockPlaceContext2.getItemInHand();
        BlockState blockState2 = level.getBlockState(blockPos);
        if (blockState2.is(blockState.getBlock())) {
            this.updateCustomBlockEntityTag(blockPos, level, player, itemStack, blockState2);
            blockState2.getBlock().setPlacedBy(level, blockPos, blockState2, (LivingEntity)player, itemStack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockPos, itemStack);
            }
        }
        if ((block = blockState2.getBlock()) instanceof CustomMachineBlock) {
            CustomMachineBlock machineBlock = (CustomMachineBlock)block;
            SoundType soundType = machineBlock.getSoundType(blockState, (LevelReader)level, blockPos, (Entity)player);
            level.playSound(player, blockPos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockPos);
        }
        if (player == null || !player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

