/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import com.mojang.serialization.MapCodec;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentValue;
import dev.latvian.mods.kubejs.recipe.component.RecipeValidationContext;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessor;
import dev.latvian.mods.kubejs.recipe.schema.postprocessing.RecipePostProcessorType;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.integration.kubejs.AbstractRecipeJSBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class RecipeIdPostProcessor
implements RecipePostProcessor {
    public static final RecipePostProcessorType<RecipeIdPostProcessor> TYPE = new RecipePostProcessorType(CustomMachinery.rl("recipe_id"), context -> MapCodec.unit((Object)new RecipeIdPostProcessor()));
    public static final Map<ResourceLocation, Map<ResourceLocation, Integer>> IDS = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();

    public RecipePostProcessorType<RecipeIdPostProcessor> type() {
        return TYPE;
    }

    public void process(RecipeValidationContext ctx, KubeRecipe recipe) {
        if (!recipe.newRecipe || !(recipe instanceof AbstractRecipeJSBuilder)) {
            return;
        }
        AbstractRecipeJSBuilder builder = (AbstractRecipeJSBuilder)recipe;
        for (RecipeComponentValue value : recipe.getRecipeComponentValues()) {
            Object object;
            if (!value.key.name.equals("machine") || !((object = value.value) instanceof ResourceLocation)) continue;
            ResourceLocation machine = (ResourceLocation)object;
            int uniqueID = IDS.computeIfAbsent(builder.typeID, id -> new HashMap()).computeIfAbsent(machine, m -> 0);
            IDS.get(builder.typeID).put(machine, uniqueID + 1);
            recipe.id = ResourceLocation.fromNamespaceAndPath((String)"kubejs", (String)(builder.typeID.getPath() + "/" + machine.getNamespace() + "/" + machine.getPath() + "/" + uniqueID));
        }
    }
}

