/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.requirement.DropRequirement;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public interface DropRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder checkDrop(ItemStack item, int amount, int radius) {
        return this.checkDrops(new SizedIngredient(Ingredient.of((ItemStack[])new ItemStack[]{item}), amount), radius, true);
    }

    default public RecipeJSBuilder checkAnyDrop(int amount, int radius) {
        return this.checkDrops(SizedIngredient.of((ItemLike)Items.AIR, (int)amount), radius, false);
    }

    default public RecipeJSBuilder checkDrops(SizedIngredient ingredient, int radius) {
        return this.checkDrops(ingredient, radius, true);
    }

    default public RecipeJSBuilder checkDrops(SizedIngredient ingredient, int radius, boolean whitelist) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.CHECK, ingredient.ingredient(), whitelist, Items.AIR, ingredient.count(), radius));
    }

    default public RecipeJSBuilder consumeDropOnStart(ItemStack item, int amount, int radius) {
        return this.consumeDropsOnStart(new SizedIngredient(Ingredient.of((ItemStack[])new ItemStack[]{item}), amount), radius, true);
    }

    default public RecipeJSBuilder consumeAnyDropOnStart(int amount, int radius) {
        return this.consumeDropsOnStart(SizedIngredient.of((ItemLike)Items.AIR, (int)amount), radius, false);
    }

    default public RecipeJSBuilder consumeDropsOnStart(SizedIngredient ingredient, int radius) {
        return this.consumeDropsOnStart(ingredient, radius, true);
    }

    default public RecipeJSBuilder consumeDropsOnStart(SizedIngredient ingredient, int radius, boolean whitelist) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.CONSUME, ingredient.ingredient(), whitelist, Items.AIR, ingredient.count(), radius));
    }

    default public RecipeJSBuilder consumeDropOnEnd(ItemStack item, int amount, int radius) {
        return this.consumeDropsOnEnd(new SizedIngredient(Ingredient.of((ItemStack[])new ItemStack[]{item}), amount), radius, true);
    }

    default public RecipeJSBuilder consumeAnyDropOnEnd(int amount, int radius) {
        return this.consumeDropsOnEnd(SizedIngredient.of((ItemLike)Items.AIR, (int)amount), radius, false);
    }

    default public RecipeJSBuilder consumeDropsOnEnd(SizedIngredient ingredient, int radius) {
        return this.consumeDropsOnEnd(ingredient, radius, true);
    }

    default public RecipeJSBuilder consumeDropsOnEnd(SizedIngredient ingredient, int radius, boolean whitelist) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.OUTPUT, DropRequirement.Action.CONSUME, ingredient.ingredient(), whitelist, Items.AIR, ingredient.count(), radius));
    }

    default public RecipeJSBuilder dropItemOnStart(ItemStack stack) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.PRODUCE, Ingredient.EMPTY, true, stack.getItem(), stack.getCount(), 1));
    }

    default public RecipeJSBuilder dropItemOnEnd(ItemStack stack) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.OUTPUT, DropRequirement.Action.PRODUCE, Ingredient.EMPTY, true, stack.getItem(), stack.getCount(), 1));
    }
}

