/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CAddMachinePacket(String id, Component name, boolean kubejs, ResourceLocation template) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CAddMachinePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("add_machine"));
    public static final ResourceLocation EMPTY_TEMPLATE = CustomMachinery.rl("template/empty");
    public static final StreamCodec<ByteBuf, CAddMachinePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CAddMachinePacket::id, (StreamCodec)ByteBufCodecs.fromCodec(TextComponentUtils.CODEC.codec()), CAddMachinePacket::name, (StreamCodec)ByteBufCodecs.BOOL, CAddMachinePacket::kubejs, (StreamCodec)ResourceLocation.STREAM_CODEC, CAddMachinePacket::template, CAddMachinePacket::new);

    public CustomPacketPayload.Type<CAddMachinePacket> type() {
        return TYPE;
    }

    public static void handle(CAddMachinePacket packet, IPayloadContext context) {
        ServerPlayer player;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).getServer() != null && Utils.canPlayerManageMachines((Player)player)) {
            context.enqueueWork(() -> {
                CustomMachine newMachine;
                ResourceLocation loc;
                ResourceLocation resourceLocation = loc = packet.id.contains(":") ? ResourceLocation.parse((String)packet.id) : CustomMachinery.rl(packet.id);
                if (packet.template == EMPTY_TEMPLATE || !CustomMachinery.TEMPLATES.containsKey(packet.template)) {
                    CustomMachinery.LOGGER.info("Player: {} added new Machine: {}", (Object)player.getName().getString(), (Object)loc);
                    newMachine = new CustomMachineBuilder().setLocation(MachineLocation.fromLoader(packet.kubejs ? MachineLocation.Loader.KUBEJS : MachineLocation.Loader.DEFAULT, loc, "")).setName(packet.name).build();
                } else {
                    CustomMachinery.LOGGER.info("Player: {} added new Machine: {} from template: {}", (Object)player.getName().getString(), (Object)loc, (Object)packet.template.toString());
                    newMachine = new CustomMachineBuilder((CustomMachine)CustomMachinery.TEMPLATES.get(packet.template).getFirst()).setLocation(MachineLocation.fromLoader(packet.kubejs ? MachineLocation.Loader.KUBEJS : MachineLocation.Loader.DEFAULT, loc, "")).setName(packet.name).build();
                }
                FileUtils.writeNewMachineJson(player.getServer(), newMachine, packet.kubejs);
            });
        }
    }
}

