/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.network.SUpdateMachinesPacket;
import fr.frinn.custommachinery.common.util.FileUtils;
import fr.frinn.custommachinery.common.util.MachineList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CEditMachinePacket(CustomMachine machine) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CEditMachinePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("edit_machine"));
    public static final StreamCodec<FriendlyByteBuf, CEditMachinePacket> CODEC = new StreamCodec<FriendlyByteBuf, CEditMachinePacket>(){

        public CEditMachinePacket decode(FriendlyByteBuf buf) {
            MachineLocation location = MachineLocation.CODEC.fromNetwork(buf);
            CustomMachine machine = CustomMachine.CODEC.fromNetwork(buf);
            machine.setLocation(location);
            return new CEditMachinePacket(machine);
        }

        public void encode(FriendlyByteBuf buf, CEditMachinePacket packet) {
            MachineLocation.CODEC.toNetwork(packet.machine.getLocation(), buf);
            CustomMachine.CODEC.toNetwork(packet.machine, buf);
        }
    };

    public CustomPacketPayload.Type<CEditMachinePacket> type() {
        return TYPE;
    }

    public static void handle(CEditMachinePacket packet, IPayloadContext context) {
        ServerPlayer player;
        Player player2 = context.player();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).hasPermissions(2)) {
            context.enqueueWork(() -> {
                FileUtils.writeMachineJson(player.server, packet.machine);
                CustomMachinery.MACHINES.replace(packet.machine.getId(), packet.machine);
                MachineList.refreshAllMachines();
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SUpdateMachinesPacket(CustomMachinery.MACHINES), (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
        }
    }
}

