/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CGuiElementClickPacket(int element, byte click) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CGuiElementClickPacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("element_clicked"));
    public static final StreamCodec<ByteBuf, CGuiElementClickPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, CGuiElementClickPacket::element, (StreamCodec)ByteBufCodecs.BYTE, CGuiElementClickPacket::click, CGuiElementClickPacket::new);

    public CustomPacketPayload.Type<CGuiElementClickPacket> type() {
        return TYPE;
    }

    public static void handle(CGuiElementClickPacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.enqueueWork(() -> {
                if (player.containerMenu instanceof CustomMachineContainer) {
                    ((CustomMachineContainer)player.containerMenu).elementClicked(packet.element, packet.click);
                }
            });
        }
    }
}

