/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.crafting;

import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequirementList<C extends IMachineComponent>
implements IRequirementList<C> {
    private final Map<Double, List<RequirementWithFunction>> processRequirements = new HashMap<Double, List<RequirementWithFunction>>();
    private final List<RequirementWithFunction> tickableRequirements = new ArrayList<RequirementWithFunction>();
    private final List<RequirementWithFunction> worldConditions = new ArrayList<RequirementWithFunction>();
    private final List<RequirementWithFunction> inventoryConditions = new ArrayList<RequirementWithFunction>();
    private RecipeRequirement<? extends IMachineComponent, ?> currentRequirement;

    public void setCurrentRequirement(RecipeRequirement<?, ?> requirement) {
        this.currentRequirement = requirement;
    }

    @Override
    public void processOnStart(IRequirementList.RequirementFunction<C> function) {
        this.addProcessRequirement(0.0, function);
    }

    @Override
    public void processOnEnd(IRequirementList.RequirementFunction<C> function) {
        this.addProcessRequirement(1.0, function);
    }

    @Override
    public void processEachTick(IRequirementList.RequirementFunction<C> function) {
        this.tickableRequirements.add(new RequirementWithFunction(this.currentRequirement, function));
    }

    @Override
    public void worldCondition(IRequirementList.RequirementFunction<C> function) {
        this.worldConditions.add(new RequirementWithFunction(this.currentRequirement, function));
    }

    @Override
    public void inventoryCondition(IRequirementList.RequirementFunction<C> function) {
        this.inventoryConditions.add(new RequirementWithFunction(this.currentRequirement, function));
    }

    @Override
    public void processDelayed(double baseDelay, IRequirementList.RequirementFunction<C> function) {
        this.addProcessRequirement(baseDelay, function);
    }

    @Override
    public void process(RequirementIOMode mode, IRequirementList.RequirementFunction<C> function) {
        this.addProcessRequirement(mode == RequirementIOMode.INPUT ? 0.0 : 1.0, function);
    }

    private void addProcessRequirement(double baseDelay, IRequirementList.RequirementFunction<C> function) {
        double delay = this.currentRequirement.delay();
        delay = delay == -1.0 ? baseDelay : Math.clamp(delay, 0.0, 1.0);
        this.processRequirements.computeIfAbsent(delay, d -> new ArrayList()).add(new RequirementWithFunction(this.currentRequirement, function));
    }

    public List<RequirementWithFunction> getWorldConditions() {
        return this.worldConditions;
    }

    public List<RequirementWithFunction> getInventoryConditions() {
        return this.inventoryConditions;
    }

    public Map<Double, List<RequirementWithFunction>> getProcessRequirements() {
        return this.processRequirements;
    }

    public List<RequirementWithFunction> getTickableRequirements() {
        return this.tickableRequirements;
    }

    public record RequirementWithFunction(RecipeRequirement<?, ?> requirement, IRequirementList.RequirementFunction<?> function) {
        public CraftingResult process(IMachineComponentManager manager, ICraftingContext context) {
            return this.function.process(this.requirement.findComponent(manager, context), context);
        }
    }
}

