/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.util;

import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.util.Range;
import fr.frinn.custommachinery.impl.util.Restriction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class DoubleRange
extends Range<Double> {
    public static final NamedCodec<DoubleRange> CODEC = NamedCodec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)DoubleRange.createFromString(s));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(e::getMessage);
        }
    }, Range::toString, "Double range");
    private static final Map<String, DoubleRange> CACHE_SPEC = Collections.synchronizedMap(new WeakHashMap());
    private static final Restriction<Double> EVERYTHING = new Restriction<Object>(null, false, null, false);
    public static final DoubleRange ALL = new DoubleRange(Collections.singletonList(EVERYTHING));

    private DoubleRange(List<Restriction<Double>> restrictions) {
        super(restrictions);
    }

    public static DoubleRange createFromString(String spec) throws IllegalArgumentException {
        if (spec == null) {
            throw new IllegalArgumentException("Can't parse a double range fromm a null String");
        }
        if (spec.isEmpty() || spec.equals("*")) {
            return ALL;
        }
        DoubleRange cached = CACHE_SPEC.get(spec);
        if (cached != null) {
            return cached;
        }
        ArrayList<Restriction<Double>> restrictions = new ArrayList<Restriction<Double>>();
        String process = spec;
        Double upperBound = null;
        Double lowerBound = null;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if ((index2 < 0 || index1 < index2) && index1 >= 0) {
                index = index1;
            }
            if (index < 0) {
                throw new IllegalArgumentException("Unbounded range: \"" + spec + "\"");
            }
            Restriction<Double> restriction = DoubleRange.parseRestriction(process.substring(0, index + 1));
            if (lowerBound == null) {
                lowerBound = restriction.lowerBound();
            }
            if (upperBound != null && (restriction.lowerBound() == null || restriction.lowerBound().compareTo(upperBound) < 0)) {
                throw new IllegalArgumentException("Ranges overlap: \"" + spec + "\"");
            }
            restrictions.add(restriction);
            upperBound = restriction.upperBound();
            if (!(process = process.substring(index + 1).trim()).startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0) {
            if (restrictions.size() > 0) {
                throw new IllegalArgumentException("Only fully-qualified sets allowed in multiple set scenario: \"" + spec + "\"");
            }
            try {
                double bound = Double.parseDouble(process);
                restrictions.add(new Restriction<Double>(bound, true, bound, true));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid integer range, \"" + process + "\" is not a number");
            }
        }
        cached = new DoubleRange((List<Restriction<Double>>)restrictions);
        CACHE_SPEC.put(spec, cached);
        return cached;
    }

    public static DoubleRange of(Object o) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException("Cannot build IntRange from null");
        }
        if (o instanceof CharSequence) {
            CharSequence string = (CharSequence)o;
            return DoubleRange.createFromString(string.toString());
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return new DoubleRange(Collections.singletonList(new Restriction<Double>(number.doubleValue(), true, number.doubleValue(), true)));
        }
        throw new IllegalArgumentException("Cannot build IntRange from " + String.valueOf(o));
    }

    private static Restriction<Double> parseRestriction(String spec) throws IllegalArgumentException {
        Restriction<Double> restriction;
        boolean lowerBoundInclusive = spec.startsWith("[");
        boolean upperBoundInclusive = spec.endsWith("]");
        String process = spec.substring(1, spec.length() - 1).trim();
        int index = process.indexOf(44);
        if (index < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new IllegalArgumentException("Single version must be surrounded by []: " + spec);
            }
            Double version = Double.parseDouble(process);
            restriction = new Restriction<Double>(version, lowerBoundInclusive, version, upperBoundInclusive);
        } else {
            String upperBound;
            String lowerBound = process.substring(0, index).trim();
            if (lowerBound.equals(upperBound = process.substring(index + 1).trim())) {
                throw new IllegalArgumentException("Range cannot have identical boundaries: " + spec);
            }
            Double lowerVersion = null;
            if (lowerBound.length() > 0) {
                lowerVersion = Double.parseDouble(lowerBound);
            }
            Double upperVersion = null;
            if (upperBound.length() > 0) {
                upperVersion = Double.parseDouble(upperBound);
            }
            if (upperVersion != null && lowerVersion != null && upperVersion.compareTo(lowerVersion) < 0) {
                throw new IllegalArgumentException("Range defies version ordering: " + spec);
            }
            restriction = new Restriction<Double>(lowerVersion, lowerBoundInclusive, upperVersion, upperBoundInclusive);
        }
        return restriction;
    }
}

