/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.dungeons;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_2561;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.skyblockapi.api.data.Perk;
import tech.thatgravyboat.skyblockapi.utils.text.TextProperties;
import xyz.meowing.knit.api.KnitClient;
import xyz.meowing.knit.api.KnitPlayer;
import xyz.meowing.knit.api.events.Event;
import xyz.meowing.knit.api.events.EventCall;
import xyz.meowing.krypt.annotations.Module;
import xyz.meowing.krypt.api.dungeons.enums.DungeonClass;
import xyz.meowing.krypt.api.dungeons.enums.DungeonFloor;
import xyz.meowing.krypt.api.dungeons.enums.DungeonKey;
import xyz.meowing.krypt.api.dungeons.enums.DungeonPhase;
import xyz.meowing.krypt.api.dungeons.enums.DungeonPlayer;
import xyz.meowing.krypt.api.dungeons.enums.map.Door;
import xyz.meowing.krypt.api.dungeons.enums.map.Room;
import xyz.meowing.krypt.api.dungeons.handlers.DungeonPlayerManager;
import xyz.meowing.krypt.api.dungeons.handlers.MapUtils;
import xyz.meowing.krypt.api.dungeons.handlers.ScoreCalculator;
import xyz.meowing.krypt.api.dungeons.handlers.WorldScanner;
import xyz.meowing.krypt.api.dungeons.utils.WorldScanUtils;
import xyz.meowing.krypt.api.location.SkyBlockIsland;
import xyz.meowing.krypt.events.EventBus;
import xyz.meowing.krypt.events.core.ChatEvent;
import xyz.meowing.krypt.events.core.DungeonEvent;
import xyz.meowing.krypt.events.core.EntityEvent;
import xyz.meowing.krypt.events.core.LocationEvent;
import xyz.meowing.krypt.events.core.PacketEvent;
import xyz.meowing.krypt.events.core.ScoreboardEvent;
import xyz.meowing.krypt.events.core.TablistEvent;
import xyz.meowing.krypt.events.core.TickEvent;
import xyz.meowing.krypt.managers.events.EventBusManager;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u00a5\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J!\u0010\u000f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001b\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u001b\u0010\u0010J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0004\b\u001d\u0010\u001eJ#\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u001c\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010(\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00100\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b0\u0010/R\u0014\u00101\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b1\u0010/R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020\u0006028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00106\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0014\u00108\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00107R\u0014\u00109\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u00107R\u0014\u0010:\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00107R\u0014\u0010;\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00107R\u0014\u0010<\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u00107R\u0014\u0010=\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u00107R\u0014\u0010>\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u00107R\u0014\u0010?\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u00107R\u0014\u0010@\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u00107R\u0014\u0010A\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u00107R\u0014\u0010B\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u00107R\u0014\u0010C\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u00107R\u001a\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0006028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u00104R\u0014\u0010E\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u00107R\u0014\u0010F\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u00107R\u001f\u0010H\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120G8\u0006\u00a2\u0006\f\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010KR\u001f\u0010L\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0G8\u0006\u00a2\u0006\f\n\u0004\bL\u0010M\u001a\u0004\bN\u0010OR\u001d\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00120P8\u0006\u00a2\u0006\f\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010TR\u001d\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001c0P8\u0006\u00a2\u0006\f\n\u0004\bU\u0010R\u001a\u0004\bV\u0010TR#\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020X0W8\u0006\u00a2\u0006\f\n\u0004\bY\u0010Z\u001a\u0004\b[\u0010\\R$\u0010_\u001a\u00020]2\u0006\u0010^\u001a\u00020]8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b_\u0010`\u001a\u0004\ba\u0010bR$\u0010c\u001a\u00020]2\u0006\u0010^\u001a\u00020]8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bc\u0010`\u001a\u0004\bd\u0010bR$\u0010e\u001a\u00020]2\u0006\u0010^\u001a\u00020]8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\be\u0010`\u001a\u0004\bf\u0010bR$\u0010g\u001a\u00020]2\u0006\u0010^\u001a\u00020]8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bg\u0010`\u001a\u0004\bh\u0010bR$\u0010i\u001a\u00020]2\u0006\u0010^\u001a\u00020]8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bi\u0010`\u001a\u0004\bj\u0010bR$\u0010k\u001a\u0004\u0018\u00010\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bk\u0010l\u001a\u0004\bm\u0010n\"\u0004\bo\u0010pR$\u0010q\u001a\u00020]2\u0006\u0010^\u001a\u00020]8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bq\u0010`\u001a\u0004\br\u0010bR$\u0010s\u001a\u00020\r2\u0006\u0010^\u001a\u00020\r8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bs\u0010t\u001a\u0004\bu\u0010vR$\u0010w\u001a\u00020\r2\u0006\u0010^\u001a\u00020\r8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bw\u0010t\u001a\u0004\bx\u0010vR(\u0010z\u001a\u0004\u0018\u00010y2\b\u0010^\u001a\u0004\u0018\u00010y8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bz\u0010{\u001a\u0004\b|\u0010}R+\u0010\u007f\u001a\u0004\u0018\u00010~2\b\u0010^\u001a\u0004\u0018\u00010~8\u0006@BX\u0086\u000e\u00a2\u0006\u000f\n\u0005\b\u007f\u0010\u0080\u0001\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001R7\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0083\u00012\t\u0010^\u001a\u0005\u0018\u00010\u0083\u00018\u0006@BX\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0084\u0001\u0010\u0085\u0001\u001a\u0006\b\u0086\u0001\u0010\u0087\u0001\"\u0006\b\u0088\u0001\u0010\u0089\u0001R'\u0010\u008a\u0001\u001a\u00020]2\u0006\u0010^\u001a\u00020]8\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0005\b\u008a\u0001\u0010`\u001a\u0005\b\u008b\u0001\u0010bR(\u0010\u008c\u0001\u001a\u00020\u00062\u0006\u0010^\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\u000f\n\u0005\b\u008c\u0001\u0010/\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001R(\u0010\u008f\u0001\u001a\u00020\u00062\u0006\u0010^\u001a\u00020\u00068\u0006@BX\u0086\u000e\u00a2\u0006\u000f\n\u0005\b\u008f\u0001\u0010/\u001a\u0006\b\u0090\u0001\u0010\u008e\u0001R'\u0010\u0091\u0001\u001a\u00020]2\u0006\u0010^\u001a\u00020]8\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0005\b\u0091\u0001\u0010`\u001a\u0005\b\u0092\u0001\u0010bR\u0013\u0010\u0094\u0001\u001a\u00020\r8F\u00a2\u0006\u0007\u001a\u0005\b\u0093\u0001\u0010vR\u001d\u0010\u0098\u0001\u001a\u000b\u0012\u0007\u0012\u0005\u0018\u00010\u0095\u00010G8F\u00a2\u0006\b\u001a\u0006\b\u0096\u0001\u0010\u0097\u0001R\u0017\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u0095\u00018F\u00a2\u0006\b\u001a\u0006\b\u0099\u0001\u0010\u009a\u0001R\u0017\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u009c\u00018F\u00a2\u0006\b\u001a\u0006\b\u009d\u0001\u0010\u009e\u0001R\u0013\u0010\u00a1\u0001\u001a\u00020\r8F\u00a2\u0006\u0007\u001a\u0005\b\u00a0\u0001\u0010vR\u0013\u0010\u00a3\u0001\u001a\u00020\r8F\u00a2\u0006\u0007\u001a\u0005\b\u00a2\u0001\u0010vR\u0013\u0010\u00a4\u0001\u001a\u00020]8F\u00a2\u0006\u0007\u001a\u0005\b\u00a4\u0001\u0010b\u00a8\u0006\u00a6\u0001"}, d2={"Lxyz/meowing/krypt/api/dungeons/DungeonAPI;", "", "<init>", "()V", "", "reset", "", "type", "handleGetKey", "(Ljava/lang/String;)V", "updateHudLines", "updateHeldItem", "Lkotlin/Pair;", "", "comp", "getRoomIdx", "(Lkotlin/Pair;)I", "idx", "Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "getRoomAtIdx", "(I)Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "getRoomAtComp", "(Lkotlin/Pair;)Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "x", "z", "getRoomAt", "(II)Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "getDoorIdx", "Lxyz/meowing/krypt/api/dungeons/enums/map/Door;", "getDoorAtIdx", "(I)Lxyz/meowing/krypt/api/dungeons/enums/map/Door;", "getDoorAtComp", "(Lkotlin/Pair;)Lxyz/meowing/krypt/api/dungeons/enums/map/Door;", "getDoorAt", "(II)Lxyz/meowing/krypt/api/dungeons/enums/map/Door;", "door", "addDoor", "(Lxyz/meowing/krypt/api/dungeons/enums/map/Door;)V", "room1", "room2", "mergeRooms", "(Lxyz/meowing/krypt/api/dungeons/enums/map/Room;Lxyz/meowing/krypt/api/dungeons/enums/map/Room;)V", "", "cooldown", "getMageReduction", "(D)D", "MIMIC_TEXTURE", "Ljava/lang/String;", "RED_SKULL_TEXTURE", "WITHER_ESSENCE_TEXTURE", "", "secretTypes", "Ljava/util/List;", "Lkotlin/text/Regex;", "watcherSpawnedAllRegex", "Lkotlin/text/Regex;", "watcherKilledAllRegex", "roomSecretsRegex", "dungeonFloorRegex", "keyObtainedRegex", "keyPickedUpRegex", "witherDoorOpenRegex", "bloodDoorOpenRegex", "startRegex", "endRegex", "uniqueClassRegex", "mimicRegex", "sectionCompleteRegex", "mimicMessages", "cataRegex", "locationRegex", "", "rooms", "[Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "getRooms", "()[Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "doors", "[Lxyz/meowing/krypt/api/dungeons/enums/map/Door;", "getDoors", "()[Lxyz/meowing/krypt/api/dungeons/enums/map/Door;", "", "uniqueRooms", "Ljava/util/Set;", "getUniqueRooms", "()Ljava/util/Set;", "uniqueDoors", "getUniqueDoors", "", "Lxyz/meowing/krypt/api/dungeons/DungeonAPI$DiscoveredRoom;", "discoveredRooms", "Ljava/util/Map;", "getDiscoveredRooms", "()Ljava/util/Map;", "", "value", "bloodOpened", "Z", "getBloodOpened", "()Z", "bloodKilledAll", "getBloodKilledAll", "bloodSpawnedAll", "getBloodSpawnedAll", "floorStarted", "getFloorStarted", "floorCompleted", "getFloorCompleted", "currentRoom", "Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "getCurrentRoom", "()Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "setCurrentRoom", "(Lxyz/meowing/krypt/api/dungeons/enums/map/Room;)V", "holdingLeaps", "getHoldingLeaps", "witherKeys", "I", "getWitherKeys", "()I", "bloodKeys", "getBloodKeys", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonPhase$F7;", "F7Phase", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonPhase$F7;", "getF7Phase", "()Lxyz/meowing/krypt/api/dungeons/enums/DungeonPhase$F7;", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonPhase$P3;", "P3Phase", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonPhase$P3;", "getP3Phase", "()Lxyz/meowing/krypt/api/dungeons/enums/DungeonPhase$P3;", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonFloor;", "floor", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonFloor;", "getFloor", "()Lxyz/meowing/krypt/api/dungeons/enums/DungeonFloor;", "setFloor", "(Lxyz/meowing/krypt/api/dungeons/enums/DungeonFloor;)V", "inBoss", "getInBoss", "mapLine1", "getMapLine1", "()Ljava/lang/String;", "mapLine2", "getMapLine2", "uniqueClass", "getUniqueClass", "getCryptCount", "cryptCount", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonPlayer;", "getPlayers", "()[Lxyz/meowing/krypt/api/dungeons/enums/DungeonPlayer;", "players", "getOwnPlayer", "()Lxyz/meowing/krypt/api/dungeons/enums/DungeonPlayer;", "ownPlayer", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonClass;", "getDungeonClass", "()Lxyz/meowing/krypt/api/dungeons/enums/DungeonClass;", "dungeonClass", "getClassLevel", "classLevel", "getCataLevel", "cataLevel", "isPaul", "DiscoveredRoom", "Krypt"})
@SourceDebugExtension(value={"SMAP\nDungeonAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonAPI.kt\nxyz/meowing/krypt/api/dungeons/DungeonAPI\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 EventBus.kt\nxyz/meowing/krypt/events/EventBus\n+ 4 EventBus.kt\nxyz/meowing/knit/api/events/EventBus\n*L\n1#1,541:1\n1#2:542\n106#3,6:543\n112#3,3:555\n106#3,6:558\n112#3,3:570\n106#3,6:579\n112#3,3:591\n106#3,6:594\n112#3,3:606\n106#3,6:609\n112#3,3:621\n106#3,6:624\n112#3,3:636\n106#3,6:639\n112#3,3:651\n106#3,6:654\n112#3,3:666\n106#3,6:669\n112#3,3:681\n14#4,6:549\n14#4,6:564\n14#4,6:573\n14#4,6:585\n14#4,6:600\n14#4,6:615\n14#4,6:630\n14#4,6:645\n14#4,6:660\n14#4,6:675\n*S KotlinDebug\n*F\n+ 1 DungeonAPI.kt\nxyz/meowing/krypt/api/dungeons/DungeonAPI\n*L\n185#1:543,6\n185#1:555,3\n197#1:558,6\n197#1:570,3\n213#1:579,6\n213#1:591,3\n304#1:594,6\n304#1:606,3\n328#1:609,6\n328#1:621,3\n340#1:624,6\n340#1:636,3\n353#1:639,6\n353#1:651,3\n368#1:654,6\n368#1:666,3\n408#1:669,6\n408#1:681,3\n185#1:549,6\n197#1:564,6\n211#1:573,6\n213#1:585,6\n304#1:600,6\n328#1:615,6\n340#1:630,6\n353#1:645,6\n368#1:660,6\n408#1:675,6\n*E\n"})
public final class DungeonAPI {
    @NotNull
    public static final DungeonAPI INSTANCE;
    @NotNull
    private static final String MIMIC_TEXTURE = "ewogICJ0aW1lc3RhbXAiIDogMTY3Mjc2NTM1NTU0MCwKICAicHJvZmlsZUlkIiA6ICJhNWVmNzE3YWI0MjA0MTQ4ODlhOTI5ZDA5OTA0MzcwMyIsCiAgInByb2ZpbGVOYW1lIiA6ICJXaW5zdHJlYWtlcnoiLAogICJzaWduYXR1cmVSZXF1aWJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTE5YzEyNTQzYmM3NzkyNjA1ZWY2OGUxZjg3NDlhZThmMmEzODFkOTA4NWQ0ZDRiNzgwYmExMjgyZDM1OTdhMCIsCiAgICAgICJtZXRhZGF0YSIgOiB7CiAgICAgICAgIm1vZGVsIiA6ICJzbGltIgogICAgICB9CiAgICB9CiAgfQp9";
    @NotNull
    private static final String RED_SKULL_TEXTURE = "eyJ0aW1lc3RhbXAiOjE1NzA5MTUxODU0ODUsInByb2ZpbGVJZCI6IjVkZTZlMTg0YWY4ZDQ5OGFiYmRlMDU1ZTUwNjUzMzE2IiwicHJvZmlsZU5hbWUiOiJBc3Nhc2luSmlhbmVyMjUiLCJzaWduYXR1cmVSZXF1aXJlZCI6dHJ1ZSwidGV4dHVyZXMiOnsiU0tJTiI6eyJ1cmwiOiJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2EyMjNlMzZhYzEzZjBmNzFhYmNmYmYwYzk2ZmRjMjAxMGNjM2UxMWZmMmIwZDgxMTJkMGU2M2Y0YjRhYWEwZGUifX19";
    @NotNull
    private static final String WITHER_ESSENCE_TEXTURE = "ewogICJ0aW1lc3RhbXAiIDogMTYwMzYxMDQ0MzU4MywKICAicHJvZmlsZUlkIiA6ICIzM2ViZDMyYmIzMzk0YWQ5YWM2NzBjOTZjNTQ5YmE3ZSIsCiAgInByb2ZpbGVOYW1lIiA6ICJEYW5ub0JhbmFubm9YRCIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9lNDllYzdkODJiMTQxNWFjYWUyMDU5Zjc4Y2QxZDE3NTRiOWRlOWIxOGNhNTlmNjA5MDI0YzRhZjg0M2Q0ZDI0IgogICAgfQogIH0KfQ==ewogICJ0aW1lc3RhbXAiIDogMTYwMzYxMDQ0MzU4MywKICAicHJvZmlsZUlkIiA6ICIzM2ViZDMyYmIzMzk0YWQ5YWM2NzBjOTZjNTQ5YmE3ZSIsCiAgInByb2ZpbGVOYW1lIiA6ICJEYW5ub0JhbmFubm9YRCIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS9lNDllYzdkODJiMTQxNWFjYWUyMDU5Zjc4Y2QxZDE3NTRiOWRlOWIxOGNhNTlmNjA5MDI0YzRhZjg0M2Q0ZDI0IgogICAgfQogIH0KfQ==";
    @NotNull
    private static final List<String> secretTypes;
    @NotNull
    private static final Regex watcherSpawnedAllRegex;
    @NotNull
    private static final Regex watcherKilledAllRegex;
    @NotNull
    private static final Regex roomSecretsRegex;
    @NotNull
    private static final Regex dungeonFloorRegex;
    @NotNull
    private static final Regex keyObtainedRegex;
    @NotNull
    private static final Regex keyPickedUpRegex;
    @NotNull
    private static final Regex witherDoorOpenRegex;
    @NotNull
    private static final Regex bloodDoorOpenRegex;
    @NotNull
    private static final Regex startRegex;
    @NotNull
    private static final Regex endRegex;
    @NotNull
    private static final Regex uniqueClassRegex;
    @NotNull
    private static final Regex mimicRegex;
    @NotNull
    private static final Regex sectionCompleteRegex;
    @NotNull
    private static final List<String> mimicMessages;
    @NotNull
    private static final Regex cataRegex;
    @NotNull
    private static final Regex locationRegex;
    @NotNull
    private static final Room[] rooms;
    @NotNull
    private static final Door[] doors;
    @NotNull
    private static final Set<Room> uniqueRooms;
    @NotNull
    private static final Set<Door> uniqueDoors;
    @NotNull
    private static final Map<String, DiscoveredRoom> discoveredRooms;
    private static boolean bloodOpened;
    private static boolean bloodKilledAll;
    private static boolean bloodSpawnedAll;
    private static boolean floorStarted;
    private static boolean floorCompleted;
    @Nullable
    private static Room currentRoom;
    private static boolean holdingLeaps;
    private static int witherKeys;
    private static int bloodKeys;
    @Nullable
    private static DungeonPhase.F7 F7Phase;
    @Nullable
    private static DungeonPhase.P3 P3Phase;
    @Nullable
    private static DungeonFloor floor;
    private static boolean inBoss;
    @NotNull
    private static String mapLine1;
    @NotNull
    private static String mapLine2;
    private static boolean uniqueClass;

    private DungeonAPI() {
    }

    @NotNull
    public final Room[] getRooms() {
        return rooms;
    }

    @NotNull
    public final Door[] getDoors() {
        return doors;
    }

    @NotNull
    public final Set<Room> getUniqueRooms() {
        return uniqueRooms;
    }

    @NotNull
    public final Set<Door> getUniqueDoors() {
        return uniqueDoors;
    }

    @NotNull
    public final Map<String, DiscoveredRoom> getDiscoveredRooms() {
        return discoveredRooms;
    }

    public final boolean getBloodOpened() {
        return bloodOpened;
    }

    public final boolean getBloodKilledAll() {
        return bloodKilledAll;
    }

    public final boolean getBloodSpawnedAll() {
        return bloodSpawnedAll;
    }

    public final boolean getFloorStarted() {
        return floorStarted;
    }

    public final boolean getFloorCompleted() {
        return floorCompleted;
    }

    @Nullable
    public final Room getCurrentRoom() {
        return currentRoom;
    }

    public final void setCurrentRoom(@Nullable Room room) {
        currentRoom = room;
    }

    public final boolean getHoldingLeaps() {
        return holdingLeaps;
    }

    public final int getWitherKeys() {
        return witherKeys;
    }

    public final int getBloodKeys() {
        return bloodKeys;
    }

    @Nullable
    public final DungeonPhase.F7 getF7Phase() {
        return F7Phase;
    }

    @Nullable
    public final DungeonPhase.P3 getP3Phase() {
        return P3Phase;
    }

    @Nullable
    public final DungeonFloor getFloor() {
        return floor;
    }

    private final void setFloor(DungeonFloor value) {
        if (floor != value) {
            floor = value;
            xyz.meowing.knit.api.events.EventBus.post$default((xyz.meowing.knit.api.events.EventBus)EventBus.INSTANCE, (Event)new LocationEvent.DungeonFloorChange(value), (boolean)false, (int)2, null);
        }
    }

    public final boolean getInBoss() {
        return inBoss;
    }

    @NotNull
    public final String getMapLine1() {
        return mapLine1;
    }

    @NotNull
    public final String getMapLine2() {
        return mapLine2;
    }

    public final boolean getUniqueClass() {
        return uniqueClass;
    }

    public final int getCryptCount() {
        return ScoreCalculator.INSTANCE.getCryptsCount();
    }

    @NotNull
    public final DungeonPlayer[] getPlayers() {
        return DungeonPlayerManager.INSTANCE.getPlayers();
    }

    @Nullable
    public final DungeonPlayer getOwnPlayer() {
        DungeonPlayer dungeonPlayer;
        block1: {
            DungeonPlayer[] dungeonPlayerArray = this.getPlayers();
            int n = dungeonPlayerArray.length;
            for (int i = 0; i < n; ++i) {
                class_746 class_7462;
                DungeonPlayer dungeonPlayer2;
                DungeonPlayer it = dungeonPlayer2 = dungeonPlayerArray[i];
                boolean bl = false;
                DungeonPlayer dungeonPlayer3 = it;
                if (!Intrinsics.areEqual((Object)(dungeonPlayer3 != null ? dungeonPlayer3.getName() : null), (class_7462 = KnitPlayer.getPlayer()) != null && (class_7462 = class_7462.method_5477()) != null ? class_7462.getString() : null)) continue;
                dungeonPlayer = dungeonPlayer2;
                break block1;
            }
            dungeonPlayer = null;
        }
        return dungeonPlayer;
    }

    @Nullable
    public final DungeonClass getDungeonClass() {
        DungeonPlayer dungeonPlayer = this.getOwnPlayer();
        return dungeonPlayer != null ? dungeonPlayer.getDungeonClass() : null;
    }

    public final int getClassLevel() {
        Object object = this.getOwnPlayer();
        return object != null && (object = ((DungeonPlayer)object).getClassLevel()) != null ? (Integer)object : 0;
    }

    public final int getCataLevel() {
        Object object = this.getOwnPlayer();
        return object != null && (object = ((DungeonPlayer)object).getCataLevel()) != null ? (Integer)object : 0;
    }

    public final boolean isPaul() {
        return Perk.EZPZ.getActive();
    }

    public final void reset() {
        ArraysKt.fill$default((Object[])rooms, null, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((Object[])doors, null, (int)0, (int)0, (int)6, null);
        uniqueRooms.clear();
        uniqueDoors.clear();
        discoveredRooms.clear();
        currentRoom = null;
        holdingLeaps = false;
        bloodKilledAll = false;
        bloodSpawnedAll = false;
        bloodOpened = false;
        floorCompleted = false;
        floorStarted = false;
        mapLine1 = "";
        mapLine2 = "";
        witherKeys = 0;
        bloodKeys = 0;
        uniqueClass = false;
        inBoss = false;
        F7Phase = null;
        P3Phase = null;
        this.setFloor(null);
        WorldScanner.INSTANCE.reset();
        DungeonPlayerManager.INSTANCE.reset();
        ScoreCalculator.INSTANCE.reset();
        MapUtils.INSTANCE.reset();
    }

    private final void handleGetKey(String type2) {
        DungeonKey dungeonKey = DungeonKey.Companion.getById(type2);
        if (dungeonKey == null) {
            return;
        }
        DungeonKey key = dungeonKey;
        switch (WhenMappings.$EnumSwitchMapping$0[key.ordinal()]) {
            case 1: {
                int n = ++witherKeys;
                break;
            }
            case 2: {
                int n = ++bloodKeys;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        xyz.meowing.knit.api.events.EventBus.post$default((xyz.meowing.knit.api.events.EventBus)EventBus.INSTANCE, (Event)new DungeonEvent.KeyPickUp(key), (boolean)false, (int)2, null);
    }

    private final void updateHudLines() {
        String secrets = "\u00a77Secrets: \u00a7b" + ScoreCalculator.INSTANCE.getFoundSecrets() + "\u00a77/\u00a7c" + ScoreCalculator.INSTANCE.getTotalSecrets();
        String crypts = "\u00a77Crypts: " + (String)(this.getCryptCount() >= 5 ? "\u00a7a" + this.getCryptCount() : (this.getCryptCount() > 0 ? "\u00a7e" + this.getCryptCount() : "\u00a7c0"));
        String mimicKilledText = ScoreCalculator.INSTANCE.getMimicKilled() ? "\u00a7a\u2714" : "\u00a7c\u2718";
        String princeKilledText = ScoreCalculator.INSTANCE.getPrinceKilled() ? "\u00a7a\u2714" : "\u00a7c\u2718";
        Object[] objectArray = new Integer[]{6, 7};
        DungeonFloor dungeonFloor = floor;
        String mimic = CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)(dungeonFloor != null ? Integer.valueOf(dungeonFloor.getFloorNumber()) : null)) ? "\u00a77M: " + mimicKilledText + " \u00a78| \u00a77P: " + princeKilledText : "";
        String unfoundSecrets = "\u00a77Unfound: " + (ScoreCalculator.INSTANCE.getFoundSecrets() == 0 ? "\u00a7b" + ScoreCalculator.INSTANCE.getTotalSecrets() : "\u00a7a" + (ScoreCalculator.INSTANCE.getTotalSecrets() - ScoreCalculator.INSTANCE.getFoundSecrets()));
        String deaths = "\u00a77Deaths: \u00a7c" + RangesKt.coerceAtLeast((int)ScoreCalculator.INSTANCE.getDeathCount(), (int)0);
        String formattedScore = "\u00a77Score: " + (ScoreCalculator.INSTANCE.getScore() >= 300 ? "\u00a7a" + ScoreCalculator.INSTANCE.getScore() : (ScoreCalculator.INSTANCE.getScore() >= 270 ? "\u00a7e" + ScoreCalculator.INSTANCE.getScore() : "\u00a7c" + ScoreCalculator.INSTANCE.getScore())) + (this.isPaul() ? " \u00a7b\u2605" : "");
        mapLine1 = ((Object)StringsKt.trim((CharSequence)(secrets + " " + mimic + " " + formattedScore))).toString();
        mapLine2 = ((Object)StringsKt.trim((CharSequence)(unfoundSecrets + " " + deaths + " " + crypts))).toString();
    }

    private final void updateHeldItem() {
        class_746 class_7462 = KnitPlayer.getPlayer();
        if (class_7462 == null || (class_7462 = class_7462.method_6047()) == null) {
            return;
        }
        class_746 item = class_7462;
        class_2561 class_25612 = item.method_7964();
        Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"getHoverName(...)");
        String string = TextProperties.INSTANCE.getStripped(class_25612).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        holdingLeaps = StringsKt.contains$default((CharSequence)string, (CharSequence)"leap", (boolean)false, (int)2, null);
    }

    public final int getRoomIdx(@NotNull Pair<Integer, Integer> comp) {
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        return 6 * ((Number)comp.getSecond()).intValue() + ((Number)comp.getFirst()).intValue();
    }

    @Nullable
    public final Room getRoomAtIdx(int idx) {
        return (Room)ArraysKt.getOrNull((Object[])rooms, (int)idx);
    }

    @Nullable
    public final Room getRoomAtComp(@NotNull Pair<Integer, Integer> comp) {
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        return this.getRoomAtIdx(this.getRoomIdx(comp));
    }

    @Nullable
    public final Room getRoomAt(int x, int z) {
        return this.getRoomAtComp((Pair<Integer, Integer>)WorldScanUtils.realCoordToComponent$default(WorldScanUtils.INSTANCE, x, z, false, 4, null));
    }

    public final int getDoorIdx(@NotNull Pair<Integer, Integer> comp) {
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        int base = (((Number)comp.getFirst()).intValue() - 1 >> 1) + 6 * ((Number)comp.getSecond()).intValue();
        return base - base / 12;
    }

    @Nullable
    public final Door getDoorAtIdx(int idx) {
        return (Door)ArraysKt.getOrNull((Object[])doors, (int)idx);
    }

    @Nullable
    public final Door getDoorAtComp(@NotNull Pair<Integer, Integer> comp) {
        Intrinsics.checkNotNullParameter(comp, (String)"comp");
        return this.getDoorAtIdx(this.getDoorIdx(comp));
    }

    @Nullable
    public final Door getDoorAt(int x, int z) {
        return this.getDoorAtComp((Pair<Integer, Integer>)WorldScanUtils.realCoordToComponent$default(WorldScanUtils.INSTANCE, x, z, false, 4, null));
    }

    public final void addDoor(@NotNull Door door) {
        Intrinsics.checkNotNullParameter((Object)door, (String)"door");
        int idx = this.getDoorIdx(door.getComponentPos());
        boolean bl = 0 <= idx ? idx < doors.length : false;
        if (bl) {
            DungeonAPI.doors[idx] = door;
            ((Collection)uniqueDoors).add(door);
        }
    }

    public final void mergeRooms(@NotNull Room room1, @NotNull Room room2) {
        Intrinsics.checkNotNullParameter((Object)room1, (String)"room1");
        Intrinsics.checkNotNullParameter((Object)room2, (String)"room2");
        uniqueRooms.remove(room2);
        for (Pair<Integer, Integer> comp : room2.getComponents()) {
            int idx;
            if (!room1.hasComponent(((Number)comp.getFirst()).intValue(), ((Number)comp.getSecond()).intValue())) {
                room1.addComponent(comp, false);
            }
            boolean bl = 0 <= (idx = this.getRoomIdx(comp)) ? idx < rooms.length : false;
            if (!bl) continue;
            DungeonAPI.rooms[idx] = room1;
        }
        ((Collection)uniqueRooms).add(room1);
        room1.update();
    }

    public final double getMageReduction(double cooldown) {
        int multiplier = uniqueClass ? 1 : 2;
        return cooldown * (0.75 - Math.floor((double)this.getClassLevel() / 2.0) / 100.0 * (double)multiplier);
    }

    public static final /* synthetic */ void access$updateHudLines(DungeonAPI $this) {
        $this.updateHudLines();
    }

    public static final /* synthetic */ void access$updateHeldItem(DungeonAPI $this) {
        $this.updateHeldItem();
    }

    public static final /* synthetic */ void access$setInBoss$p(boolean bl) {
        inBoss = bl;
    }

    public static final /* synthetic */ void access$setF7Phase$p(DungeonPhase.F7 f7) {
        F7Phase = f7;
    }

    /*
     * WARNING - void declaration
     */
    static {
        SkyBlockIsland[] islands$iv;
        boolean add$iv$iv;
        void $this$iv$iv;
        EventBus $this$iv;
        int n;
        INSTANCE = new DungeonAPI();
        Object[] objectArray = new String[]{"Architect's First Draft", "Candycomb", "Decoy", "Defuse Kit", "Dungeon Chest Key", "Healing VIII Splash Potion", "Inflatable Jerry", "Revive Stone", "Secret Dye", "Spirit Leap", "Training Weights", "Trap", "Treasure Talisman"};
        secretTypes = CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])objectArray));
        watcherSpawnedAllRegex = new Regex("\\[BOSS] The Watcher: That will be enough for now\\.");
        watcherKilledAllRegex = new Regex("\\[BOSS] The Watcher: You have proven yourself\\. You may pass\\.");
        roomSecretsRegex = new Regex("\\b([0-9]|10)/([0-9]|10)\\s+Secrets\\b");
        dungeonFloorRegex = new Regex("The Catacombs \\((?<floor>.+)\\)");
        keyObtainedRegex = new Regex("(?:\\[.+] ?)?\\w+ has obtained (?<type>\\w+) Key!");
        keyPickedUpRegex = new Regex("A (?<type>\\w+) Key was picked up!");
        witherDoorOpenRegex = new Regex("\\w+ opened a WITHER door!");
        bloodDoorOpenRegex = new Regex("The BLOOD DOOR has been opened!");
        startRegex = new Regex("\\[NPC] Mort: Here, I found this map when I first entered the dungeon\\.");
        endRegex = new Regex("^\\s*(Master Mode)?\\s?(?:The)? Catacombs - (Entrance|Floor .{1,3})$");
        uniqueClassRegex = new Regex("Your .+ stats are doubled because you are the only player using this class!");
        mimicRegex = new Regex("^Party > (?:\\[[\\w+]+] )?\\w{1,16}: (.*)$");
        sectionCompleteRegex = new Regex("^\\w{1,16} (?:activated|completed) a \\w+! \\((?:7/7|8/8)\\)$");
        objectArray = new String[]{"mimic dead", "mimic dead!", "mimic killed", "mimic killed!", "$skytils-dungeon-score-mimic$"};
        mimicMessages = CollectionsKt.listOf((Object[])objectArray);
        cataRegex = new Regex("^ Catacombs (?<level>\\d+):");
        locationRegex = new Regex(" *[\u23e3\u0444] *(?<location>(?:\\s?[^\u0d60\\s]+)*)(?: \u0d60 x\\d)?");
        int n2 = 0;
        Object object = new Room[36];
        while (n2 < 36) {
            n = n2++;
            object[n] = null;
        }
        rooms = object;
        n2 = 0;
        object = new Door[60];
        while (n2 < 60) {
            n = n2++;
            object[n] = null;
        }
        doors = object;
        uniqueRooms = new LinkedHashSet();
        uniqueDoors = new LinkedHashSet();
        discoveredRooms = new LinkedHashMap();
        mapLine1 = "";
        mapLine2 = "";
        final Ref.IntRef tickCount = new Ref.IntRef();
        object = EventBus.INSTANCE;
        SkyBlockIsland[] skyBlockIslandArray = new SkyBlockIsland[]{SkyBlockIsland.DUNGEON_HUB};
        Function1 callback$iv = 1.INSTANCE;
        boolean skyblockOnly$iv = false;
        boolean $i$f$registerIn = false;
        xyz.meowing.knit.api.events.EventBus eventBus = $this$iv;
        boolean bl = false;
        Function1 callback$iv$iv = callback$iv;
        int priority$iv$iv = 0;
        boolean $i$f$register = false;
        EventCall eventCall$iv = $this$iv$iv.registerInternal(TablistEvent.Change.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        Set islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = 2.INSTANCE;
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(ScoreboardEvent.Update.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = 3.INSTANCE;
        int priority$iv22 = 0;
        boolean add$iv = true;
        boolean $i$f$register2 = false;
        $this$iv.registerInternal(LocationEvent.IslandChange.class, priority$iv22, add$iv, callback$iv);
        $this$iv = EventBus.INSTANCE;
        SkyBlockIsland[] priority$iv22 = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = 4.INSTANCE;
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(ChatEvent.Receive.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = (Function1)new Function1<TickEvent.Client, Unit>(){

            /*
             * Unable to fully structure code
             */
            public final void invoke(TickEvent.Client it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DungeonAPI.access$updateHudLines(DungeonAPI.INSTANCE);
                DungeonAPI.access$updateHeldItem(DungeonAPI.INSTANCE);
                if (tickCount.element % 5 != 0) {
                    return;
                }
                if (DungeonAPI.INSTANCE.getFloor() == null) ** GOTO lbl-1000
                v0 = KnitPlayer.getPlayer();
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-DungeonAPI$5$1 = false;
                    var6_4 = WorldScanUtils.realCoordToComponent$default(WorldScanUtils.INSTANCE, (int)it.method_23317(), (int)it.method_23321(), false, 4, null);
                    x = ((Number)var6_4.component1()).intValue();
                    z = ((Number)var6_4.component2()).intValue();
                    v1 = 6 * z + x > 35;
                } else {
                    v1 = false;
                }
                if (v1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                DungeonAPI.access$setInBoss$p(v2);
                v3 = DungeonAPI.INSTANCE.getFloor();
                v4 = v3 != null ? v3.getFloorNumber() == 7 : false;
                if (v4 && DungeonAPI.INSTANCE.getInBoss()) {
                    v5 = KnitClient.getPlayer();
                    if (v5 == null) {
                        return;
                    }
                    y = v5.method_23318();
                    DungeonAPI.access$setF7Phase$p(y > 210.0 ? DungeonPhase.F7.P1 : (y > 155.0 ? DungeonPhase.F7.P2 : (y > 100.0 ? DungeonPhase.F7.P3 : (y > 45.0 ? DungeonPhase.F7.P4 : DungeonPhase.F7.P5))));
                }
            }
        };
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(TickEvent.Client.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = 6.INSTANCE;
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(EntityEvent.Death.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = 7.INSTANCE;
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(EntityEvent.Packet.Metadata.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = 8.INSTANCE;
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(PacketEvent.Received.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = 9.INSTANCE;
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(PacketEvent.Sent.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = 10.INSTANCE;
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(EntityEvent.Death.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0010\u0010\f\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\nR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u001a\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b\u001c\u0010\r\u00a8\u0006\u001d"}, d2={"Lxyz/meowing/krypt/api/dungeons/DungeonAPI$DiscoveredRoom;", "", "", "x", "z", "Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "room", "<init>", "(IILxyz/meowing/krypt/api/dungeons/enums/map/Room;)V", "component1", "()I", "component2", "component3", "()Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "copy", "(IILxyz/meowing/krypt/api/dungeons/enums/map/Room;)Lxyz/meowing/krypt/api/dungeons/DungeonAPI$DiscoveredRoom;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getX", "getZ", "Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "getRoom", "Krypt"})
    public static final class DiscoveredRoom {
        private final int x;
        private final int z;
        @NotNull
        private final Room room;

        public DiscoveredRoom(int x, int z, @NotNull Room room) {
            Intrinsics.checkNotNullParameter((Object)room, (String)"room");
            this.x = x;
            this.z = z;
            this.room = room;
        }

        public final int getX() {
            return this.x;
        }

        public final int getZ() {
            return this.z;
        }

        @NotNull
        public final Room getRoom() {
            return this.room;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.z;
        }

        @NotNull
        public final Room component3() {
            return this.room;
        }

        @NotNull
        public final DiscoveredRoom copy(int x, int z, @NotNull Room room) {
            Intrinsics.checkNotNullParameter((Object)room, (String)"room");
            return new DiscoveredRoom(x, z, room);
        }

        public static /* synthetic */ DiscoveredRoom copy$default(DiscoveredRoom discoveredRoom, int n, int n2, Room room, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = discoveredRoom.x;
            }
            if ((n3 & 2) != 0) {
                n2 = discoveredRoom.z;
            }
            if ((n3 & 4) != 0) {
                room = discoveredRoom.room;
            }
            return discoveredRoom.copy(n, n2, room);
        }

        @NotNull
        public String toString() {
            return "DiscoveredRoom(x=" + this.x + ", z=" + this.z + ", room=" + this.room + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.z);
            result = result * 31 + this.room.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DiscoveredRoom)) {
                return false;
            }
            DiscoveredRoom discoveredRoom = (DiscoveredRoom)other;
            if (this.x != discoveredRoom.x) {
                return false;
            }
            if (this.z != discoveredRoom.z) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.room, (Object)discoveredRoom.room);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DungeonKey.values().length];
            try {
                nArray[DungeonKey.WITHER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DungeonKey.BLOOD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

