/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.config.ui.elements;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.knit.api.input.KnitMouseButtons;
import xyz.meowing.krypt.ui.Theme;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Text;
import xyz.meowing.vexel.elements.Slider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0015R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0017\u0010\u001c\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lxyz/meowing/krypt/config/ui/elements/SliderElement;", "Lxyz/meowing/vexel/components/base/VexelElement;", "", "name", "", "initialValue", "min", "max", "", "showDouble", "<init>", "(Ljava/lang/String;DDDZ)V", "value", "formatValue", "(D)Ljava/lang/String;", "", "mouseX", "mouseY", "", "onRender", "(FF)V", "D", "Z", "Lxyz/meowing/vexel/components/core/Text;", "label", "Lxyz/meowing/vexel/components/core/Text;", "valueText", "Lxyz/meowing/vexel/elements/Slider;", "slider", "Lxyz/meowing/vexel/elements/Slider;", "getSlider", "()Lxyz/meowing/vexel/elements/Slider;", "Krypt"})
public final class SliderElement
extends VexelElement<SliderElement> {
    private final double min;
    private final double max;
    private final boolean showDouble;
    @NotNull
    private final Text label;
    @NotNull
    private final Text valueText;
    @NotNull
    private final Slider slider;

    public SliderElement(@NotNull String name, double initialValue, double min, double max, boolean showDouble) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(null, null, 3, null);
        this.min = min;
        this.max = max;
        this.showDouble = showDouble;
        this.label = (Text)((Text)new Text(name, Theme.Text.getColor(), 16.0f, false, null, 24, null).setPositioning(6.0f, Pos.ParentPixels, 8.0f, Pos.ParentPixels)).childOf((VexelElement)this);
        this.valueText = (Text)((Text)((Text)new Text(this.formatValue(initialValue), Theme.TextMuted.getColor(), 16.0f, false, null, 24, null).setPositioning(-6.0f, Pos.ParentPixels, 8.0f, Pos.ParentPixels)).alignRight()).childOf((VexelElement)this);
        float f = (float)((initialValue - this.min) / (this.max - this.min));
        int n = Theme.Bg.getColor();
        int n2 = Theme.Primary.getColor();
        this.slider = (Slider)((Slider)((Slider)((Slider)new Slider(f, 0.0f, 1.0f, null, -1, null, null, n, n2, null, null, 15.0f, 15.0f, 0.0f, 0.0f, 0.0f, 0, 0, 0.0f, 0.0f, null, null, null, null, null, 33547880, null).setSizing(220.0f, Size.Pixels, 24.0f, Size.Pixels)).setPositioning(10.0f, Pos.ParentPixels, 0.0f, Pos.ParentPixels)).alignBottom()).childOf((VexelElement)this);
        this.setSizing(240.0f, Size.Pixels, 48.0f, Size.Pixels);
        this.setPositioning(Pos.ParentPixels, Pos.AfterSibling);
        this.slider.onValueChange((Function1)new Function1<Object, Unit>(){

            public final void invoke(Object sliderValue) {
                Intrinsics.checkNotNullParameter((Object)sliderValue, (String)"sliderValue");
                double actualValue = min + (double)((Float)sliderValue).floatValue() * (max - min);
                valueText.setText(this.formatValue(actualValue));
            }
        });
    }

    @NotNull
    public final Slider getSlider() {
        return this.slider;
    }

    private final String formatValue(double value) {
        String string;
        if (this.showDouble) {
            String string2 = "%.1f";
            Object[] objectArray = new Object[]{value};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else {
            string = String.valueOf((int)value);
        }
        return string;
    }

    protected void onRender(float mouseX, float mouseY) {
        if (this.slider.isDragging() && !KnitMouseButtons.INSTANCE.getLEFT().isPressed()) {
            this.slider.setDragging(false);
        }
    }
}

