/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.dungeons.enums.map;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.krypt.api.dungeons.enums.map.DoorState;
import xyz.meowing.krypt.api.dungeons.enums.map.DoorType;
import xyz.meowing.krypt.api.dungeons.utils.WorldScanUtils;
import xyz.meowing.krypt.features.map.DungeonMap;
import xyz.meowing.krypt.utils.WorldUtils;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015R#\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0016\u001a\u0004\b\u0019\u0010\u0018R\"\u0010\u001b\u001a\u00020\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010'\u001a\u0004\b(\u0010)\"\u0004\b\r\u0010*R\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010+\u001a\u0004\b,\u0010-\"\u0004\b\u0011\u0010.R\u0011\u00102\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Lxyz/meowing/krypt/api/dungeons/enums/map/Door;", "", "Lkotlin/Pair;", "", "worldPos", "componentPos", "<init>", "(Lkotlin/Pair;Lkotlin/Pair;)V", "Lkotlin/Triple;", "getPos", "()Lkotlin/Triple;", "Lxyz/meowing/krypt/api/dungeons/enums/map/DoorType;", "type", "setType", "(Lxyz/meowing/krypt/api/dungeons/enums/map/DoorType;)Lxyz/meowing/krypt/api/dungeons/enums/map/Door;", "Lxyz/meowing/krypt/api/dungeons/enums/map/DoorState;", "state", "setState", "(Lxyz/meowing/krypt/api/dungeons/enums/map/DoorState;)Lxyz/meowing/krypt/api/dungeons/enums/map/Door;", "", "check", "()V", "Lkotlin/Pair;", "getWorldPos", "()Lkotlin/Pair;", "getComponentPos", "", "opened", "Z", "getOpened", "()Z", "setOpened", "(Z)V", "rotation", "Ljava/lang/Integer;", "getRotation", "()Ljava/lang/Integer;", "setRotation", "(Ljava/lang/Integer;)V", "Lxyz/meowing/krypt/api/dungeons/enums/map/DoorType;", "getType", "()Lxyz/meowing/krypt/api/dungeons/enums/map/DoorType;", "(Lxyz/meowing/krypt/api/dungeons/enums/map/DoorType;)V", "Lxyz/meowing/krypt/api/dungeons/enums/map/DoorState;", "getState", "()Lxyz/meowing/krypt/api/dungeons/enums/map/DoorState;", "(Lxyz/meowing/krypt/api/dungeons/enums/map/DoorState;)V", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "color", "Krypt"})
public final class Door {
    @NotNull
    private final Pair<Integer, Integer> worldPos;
    @NotNull
    private final Pair<Integer, Integer> componentPos;
    private boolean opened;
    @Nullable
    private Integer rotation;
    @NotNull
    private DoorType type;
    @NotNull
    private DoorState state;

    public Door(@NotNull Pair<Integer, Integer> worldPos, @NotNull Pair<Integer, Integer> componentPos) {
        Intrinsics.checkNotNullParameter(worldPos, (String)"worldPos");
        Intrinsics.checkNotNullParameter(componentPos, (String)"componentPos");
        this.worldPos = worldPos;
        this.componentPos = componentPos;
        this.type = DoorType.NORMAL;
        this.state = DoorState.UNDISCOVERED;
    }

    @NotNull
    public final Pair<Integer, Integer> getWorldPos() {
        return this.worldPos;
    }

    @NotNull
    public final Pair<Integer, Integer> getComponentPos() {
        return this.componentPos;
    }

    public final boolean getOpened() {
        return this.opened;
    }

    public final void setOpened(boolean bl) {
        this.opened = bl;
    }

    @Nullable
    public final Integer getRotation() {
        return this.rotation;
    }

    public final void setRotation(@Nullable Integer n) {
        this.rotation = n;
    }

    @NotNull
    public final DoorType getType() {
        return this.type;
    }

    public final void setType(@NotNull DoorType doorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)doorType), (String)"<set-?>");
        this.type = doorType;
    }

    @NotNull
    public final DoorState getState() {
        return this.state;
    }

    public final void setState(@NotNull DoorState doorState) {
        Intrinsics.checkNotNullParameter((Object)((Object)doorState), (String)"<set-?>");
        this.state = doorState;
    }

    @NotNull
    public final Color getColor() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> DungeonMap.INSTANCE.getBloodDoorColor();
            case 2 -> DungeonMap.INSTANCE.getEntranceDoorColor();
            case 3 -> DungeonMap.INSTANCE.getWitherDoorColor();
            case 4 -> DungeonMap.INSTANCE.getNormalDoorColor();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final Triple<Integer, Integer, Integer> getPos() {
        return new Triple(this.worldPos.getFirst(), (Object)69, this.worldPos.getSecond());
    }

    @NotNull
    public final Door setType(@NotNull DoorType type2) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.type = type2;
        return this;
    }

    @NotNull
    public final Door setState(@NotNull DoorState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.state = state;
        return this;
    }

    public final void check() {
        Triple<Integer, Integer, Integer> triple = this.getPos();
        int x = ((Number)triple.component1()).intValue();
        int y = ((Number)triple.component2()).intValue();
        int z = ((Number)triple.component3()).intValue();
        if (!WorldScanUtils.INSTANCE.isChunkLoaded(x, z)) {
            return;
        }
        int id = WorldUtils.INSTANCE.getBlockNumericId(x, y, z);
        this.opened = id == 0;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DoorType.values().length];
            try {
                nArray[DoorType.BLOOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DoorType.ENTRANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DoorType.WITHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DoorType.NORMAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

