/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.dungeons.handlers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_742;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.KnitClient;
import xyz.meowing.knit.api.events.EventCall;
import xyz.meowing.krypt.annotations.Module;
import xyz.meowing.krypt.api.dungeons.DungeonAPI;
import xyz.meowing.krypt.api.dungeons.enums.DungeonPlayer;
import xyz.meowing.krypt.api.dungeons.enums.map.Door;
import xyz.meowing.krypt.api.dungeons.enums.map.Room;
import xyz.meowing.krypt.api.dungeons.enums.map.RoomType;
import xyz.meowing.krypt.api.dungeons.utils.ScanUtils;
import xyz.meowing.krypt.api.dungeons.utils.WorldScanUtils;
import xyz.meowing.krypt.api.location.SkyBlockIsland;
import xyz.meowing.krypt.events.EventBus;
import xyz.meowing.krypt.events.core.TickEvent;
import xyz.meowing.krypt.managers.events.EventBusManager;
import xyz.meowing.krypt.utils.WorldUtils;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J7\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ7\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJO\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0003J\r\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0003J\r\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0003J/\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ7\u0010%\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0014\u0010*\u001a\u00020)8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b,\u0010(R\u0014\u0010-\u001a\u00020\u001b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u0010/\u001a\u00020\u001b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b/\u0010.R\u0014\u00100\u001a\u00020\u001b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b0\u0010.R\u0014\u00101\u001a\u00020\u001b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b1\u0010.R\u0014\u00102\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b2\u0010(R;\u00106\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070504038\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R$\u0010:\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u0016\u0010@\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010(R\u0016\u0010B\u001a\u00020A8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010D\u001a\u00020A8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010CR\u0016\u0010E\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010+R\u0011\u0010H\u001a\u00020A8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006I"}, d2={"Lxyz/meowing/krypt/api/dungeons/handlers/WorldScanner;", "", "<init>", "()V", "", "reset", "scan", "", "cx", "cz", "rx", "rz", "roofHeight", "scanDoorComponent", "(IIIII)V", "scanRoomComponent", "Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "room", "x", "z", "scanRoomNeighbors", "(Lxyz/meowing/krypt/api/dungeons/enums/map/Room;IIIIIII)V", "checkPlayerState", "checkRoomState", "checkDoorState", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonPlayer;", "player", "", "", "yaw", "onPlayerMove", "(Lxyz/meowing/krypt/api/dungeons/enums/DungeonPlayer;DDF)V", "n", "inMin", "inMax", "outMin", "outMax", "clampMap", "(DDDDD)D", "SCAN_INTERVAL", "I", "", "SCAN_COOLDOWN", "J", "DOOR_HEIGHT_THRESHOLD", "DUNGEON_MIN_X", "D", "DUNGEON_MAX_X", "DUNGEON_MIN_Z", "DUNGEON_MAX_Z", "MAX_ROOM_INDEX", "", "Lkotlin/Triple;", "Lkotlin/Pair;", "availableComponents", "Ljava/util/List;", "getAvailableComponents", "()Ljava/util/List;", "lastIdx", "Ljava/lang/Integer;", "getLastIdx", "()Ljava/lang/Integer;", "setLastIdx", "(Ljava/lang/Integer;)V", "tickCounter", "", "hasScanned", "Z", "isScanning", "lastScanTime", "getShouldScan", "()Z", "shouldScan", "Krypt"})
@SourceDebugExtension(value={"SMAP\nWorldScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldScanner.kt\nxyz/meowing/krypt/api/dungeons/handlers/WorldScanner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 EventBus.kt\nxyz/meowing/krypt/events/EventBus\n+ 4 EventBus.kt\nxyz/meowing/knit/api/events/EventBus\n*L\n1#1,255:1\n1#2:256\n84#3,6:257\n90#3,3:269\n14#4,6:263\n*S KotlinDebug\n*F\n+ 1 WorldScanner.kt\nxyz/meowing/krypt/api/dungeons/handlers/WorldScanner\n*L\n43#1:257,6\n43#1:269,3\n43#1:263,6\n*E\n"})
public final class WorldScanner {
    @NotNull
    public static final WorldScanner INSTANCE;
    private static final int SCAN_INTERVAL = 5;
    private static final long SCAN_COOLDOWN = 250L;
    private static final int DOOR_HEIGHT_THRESHOLD = 85;
    private static final double DUNGEON_MIN_X = -200.0;
    private static final double DUNGEON_MAX_X = -10.0;
    private static final double DUNGEON_MIN_Z = -200.0;
    private static final double DUNGEON_MAX_Z = -10.0;
    private static final int MAX_ROOM_INDEX = 35;
    @NotNull
    private static final List<Triple<Integer, Integer, Pair<Integer, Integer>>> availableComponents;
    @Nullable
    private static Integer lastIdx;
    private static int tickCounter;
    private static boolean hasScanned;
    private static boolean isScanning;
    private static long lastScanTime;

    private WorldScanner() {
    }

    @NotNull
    public final List<Triple<Integer, Integer, Pair<Integer, Integer>>> getAvailableComponents() {
        return availableComponents;
    }

    @Nullable
    public final Integer getLastIdx() {
        return lastIdx;
    }

    public final void setLastIdx(@Nullable Integer n) {
        lastIdx = n;
    }

    public final boolean getShouldScan() {
        return !isScanning && !hasScanned && System.currentTimeMillis() - lastScanTime >= 250L && !((Collection)availableComponents).isEmpty();
    }

    public final void reset() {
        availableComponents.clear();
        CollectionsKt.addAll((Collection)availableComponents, (Iterable)ScanUtils.INSTANCE.getScanCoord());
        lastIdx = null;
        hasScanned = false;
        isScanning = false;
        lastScanTime = 0L;
        tickCounter = 0;
    }

    public final void scan() {
        if (!this.getShouldScan()) {
            return;
        }
        isScanning = true;
        boolean allChunksLoaded = true;
        int n = ((Collection)availableComponents).size() + -1;
        if (0 <= n) {
            do {
                int rz;
                int idx = n--;
                Triple<Integer, Integer, Pair<Integer, Integer>> triple = availableComponents.get(idx);
                int cx = ((Number)triple.component1()).intValue();
                int cz = ((Number)triple.component2()).intValue();
                Pair rxz = (Pair)triple.component3();
                int rx = ((Number)rxz.component1()).intValue();
                if (!WorldScanUtils.INSTANCE.isChunkLoaded(rx, rz = ((Number)rxz.component2()).intValue())) {
                    allChunksLoaded = false;
                    continue;
                }
                Integer n2 = WorldScanUtils.INSTANCE.getHighestY(rx, rz);
                if (n2 == null) {
                    continue;
                }
                int roofHeight = n2;
                availableComponents.remove(idx);
                if (cx % 2 == 1 || cz % 2 == 1) {
                    this.scanDoorComponent(cx, cz, rx, rz, roofHeight);
                    continue;
                }
                this.scanRoomComponent(cx, cz, rx, rz, roofHeight);
            } while (0 <= n);
        }
        if (allChunksLoaded && availableComponents.isEmpty()) {
            hasScanned = true;
        }
        lastScanTime = System.currentTimeMillis();
        isScanning = false;
    }

    private final void scanDoorComponent(int cx, int cz, int rx, int rz, int roofHeight) {
        Door door;
        if (roofHeight >= 85) {
            return;
        }
        Pair comp = TuplesKt.to((Object)cx, (Object)cz);
        int doorIdx = DungeonAPI.INSTANCE.getDoorIdx((Pair<Integer, Integer>)comp);
        if (DungeonAPI.INSTANCE.getDoorAtIdx(doorIdx) != null) {
            return;
        }
        Door $this$scanDoorComponent_u24lambda_u240 = door = new Door((Pair<Integer, Integer>)TuplesKt.to((Object)rx, (Object)rz), (Pair<Integer, Integer>)comp);
        boolean bl = false;
        $this$scanDoorComponent_u24lambda_u240.setRotation(cz % 2 == 1 ? Integer.valueOf(0) : Integer.valueOf(1));
        Door door2 = door;
        DungeonAPI.INSTANCE.addDoor(door2);
    }

    private final void scanRoomComponent(int cx, int cz, int rx, int rz, int roofHeight) {
        Room room;
        int x = cx / 2;
        int z = cz / 2;
        int roomIdx = DungeonAPI.INSTANCE.getRoomIdx((Pair<Integer, Integer>)TuplesKt.to((Object)x, (Object)z));
        Room room2 = DungeonAPI.INSTANCE.getRooms()[roomIdx];
        if (room2 != null) {
            Room $this$scanRoomComponent_u24lambda_u241 = var10_9 = room2;
            boolean bl = false;
            if ($this$scanRoomComponent_u24lambda_u241.getHeight() == null) {
                $this$scanRoomComponent_u24lambda_u241.setHeight(roofHeight);
            }
            $this$scanRoomComponent_u24lambda_u241.scan();
            room = var10_9;
        } else {
            Room it = var10_9 = new Room((Pair<Integer, Integer>)TuplesKt.to((Object)x, (Object)z), roofHeight).scan();
            boolean bl = false;
            DungeonAPI.INSTANCE.getRooms()[roomIdx] = it;
            DungeonAPI.INSTANCE.getUniqueRooms().add(it);
            room = var10_9;
        }
        Room room3 = room;
        this.scanRoomNeighbors(room3, cx, cz, x, z, rx, rz, roofHeight);
    }

    private final void scanRoomNeighbors(Room room, int cx, int cz, int x, int z, int rx, int rz, int roofHeight) {
        for (List<Integer> list : ScanUtils.INSTANCE.getDirections()) {
            int dx = ((Number)list.get(0)).intValue();
            int dz = ((Number)list.get(1)).intValue();
            int cxOff = ((Number)list.get(2)).intValue();
            int zOff = ((Number)list.get(3)).intValue();
            int doorCx = cx + dx;
            int doorCz = cz + dz;
            Pair doorComp = TuplesKt.to((Object)doorCx, (Object)doorCz);
            int doorIdx = DungeonAPI.INSTANCE.getDoorIdx((Pair<Integer, Integer>)doorComp);
            if (DungeonAPI.INSTANCE.getDoorAtIdx(doorIdx) != null) continue;
            int nx = rx + dx;
            int nz = rz + dz;
            int blockBelow = WorldUtils.INSTANCE.getBlockNumericId(nx, roofHeight, nz);
            int blockAbove = WorldUtils.INSTANCE.getBlockNumericId(nx, roofHeight + 1, nz);
            if (room.getType() == RoomType.ENTRANCE && blockBelow != 0 || blockBelow == 0 || blockAbove != 0) continue;
            Pair neighborComp = TuplesKt.to((Object)(x + cxOff), (Object)(z + zOff));
            int neighborIdx = DungeonAPI.INSTANCE.getRoomIdx((Pair<Integer, Integer>)neighborComp);
            boolean bl = 0 <= neighborIdx ? neighborIdx < DungeonAPI.INSTANCE.getRooms().length : false;
            if (!bl) continue;
            Room neighborRoom = DungeonAPI.INSTANCE.getRooms()[neighborIdx];
            if (neighborRoom == null) {
                Room.addComponent$default(room, neighborComp, false, 2, null);
                DungeonAPI.INSTANCE.getRooms()[neighborIdx] = room;
                continue;
            }
            if (Intrinsics.areEqual((Object)neighborRoom, (Object)room) || neighborRoom.getType() == RoomType.ENTRANCE || room.getType() == RoomType.ENTRANCE) continue;
            DungeonAPI.INSTANCE.mergeRooms(neighborRoom, room);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void checkPlayerState() {
        v0 = KnitClient.getWorld();
        if (v0 == null) {
            return;
        }
        world = v0;
        networkHandler = KnitClient.getClient().method_1562();
        for (DungeonPlayer player : DungeonAPI.INSTANCE.getPlayers()) {
            block7: {
                if (player == null) continue;
                v1 = world.method_18456();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"players(...)");
                var9_9 = v1;
                for (T var11_11 : var9_9) {
                    it = (class_742)var11_11;
                    $i$a$-find-WorldScanner$checkPlayerState$entity$1 = false;
                    if (!Intrinsics.areEqual((Object)it.method_5477().getString(), (Object)player.getName())) continue;
                    v2 = var11_11;
                    break block7;
                }
                v2 = null;
            }
            entity = v2;
            v3 = networkHandler;
            if (v3 == null) ** GOTO lbl-1000
            v4 = entity;
            if ((v3 = v3.method_2871(v4 != null ? v4.method_5667() : null)) != null) {
                v5 = v3.method_2959();
            } else lbl-1000:
            // 2 sources

            {
                v5 = -1;
            }
            ping = v5;
            player.setInRender(ping != -1 && entity != null);
            if (player.getInRender() && entity != null) {
                this.onPlayerMove(player, entity.method_23317(), entity.method_23321(), entity.method_36454());
            }
            if (ping == -1 || player.getCurrRoom() == null || Intrinsics.areEqual((Object)currRoom, (Object)player.getLastRoom())) continue;
            v6 = player.getLastRoom();
            if (v6 != null && (v6 = v6.getPlayers()) != null) {
                v6.remove(player);
            }
            currRoom.getPlayers().add(player);
            player.setLastRoom(currRoom);
        }
    }

    public final void checkRoomState() {
        Room[] roomArray = DungeonAPI.INSTANCE.getRooms();
        int n = roomArray.length;
        for (int i = 0; i < n; ++i) {
            Room room;
            Room room2 = room = roomArray[i];
            if ((room2 != null ? room2.getRotation() : null) == null) {
                Room room3 = room;
                if (room3 != null) {
                    room3.findRotation();
                }
            }
            if (room == null || room.getComponentCenters().size() >= room.getComponents().size()) continue;
            room.findComponentCenters();
            room.findCenter();
        }
    }

    public final void checkDoorState() {
        for (Door door : DungeonAPI.INSTANCE.getUniqueDoors()) {
            if (door.getOpened()) continue;
            door.check();
        }
    }

    private final void onPlayerMove(DungeonPlayer player, double x, double z, float yaw) {
        block4: {
            block3: {
                player.setRealX(x);
                player.setRealZ(z);
                player.setYaw(Float.valueOf(yaw + 180.0f));
                boolean bl = -200.0 <= x ? x <= -10.0 : false;
                if (!bl) break block3;
                if (-200.0 <= z ? z <= -10.0 : false) break block4;
            }
            return;
        }
        Pair<Integer, Integer> mapSize = ScanUtils.INSTANCE.getDefaultMapSize();
        player.setIconX(this.clampMap(x, -200.0, -10.0, 0.0, ((Number)mapSize.getFirst()).intValue()));
        player.setIconZ(this.clampMap(z, -200.0, -10.0, 0.0, ((Number)mapSize.getSecond()).intValue()));
        player.setCurrRoom(DungeonAPI.INSTANCE.getRoomAt((int)x, (int)z));
    }

    private final double clampMap(double n, double inMin, double inMax, double outMin, double outMax) {
        return n <= inMin ? outMin : (n >= inMax ? outMax : (n - inMin) * (outMax - outMin) / (inMax - inMin) + outMin);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void islands$iv;
        void add$iv$iv;
        void $this$iv$iv;
        void $this$iv;
        INSTANCE = new WorldScanner();
        availableComponents = CollectionsKt.toMutableList((Collection)ScanUtils.INSTANCE.getScanCoord());
        EventBus eventBus = EventBus.INSTANCE;
        SkyBlockIsland[] skyBlockIslandArray = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        Function1 callback$iv = 1.INSTANCE;
        boolean skyblockOnly$iv = false;
        boolean $i$f$registerIn = false;
        xyz.meowing.knit.api.events.EventBus eventBus2 = (xyz.meowing.knit.api.events.EventBus)$this$iv;
        boolean bl = false;
        Function1 callback$iv$iv = callback$iv;
        int priority$iv$iv = 0;
        boolean $i$f$register = false;
        EventCall eventCall$iv = $this$iv$iv.registerInternal(TickEvent.Client.class, priority$iv$iv, (boolean)add$iv$iv, callback$iv$iv);
        Set islandSet$iv = !(((void)islands$iv).length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
    }
}

