/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.dungeons.utils;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.KnitClient;
import xyz.meowing.krypt.api.dungeons.utils.ScanUtils;
import xyz.meowing.krypt.utils.WorldUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ3\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J3\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0011JA\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00132\u0006\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lxyz/meowing/krypt/api/dungeons/utils/WorldScanUtils;", "", "<init>", "()V", "", "x", "z", "", "isChunkLoaded", "(II)Z", "getCore", "(II)I", "getHighestY", "(II)Ljava/lang/Integer;", "includeDoors", "Lkotlin/Pair;", "componentToRealCoord", "(IIZ)Lkotlin/Pair;", "realCoordToComponent", "Lkotlin/Triple;", "pos", "degree", "rotateCoord", "(Lkotlin/Triple;I)Lkotlin/Triple;", "ROOM_SIZE_SHIFT", "I", "DUNGEON_START", "", "blacklist", "Ljava/util/Set;", "getBlacklist", "()Ljava/util/Set;", "Krypt"})
public final class WorldScanUtils {
    @NotNull
    public static final WorldScanUtils INSTANCE = new WorldScanUtils();
    private static final int ROOM_SIZE_SHIFT = 5;
    private static final int DUNGEON_START = -185;
    @NotNull
    private static final Set<Integer> blacklist;

    private WorldScanUtils() {
    }

    @NotNull
    public final Set<Integer> getBlacklist() {
        return blacklist;
    }

    public final boolean isChunkLoaded(int x, int z) {
        class_638 class_6382 = KnitClient.getWorld();
        if (class_6382 == null) {
            return false;
        }
        class_638 world = class_6382;
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return world.method_2935().method_12123(chunkX, chunkZ);
    }

    public final int getCore(int x, int z) {
        int n;
        StringBuilder sb = new StringBuilder(150);
        Integer n2 = this.getHighestY(x, z);
        int height = n2 != null ? RangesKt.coerceIn((int)n2, (ClosedRange)((ClosedRange)new IntRange(11, 140))) : RangesKt.coerceIn((int)140, (ClosedRange)((ClosedRange)new IntRange(11, 140)));
        int n3 = 0;
        int n4 = 140 - height;
        char[] cArray = new char[n4];
        StringBuilder stringBuilder = sb;
        while (n3 < n4) {
            n = n3++;
            cArray[n] = 48;
        }
        stringBuilder.append(cArray);
        int bedrock = 0;
        for (int y = height; 11 < y; --y) {
            int id = WorldUtils.INSTANCE.checkIfAir(x, y, z);
            if (id == 0 && bedrock >= 2 && y < 69) {
                n = 0;
                int n5 = y - 11;
                char[] cArray2 = new char[n5];
                stringBuilder = sb;
                while (n < n5) {
                    int n6 = n++;
                    cArray2[n6] = 48;
                }
                stringBuilder.append(cArray2);
                break;
            }
            if (id == 7) {
                ++bedrock;
            } else {
                bedrock = 0;
                if (blacklist.contains(id)) continue;
            }
            sb.append(id);
        }
        return sb.toString().hashCode();
    }

    @Nullable
    public final Integer getHighestY(int x, int z) {
        for (int y = 255; -1 < y; --y) {
            int id = WorldUtils.INSTANCE.getBlockNumericId(x, y, z);
            if (id == 0 || id == 41) continue;
            return y;
        }
        return null;
    }

    @NotNull
    public final Pair<Integer, Integer> componentToRealCoord(int x, int z, boolean includeDoors) {
        Pair<Integer, Integer> pair = ScanUtils.INSTANCE.getCornerStart();
        int x0 = ((Number)pair.component1()).intValue();
        int z0 = ((Number)pair.component2()).intValue();
        int offset = includeDoors ? 16 : 32;
        return new Pair((Object)(x0 + 15 + offset * x), (Object)(z0 + 15 + offset * z));
    }

    public static /* synthetic */ Pair componentToRealCoord$default(WorldScanUtils worldScanUtils, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return worldScanUtils.componentToRealCoord(n, n2, bl);
    }

    @NotNull
    public final Pair<Integer, Integer> realCoordToComponent(int x, int z, boolean includeDoors) {
        Pair<Integer, Integer> pair = ScanUtils.INSTANCE.getCornerStart();
        int x0 = ((Number)pair.component1()).intValue();
        int z0 = ((Number)pair.component2()).intValue();
        int size = includeDoors ? 16 : 32;
        int shift = 4 + (size - 16 >> 4);
        return new Pair((Object)((int)((double)(x - x0) + 0.5) >> shift), (Object)((int)((double)(z - z0) + 0.5) >> shift));
    }

    public static /* synthetic */ Pair realCoordToComponent$default(WorldScanUtils worldScanUtils, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return worldScanUtils.realCoordToComponent(n, n2, bl);
    }

    @NotNull
    public final Triple<Integer, Integer, Integer> rotateCoord(@NotNull Triple<Integer, Integer, Integer> pos, int degree) {
        Intrinsics.checkNotNullParameter(pos, (String)"pos");
        int d = (degree + 360) % 360;
        return switch (d) {
            case 0 -> pos;
            case 90 -> new Triple(pos.getThird(), pos.getSecond(), (Object)(-((Number)pos.getFirst()).intValue()));
            case 180 -> new Triple((Object)(-((Number)pos.getFirst()).intValue()), pos.getSecond(), (Object)(-((Number)pos.getThird()).intValue()));
            case 270 -> new Triple((Object)(-((Number)pos.getThird()).intValue()), pos.getSecond(), pos.getFirst());
            default -> pos;
        };
    }

    static {
        Object[] objectArray = new Integer[]{5, 54, 146};
        blacklist = SetsKt.setOf((Object[])objectArray);
    }
}

