/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.config.ui.elements;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.knit.api.input.KnitInputs;
import xyz.meowing.krypt.ui.Theme;
import xyz.meowing.vexel.animations.EasingType;
import xyz.meowing.vexel.animations.PresetsKt;
import xyz.meowing.vexel.components.base.Pos;
import xyz.meowing.vexel.components.base.Size;
import xyz.meowing.vexel.components.base.VexelElement;
import xyz.meowing.vexel.components.core.Rectangle;
import xyz.meowing.vexel.components.core.Text;
import xyz.meowing.vexel.utils.render.NVGRenderer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\nJ\u0017\u0010\u0010\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010!\u00a8\u0006&"}, d2={"Lxyz/meowing/krypt/config/ui/elements/KeybindElement;", "Lxyz/meowing/vexel/components/base/VexelElement;", "", "name", "", "initialKeyCode", "<init>", "(Ljava/lang/String;I)V", "", "startListening", "()V", "stopListening", "keyCode", "setKey", "(I)V", "updateButtonSize", "getKeyName", "(I)Ljava/lang/String;", "", "mouseX", "mouseY", "onRender", "(FF)V", "value", "selectedKey", "I", "getSelectedKey", "()I", "", "listening", "Z", "Lxyz/meowing/vexel/components/core/Text;", "label", "Lxyz/meowing/vexel/components/core/Text;", "Lxyz/meowing/vexel/components/core/Rectangle;", "keybindButton", "Lxyz/meowing/vexel/components/core/Rectangle;", "keybindText", "Krypt"})
@SourceDebugExtension(value={"SMAP\nKeybindElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeybindElement.kt\nxyz/meowing/krypt/config/ui/elements/KeybindElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1869#2,2:126\n*S KotlinDebug\n*F\n+ 1 KeybindElement.kt\nxyz/meowing/krypt/config/ui/elements/KeybindElement\n*L\n109#1:126,2\n*E\n"})
public final class KeybindElement
extends VexelElement<KeybindElement> {
    private int selectedKey;
    private boolean listening;
    @NotNull
    private final Text label;
    @NotNull
    private final Rectangle keybindButton;
    @NotNull
    private final Text keybindText;

    public KeybindElement(@NotNull String name, int initialKeyCode) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(null, null, 3, null);
        this.selectedKey = initialKeyCode;
        this.label = (Text)((Text)((Text)new Text(name, Theme.Text.getColor(), 16.0f, false, null, 24, null).setPositioning(6.0f, Pos.ParentPixels, 0.0f, Pos.ParentCenter)).ignoreMouseEvents()).childOf((VexelElement)this);
        this.keybindButton = (Rectangle)((Rectangle)((Rectangle)new Rectangle(Theme.BgLight.getColor(), Theme.Border.getColor(), 5.0f, 1.5f, null, null, null, null, null, false, 1008, null).setPositioning(-6.0f, Pos.ParentPixels, 0.0f, Pos.ParentCenter)).alignRight()).childOf((VexelElement)this);
        this.keybindText = (Text)((Text)new Text(this.getKeyName(initialKeyCode), Theme.Text.getColor(), 16.0f, false, null, 24, null).setPositioning(0.0f, Pos.ParentCenter, 0.0f, Pos.ParentCenter)).childOf((VexelElement)this.keybindButton);
        this.setSizing(240.0f, Size.Pixels, 32.0f, Size.Pixels);
        this.setPositioning(Pos.ParentPixels, Pos.AfterSibling);
        this.ignoreFocus();
        this.updateButtonSize();
        this.keybindButton.onHover((Function2)new Function2<Float, Float, Unit>(){

            public final void invoke(float f, float f2) {
                if (!listening) {
                    PresetsKt.colorTo$default((VexelElement)((VexelElement)keybindButton), (int)Theme.Highlight.getColor(), (long)150L, (EasingType)EasingType.EASE_OUT, null, (int)8, null);
                }
            }
        }, (Function2)new Function2<Float, Float, Unit>(){

            public final void invoke(float f, float f2) {
                if (!listening) {
                    PresetsKt.colorTo$default((VexelElement)((VexelElement)keybindButton), (int)Theme.BgLight.getColor(), (long)150L, (EasingType)EasingType.EASE_IN, null, (int)8, null);
                }
            }
        });
        this.keybindButton.onClick((Function3)new Function3<Float, Float, Integer, Boolean>(){

            public final Boolean invoke(float f, float f2, int button) {
                boolean bl;
                if (listening) {
                    this.setKey(-100 + button);
                    bl = false;
                } else if (button == 0) {
                    this.startListening();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        });
        this.onCharType((Function3)new Function3<Integer, Integer, Character, Boolean>(){

            public final Boolean invoke(int keyCode, int n, char c) {
                if (!listening) {
                    return false;
                }
                return switch (keyCode) {
                    case 256 -> {
                        this.stopListening();
                        yield true;
                    }
                    case 259 -> {
                        this.setKey(0);
                        yield true;
                    }
                    case 257 -> {
                        this.stopListening();
                        yield true;
                    }
                    default -> {
                        this.setKey(keyCode);
                        yield true;
                    }
                };
            }
        });
    }

    public final int getSelectedKey() {
        return this.selectedKey;
    }

    private final void startListening() {
        this.listening = true;
        this.keybindText.setText("...");
        this.updateButtonSize();
        PresetsKt.colorTo$default((VexelElement)((VexelElement)this.keybindButton), (int)Theme.Primary.getColor(), (long)150L, (EasingType)EasingType.EASE_OUT, null, (int)8, null);
    }

    private final void stopListening() {
        this.listening = false;
        this.keybindText.setText(this.getKeyName(this.selectedKey));
        this.updateButtonSize();
        PresetsKt.colorTo$default((VexelElement)((VexelElement)this.keybindButton), (int)Theme.BgLight.getColor(), (long)150L, (EasingType)EasingType.EASE_IN, null, (int)8, null);
    }

    private final void setKey(int keyCode) {
        this.selectedKey = keyCode;
        Iterable $this$forEach$iv = this.getOnValueChange();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)this.selectedKey);
        }
        this.stopListening();
    }

    private final void updateButtonSize() {
        float textWidth = NVGRenderer.INSTANCE.textWidth(this.keybindText.getText(), 16.0f, NVGRenderer.INSTANCE.getDefaultFont());
        this.keybindButton.setSizing(textWidth + 12.0f, Size.Pixels, 20.0f, Size.Pixels);
    }

    private final String getKeyName(int keyCode) {
        int n = keyCode;
        return n == 0 ? "None" : ((-100 <= n ? n < 0 : false) ? "Mouse " + (keyCode + 100) : KnitInputs.getDisplayName$default((int)keyCode, (int)0, (int)2, null));
    }

    protected void onRender(float mouseX, float mouseY) {
    }
}

