/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.features.map.render;

import java.awt.Color;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;
import xyz.meowing.knit.api.KnitPlayer;
import xyz.meowing.krypt.api.dungeons.DungeonAPI;
import xyz.meowing.krypt.api.dungeons.enums.DungeonClass;
import xyz.meowing.krypt.api.dungeons.enums.DungeonFloor;
import xyz.meowing.krypt.api.dungeons.enums.DungeonPlayer;
import xyz.meowing.krypt.features.map.DungeonMap;
import xyz.meowing.krypt.features.map.utils.Utils;
import xyz.meowing.krypt.utils.rendering.Render2D;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ7\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J7\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lxyz/meowing/krypt/features/map/render/BossMapRenderer;", "", "<init>", "()V", "Lnet/minecraft/class_332;", "context", "", "renderBossMap", "(Lnet/minecraft/class_332;)V", "Lxyz/meowing/krypt/features/map/utils/Utils$BossMapData;", "bossMap", "", "offsetX", "offsetY", "", "sizeInWorld", "renderBossPlayers", "(Lnet/minecraft/class_332;Lxyz/meowing/krypt/features/map/utils/Utils$BossMapData;DDI)V", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonPlayer;", "player", "x", "y", "", "rotation", "renderBossPlayerIcon", "(Lnet/minecraft/class_332;Lxyz/meowing/krypt/api/dungeons/enums/DungeonPlayer;DDF)V", "MAP_SIZE", "I", "Krypt"})
@SourceDebugExtension(value={"SMAP\nBossMapRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BossMapRenderer.kt\nxyz/meowing/krypt/features/map/render/BossMapRenderer\n+ 2 Render2D.kt\nxyz/meowing/krypt/utils/rendering/Render2D\n*L\n1#1,121:1\n157#2,11:122\n157#2,11:133\n157#2,11:144\n*S KotlinDebug\n*F\n+ 1 BossMapRenderer.kt\nxyz/meowing/krypt/features/map/render/BossMapRenderer\n*L\n43#1:122,11\n75#1:133,11\n90#1:144,11\n*E\n"})
public final class BossMapRenderer {
    @NotNull
    public static final BossMapRenderer INSTANCE = new BossMapRenderer();
    private static final int MAP_SIZE = 128;

    private BossMapRenderer() {
    }

    public final void renderBossMap(@NotNull class_332 context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Matrix3x2fStack matrix = context.method_51448();
        class_746 class_7462 = KnitPlayer.getPlayer();
        if (class_7462 == null || (class_7462 = class_7462.method_73189()) == null) {
            return;
        }
        class_746 playerPos = class_7462;
        DungeonFloor dungeonFloor = DungeonAPI.INSTANCE.getFloor();
        if (dungeonFloor == null) {
            return;
        }
        Utils.BossMapData bossMapData = Utils.BossMapRegistry.INSTANCE.getBossMap(dungeonFloor.getFloorNumber(), (class_243)playerPos);
        if (bossMapData == null) {
            return;
        }
        Utils.BossMapData bossMap = bossMapData;
        String texture = bossMap.getImage();
        double textureWidth = 256.0;
        double textureHeight = 256.0;
        int sizeInWorld = Math.min(bossMap.getWidthInWorld(), bossMap.getHeightInWorld());
        Integer n = bossMap.getRenderSize();
        int renderSize = n != null ? n.intValue() : bossMap.getWidthInWorld();
        double scale = (double)128 / (textureWidth / (double)bossMap.getWidthInWorld() * (double)renderSize);
        double offsetX = 0.0;
        offsetX = (playerPos.field_1352 - ((Number)bossMap.getTopLeftLocation().get(0)).doubleValue()) / (double)sizeInWorld * (double)128 - (double)64;
        double offsetY = 0.0;
        offsetY = (playerPos.field_1350 - ((Number)bossMap.getTopLeftLocation().get(1)).doubleValue()) / (double)sizeInWorld * (double)128 - (double)64;
        offsetX = RangesKt.coerceIn((double)offsetX, (double)0.0, (double)Math.max(0.0, textureWidth * scale - (double)128));
        offsetY = RangesKt.coerceIn((double)offsetY, (double)0.0, (double)Math.max(0.0, textureHeight * scale - (double)128));
        Render2D render2D = Render2D.INSTANCE;
        class_332 $this$pushPop$iv = context;
        boolean $i$f$pushPop = false;
        $this$pushPop$iv.method_51448().pushMatrix();
        boolean bl = false;
        matrix.translate(5.0f, 5.0f);
        context.method_44379(0, 0, 128, 128);
        class_2960 class_29602 = class_2960.method_60655((String)"krypt", (String)("krypt/boss/" + texture));
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"fromNamespaceAndPath(...)");
        Render2D.INSTANCE.drawImage(context, class_29602, (int)(-offsetX), (int)(-offsetY), (int)(textureWidth * scale), (int)(textureHeight * scale));
        INSTANCE.renderBossPlayers(context, bossMap, offsetX, offsetY, sizeInWorld);
        context.method_44380();
        $this$pushPop$iv.method_51448().popMatrix();
    }

    private final void renderBossPlayers(class_332 context, Utils.BossMapData bossMap, double offsetX, double offsetY, int sizeInWorld) {
        Matrix3x2fStack matrix = context.method_51448();
        for (DungeonPlayer player : DungeonAPI.INSTANCE.getPlayers()) {
            boolean ownName;
            if (player == null || player.getDead() && !Intrinsics.areEqual((Object)player.getName(), (Object)KnitPlayer.getName())) continue;
            Double d = player.getIconX();
            if (d == null) {
                continue;
            }
            double realX = d;
            Double d2 = player.getIconZ();
            if (d2 == null) {
                continue;
            }
            double realY = d2;
            Float f = player.getYaw();
            if (f == null) {
                continue;
            }
            float rotation = f.floatValue();
            double x = (realX - ((Number)bossMap.getTopLeftLocation().get(0)).doubleValue()) / (double)sizeInWorld * (double)128 - offsetX;
            double y = (realY - ((Number)bossMap.getTopLeftLocation().get(1)).doubleValue()) / (double)sizeInWorld * (double)128 - offsetY;
            boolean bl = ownName = !DungeonMap.INSTANCE.getShowOwnPlayer() && Intrinsics.areEqual((Object)player.getName(), (Object)KnitPlayer.getName());
            if (DungeonAPI.INSTANCE.getHoldingLeaps() && DungeonMap.INSTANCE.getShowPlayerNametags() && !ownName) {
                Render2D render2D = Render2D.INSTANCE;
                class_332 $this$pushPop$iv = context;
                boolean $i$f$pushPop = false;
                $this$pushPop$iv.method_51448().pushMatrix();
                boolean bl2 = false;
                matrix.translate((float)x, (float)y);
                Utils.INSTANCE.renderNametag(context, player.getName(), 0.7692308f);
                $this$pushPop$iv.method_51448().popMatrix();
            }
            this.renderBossPlayerIcon(context, player, x, y, rotation);
        }
    }

    private final void renderBossPlayerIcon(class_332 context, DungeonPlayer player, double x, double y, float rotation) {
        Render2D render2D = Render2D.INSTANCE;
        class_332 $this$pushPop$iv = context;
        boolean $i$f$pushPop = false;
        $this$pushPop$iv.method_51448().pushMatrix();
        boolean bl = false;
        Matrix3x2fStack matrix = context.method_51448();
        matrix.translate((float)x, (float)y);
        matrix.rotate((float)((double)rotation * (Math.PI / 180)));
        matrix.scale(1.0f, 1.0f);
        if (DungeonMap.INSTANCE.getShowPlayerHead()) {
            Color borderColor;
            Color color;
            Color color2;
            if (DungeonMap.INSTANCE.getIconClassColors()) {
                DungeonClass dungeonClass = player.getDungeonClass();
                color2 = dungeonClass != null ? dungeonClass.getMapColor() : null;
            } else {
                color2 = DungeonMap.INSTANCE.getPlayerIconBorderColor();
            }
            if ((color = (borderColor = color2)) == null) {
                color = DungeonClass.Companion.getDefaultColor();
            }
            Render2D.INSTANCE.drawRect(context, -6, -6, 12, 12, color);
            float borderSize = (float)DungeonMap.INSTANCE.getPlayerIconBorderSize();
            matrix.scale(1.0f - borderSize, 1.0f - borderSize);
            UUID uUID = player.getUuid();
            if (uUID == null) {
                uUID = new UUID(0L, 0L);
            }
            Render2D.INSTANCE.drawPlayerHead(context, -6, -6, 12, uUID);
        } else {
            class_2960 head = Intrinsics.areEqual((Object)player.getName(), (Object)KnitPlayer.getName()) ? Utils.INSTANCE.getMarkerSelf() : Utils.INSTANCE.getMarkerOther();
            Render2D.INSTANCE.drawImage(context, head, -4, -5, 7, 10);
        }
        $this$pushPop$iv.method_51448().popMatrix();
    }
}

