/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.dungeons.handlers;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_9428;
import org.jetbrains.annotations.NotNull;
import xyz.meowing.krypt.Krypt;
import xyz.meowing.krypt.api.dungeons.DungeonAPI;
import xyz.meowing.krypt.api.dungeons.enums.DungeonPlayer;
import xyz.meowing.krypt.api.dungeons.enums.map.Checkmark;
import xyz.meowing.krypt.api.dungeons.enums.map.Door;
import xyz.meowing.krypt.api.dungeons.enums.map.DoorState;
import xyz.meowing.krypt.api.dungeons.enums.map.DoorType;
import xyz.meowing.krypt.api.dungeons.enums.map.Room;
import xyz.meowing.krypt.api.dungeons.enums.map.RoomClearInfo;
import xyz.meowing.krypt.api.dungeons.enums.map.RoomType;
import xyz.meowing.krypt.api.dungeons.handlers.MapUtils;
import xyz.meowing.krypt.api.dungeons.utils.ScanUtils;
import xyz.meowing.krypt.mixins.AccessorMapState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJO\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016JG\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ7\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010#\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$J+\u0010)\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010%2\b\u0010'\u001a\u0004\u0018\u00010%2\u0006\u0010(\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b)\u0010*J7\u00101\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020+H\u0002\u00a2\u0006\u0004\b1\u00102R\u0014\u00103\u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00105\u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b5\u00104R\u0014\u00106\u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b6\u00104R\u0014\u00107\u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b7\u00104R\u0014\u00108\u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b8\u00104R\u0014\u00109\u001a\u00020\f8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b9\u00104\u00a8\u0006:"}, d2={"Lxyz/meowing/krypt/api/dungeons/handlers/MapScanner;", "", "<init>", "()V", "Lnet/minecraft/class_22;", "state", "", "updatePlayers", "(Lnet/minecraft/class_22;)V", "scan", "", "colors", "", "cx", "cz", "x", "z", "", "center", "rcolor", "halfMapGap", "scanRoom", "([BIIIIBBI)V", "Lxyz/meowing/krypt/api/dungeons/enums/map/Room;", "room", "scanRoomNeighbors", "([BIIIILxyz/meowing/krypt/api/dungeons/enums/map/Room;I)V", "idx", "scanDoor", "([BIIIB)V", "", "isDoorPattern", "([BI)Z", "Lxyz/meowing/krypt/api/dungeons/enums/map/Checkmark;", "check", "roomCleared", "(Lxyz/meowing/krypt/api/dungeons/enums/map/Room;Lxyz/meowing/krypt/api/dungeons/enums/map/Checkmark;)V", "", "decorationId", "reason", "index", "dungeonPlayerError", "(Ljava/lang/String;Ljava/lang/String;I)V", "", "n", "inMin", "inMax", "outMin", "outMax", "clampMap", "(DDDDD)D", "MAP_SIZE", "I", "DOOR_CHECK_OFFSET_H1", "DOOR_CHECK_OFFSET_H2", "DOOR_CHECK_OFFSET_V1", "DOOR_CHECK_OFFSET_V2", "ROOM_COLOR_OFFSET", "Krypt"})
@SourceDebugExtension(value={"SMAP\nMapScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapScanner.kt\nxyz/meowing/krypt/api/dungeons/handlers/MapScanner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1#2:285\n1869#3,2:286\n*S KotlinDebug\n*F\n+ 1 MapScanner.kt\nxyz/meowing/krypt/api/dungeons/handlers/MapScanner\n*L\n248#1:286,2\n*E\n"})
public final class MapScanner {
    @NotNull
    public static final MapScanner INSTANCE = new MapScanner();
    private static final int MAP_SIZE = 128;
    private static final int DOOR_CHECK_OFFSET_H1 = -132;
    private static final int DOOR_CHECK_OFFSET_H2 = -124;
    private static final int DOOR_CHECK_OFFSET_V1 = -640;
    private static final int DOOR_CHECK_OFFSET_V2 = 384;
    private static final int ROOM_COLOR_OFFSET = 517;

    private MapScanner() {
    }

    /*
     * WARNING - void declaration
     */
    public final void updatePlayers(@NotNull class_22 state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map<String, class_20> decorations = ((AccessorMapState)state).getDecorations();
        int playerIndex = 1;
        Intrinsics.checkNotNull(decorations);
        for (Map.Entry<String, class_20> entry : decorations.entrySet()) {
            Room room;
            Double d;
            Double d2;
            double it;
            DungeonPlayer dungeonPlayer;
            DungeonPlayer player;
            String key = entry.getKey();
            class_20 mapDecoration = entry.getValue();
            boolean isFrame = ((class_9428)mapDecoration.comp_1842().comp_349()).equals(class_21.field_95.comp_349());
            if (isFrame) {
                v0 = (DungeonPlayer)ArraysKt.firstOrNull((Object[])DungeonAPI.INSTANCE.getPlayers());
            } else {
                DungeonPlayer dplayer = null;
                while (playerIndex < DungeonAPI.INSTANCE.getPlayers().length) {
                    DungeonPlayer p = DungeonAPI.INSTANCE.getPlayers()[playerIndex++];
                    if (p == null || p.getDead()) continue;
                    dplayer = p;
                    break;
                }
                v0 = player = dplayer;
            }
            if (player == null) {
                this.dungeonPlayerError(key, "not found", playerIndex - 1);
                continue;
            }
            if (player.getDead()) {
                this.dungeonPlayerError(key, "not alive", playerIndex - 1);
                continue;
            }
            if (player.getUuid() == null) {
                this.dungeonPlayerError(key, "has null uuid", playerIndex - 1);
                continue;
            }
            if (player.getInRender()) continue;
            double mapSize = (double)MapUtils.INSTANCE.getMapRoomSize() * (double)6 + 20.0;
            double defaultSize = ((Number)ScanUtils.INSTANCE.getDefaultMapSize().getFirst()).intValue();
            Intrinsics.checkNotNull((Object)mapDecoration);
            player.setIconX(this.clampMap((double)MapUtils.INSTANCE.getMapX(mapDecoration) - ((Number)MapUtils.INSTANCE.getMapCorners().getFirst()).doubleValue(), 0.0, mapSize, 0.0, defaultSize));
            player.setIconZ(this.clampMap((double)MapUtils.INSTANCE.getMapZ(mapDecoration) - ((Number)MapUtils.INSTANCE.getMapCorners().getSecond()).doubleValue(), 0.0, mapSize, 0.0, defaultSize));
            DungeonPlayer dungeonPlayer2 = player;
            Double d3 = player.getIconX();
            if (d3 != null) {
                double d4 = ((Number)d3).doubleValue();
                dungeonPlayer = dungeonPlayer2;
                boolean bl = false;
                d2 = INSTANCE.clampMap(it, 0.0, 125.0, -200.0, -10.0);
                dungeonPlayer2 = dungeonPlayer;
            } else {
                d2 = null;
            }
            dungeonPlayer2.setRealX(d2);
            DungeonPlayer dungeonPlayer3 = player;
            Double d5 = player.getIconZ();
            if (d5 != null) {
                it = ((Number)d5).doubleValue();
                dungeonPlayer = dungeonPlayer3;
                boolean bl = false;
                d = INSTANCE.clampMap(it, 0.0, 125.0, -200.0, -10.0);
                dungeonPlayer3 = dungeonPlayer;
            } else {
                d = null;
            }
            dungeonPlayer3.setRealZ(d);
            player.setYaw(Float.valueOf(MapUtils.INSTANCE.getYaw(mapDecoration) + 180.0f));
            DungeonPlayer dungeonPlayer4 = player;
            Double d6 = player.getRealX();
            if (d6 != null) {
                Room room2;
                int n = (int)d6.doubleValue();
                dungeonPlayer = dungeonPlayer4;
                boolean bl = false;
                Double d7 = player.getRealZ();
                if (d7 != null) {
                    void x;
                    int z = (int)d7.doubleValue();
                    boolean bl2 = false;
                    if (DungeonAPI.INSTANCE.getRoomAt((int)x, z) != null) {
                        Room room3;
                        Room it2 = room3;
                        boolean bl3 = false;
                        it2.getPlayers().add(player);
                        room2 = room3;
                    } else {
                        room2 = null;
                    }
                } else {
                    room2 = null;
                }
                room = room2;
                dungeonPlayer4 = dungeonPlayer;
            } else {
                room = null;
            }
            dungeonPlayer4.setCurrRoom(room);
        }
    }

    public final void scan(@NotNull class_22 state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        byte[] colors = state.field_122;
        Pair<Integer, Integer> mapCorner = MapUtils.INSTANCE.getMapCorners();
        int mapGapSize = MapUtils.INSTANCE.getMapGapSize();
        int halfMapGap = mapGapSize / 2;
        int cx = -1;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)(((Number)mapCorner.getFirst()).intValue() + MapUtils.INSTANCE.getMapRoomSize() / 2), (int)118)), (int)halfMapGap);
        int x = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && x <= n || n2 < 0 && n <= x) {
            while (true) {
                int cz = -1;
                ++cx;
                IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)(((Number)mapCorner.getSecond()).intValue() + MapUtils.INSTANCE.getMapRoomSize() / 2 + 1), (int)118)), (int)halfMapGap);
                int z = intProgression2.getFirst();
                int n3 = intProgression2.getLast();
                int n4 = intProgression2.getStep();
                if (n4 > 0 && z <= n3 || n4 < 0 && n3 <= z) {
                    while (true) {
                        ++cz;
                        int idx = x + z * 128;
                        Intrinsics.checkNotNull((Object)colors);
                        Byte by = ArraysKt.getOrNull((byte[])colors, (int)(idx - 1));
                        if (by == null) {
                        } else {
                            byte center = by;
                            Byte by2 = ArraysKt.getOrNull((byte[])colors, (int)(idx + 517));
                            if (by2 == null) {
                            } else {
                                boolean isRoomCenter;
                                byte rcolor = by2;
                                boolean bl = isRoomCenter = cx % 2 == 0 && cz % 2 == 0;
                                if (isRoomCenter && rcolor != 0) {
                                    this.scanRoom(colors, cx, cz, x, z, center, rcolor, halfMapGap);
                                } else if (!isRoomCenter && center != 0) {
                                    this.scanDoor(colors, cx, cz, idx, center);
                                }
                            }
                        }
                        if (z == n3) break;
                        z += n4;
                    }
                }
                if (x == n) break;
                x += n2;
            }
        }
    }

    private final void scanRoom(byte[] colors, int cx, int cz, int x, int z, byte center, byte rcolor, int halfMapGap) {
        Checkmark check;
        Checkmark checkmark;
        Object it;
        int rmx = cx / 2;
        int rmz = cz / 2;
        int roomIdx = DungeonAPI.INSTANCE.getRoomIdx((Pair<Integer, Integer>)TuplesKt.to((Object)rmx, (Object)rmz));
        Room room = DungeonAPI.INSTANCE.getRooms()[roomIdx];
        if (room == null) {
            Room room2;
            it = room2 = new Room(TuplesKt.to((Object)rmx, (Object)rmz), null, 2, null);
            boolean bl = false;
            DungeonAPI.INSTANCE.getRooms()[roomIdx] = it;
            DungeonAPI.INSTANCE.getUniqueRooms().add((Room)it);
            room = room2;
        }
        Room room3 = room;
        this.scanRoomNeighbors(colors, cx, cz, x, z, room3, halfMapGap);
        if (room3.getType() == RoomType.UNKNOWN && room3.getHeight() == null) {
            room3.loadFromMapColor(rcolor);
        }
        if (rcolor == 0) {
            room3.setExplored(false);
            return;
        }
        if (center == 119 || rcolor == 85) {
            room3.setExplored(false);
            room3.setCheckmark(Checkmark.UNEXPLORED);
            DungeonAPI.INSTANCE.getDiscoveredRooms().put(rmx + "/" + rmz, new DungeonAPI.DiscoveredRoom(rmx, rmz, room3));
            return;
        }
        if (rcolor == 18 && DungeonAPI.INSTANCE.getBloodKilledAll() && center == 30) {
            if (room3.getCheckmark() != Checkmark.GREEN) {
                this.roomCleared(room3, Checkmark.GREEN);
            }
            checkmark = Checkmark.GREEN;
        } else if (rcolor == 18 && DungeonAPI.INSTANCE.getBloodSpawnedAll()) {
            if (room3.getCheckmark() != Checkmark.WHITE) {
                this.roomCleared(room3, Checkmark.WHITE);
            }
            checkmark = Checkmark.WHITE;
        } else if (center == 30 && rcolor != 30) {
            if (room3.getCheckmark() != Checkmark.GREEN) {
                this.roomCleared(room3, Checkmark.GREEN);
            }
            checkmark = Checkmark.GREEN;
        } else if (center == 34) {
            if (room3.getCheckmark() != Checkmark.WHITE) {
                this.roomCleared(room3, Checkmark.WHITE);
            }
            checkmark = Checkmark.WHITE;
        } else if (center == 18 && rcolor != 18) {
            checkmark = Checkmark.FAILED;
        } else if (room3.getCheckmark() == Checkmark.UNEXPLORED) {
            room3.setClearTime(System.currentTimeMillis());
            checkmark = Checkmark.NONE;
        } else {
            checkmark = null;
        }
        Checkmark checkmark2 = check = checkmark;
        if (checkmark2 != null) {
            it = checkmark2;
            boolean bl = false;
            room3.setCheckmark((Checkmark)((Object)it));
        }
        room3.setExplored(true);
        DungeonAPI.INSTANCE.getDiscoveredRooms().remove(rmx + "/" + rmz);
    }

    private final void scanRoomNeighbors(byte[] colors, int cx, int cz, int x, int z, Room room, int halfMapGap) {
        for (Pair<Integer, Integer> pair : ScanUtils.INSTANCE.getMapDirections()) {
            boolean isDoor;
            int dx = ((Number)pair.component1()).intValue();
            int dz = ((Number)pair.component2()).intValue();
            int doorCx = cx + dx;
            int doorCz = cz + dz;
            if (doorCx % 2 == 0 && doorCz % 2 == 0) continue;
            int doorX = x + dx * halfMapGap;
            int doorZ = z + dz * halfMapGap;
            int doorIdx = doorX + doorZ * 128;
            Byte doorCenter = ArraysKt.getOrNull((byte[])colors, (int)doorIdx);
            boolean isGap = doorCenter == null || doorCenter == 0;
            boolean bl = isDoor = !isGap ? this.isDoorPattern(colors, doorIdx) : false;
            if (isGap || isDoor) continue;
            int neighborCx = cx + dx * 2;
            int neighborCz = cz + dz * 2;
            Pair neighborComp = TuplesKt.to((Object)(neighborCx / 2), (Object)(neighborCz / 2));
            int neighborIdx = DungeonAPI.INSTANCE.getRoomIdx((Pair<Integer, Integer>)neighborComp);
            boolean bl2 = 0 <= neighborIdx ? neighborIdx < DungeonAPI.INSTANCE.getRooms().length : false;
            if (!bl2) continue;
            Room neighborRoom = DungeonAPI.INSTANCE.getRooms()[neighborIdx];
            if (neighborRoom == null) {
                Room.addComponent$default(room, neighborComp, false, 2, null);
                DungeonAPI.INSTANCE.getRooms()[neighborIdx] = room;
                continue;
            }
            if (Intrinsics.areEqual((Object)neighborRoom, (Object)room) || neighborRoom.getType() == RoomType.ENTRANCE || room.getType() == RoomType.ENTRANCE) continue;
            DungeonAPI.INSTANCE.mergeRooms(neighborRoom, room);
        }
    }

    private final void scanDoor(byte[] colors, int cx, int cz, int idx, byte center) {
        DoorType type2;
        if (!this.isDoorPattern(colors, idx)) {
            return;
        }
        Pair comp = TuplesKt.to((Object)cx, (Object)cz);
        int doorIdx = DungeonAPI.INSTANCE.getDoorIdx((Pair<Integer, Integer>)comp);
        Door existingDoor = DungeonAPI.INSTANCE.getDoorAtIdx(doorIdx);
        int rx = ((Number)ScanUtils.INSTANCE.getCornerStart().getFirst()).intValue() + 15 + cx * 16;
        int rz = ((Number)ScanUtils.INSTANCE.getCornerStart().getSecond()).intValue() + 15 + cz * 16;
        switch (center) {
            case 119: {
                DoorType doorType = DoorType.WITHER;
                break;
            }
            case 18: {
                DoorType doorType = DoorType.BLOOD;
                break;
            }
            default: {
                DoorType doorType = type2 = DoorType.NORMAL;
            }
        }
        if (existingDoor == null) {
            Door door;
            Door $this$scanDoor_u24lambda_u247 = door = new Door((Pair<Integer, Integer>)TuplesKt.to((Object)rx, (Object)rz), (Pair<Integer, Integer>)comp);
            boolean bl = false;
            $this$scanDoor_u24lambda_u247.setRotation(cz % 2 == 1 ? Integer.valueOf(0) : Integer.valueOf(1));
            $this$scanDoor_u24lambda_u247.setType(type2);
            $this$scanDoor_u24lambda_u247.setState(DoorState.DISCOVERED);
            Door newDoor = door;
            DungeonAPI.INSTANCE.addDoor(newDoor);
        } else {
            existingDoor.setState(DoorState.DISCOVERED);
            if (existingDoor.getType() == DoorType.NORMAL && type2 != DoorType.NORMAL) {
                existingDoor.setType(type2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isDoorPattern(byte[] colors, int idx) {
        v0 = ArraysKt.getOrNull((byte[])colors, (int)(idx + -132));
        v1 = v0 != null ? v0 == 0 : false;
        if (!v1) ** GOTO lbl-1000
        v2 = ArraysKt.getOrNull((byte[])colors, (int)(idx + -124));
        v3 = v2 != null ? v2 == 0 : false;
        if (v3) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        horiz = v4;
        v5 = ArraysKt.getOrNull((byte[])colors, (int)(idx + -640));
        v6 = v5 != null ? v5 == 0 : false;
        if (!v6) ** GOTO lbl-1000
        v7 = ArraysKt.getOrNull((byte[])colors, (int)(idx + 384));
        v8 = v7 != null ? v7 == 0 : false;
        if (v8) {
            v9 = true;
        } else lbl-1000:
        // 2 sources

        {
            v9 = false;
        }
        vert = v9;
        return horiz != false || vert != false;
    }

    private final void roomCleared(Room room, Checkmark check) {
        Set<DungeonPlayer> players = room.getPlayers();
        boolean isGreen = check == Checkmark.GREEN;
        String string = room.getName();
        if (string == null) {
            string = "unknown";
        }
        String roomKey = string;
        boolean isSolo = players.size() == 1;
        Iterable $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean alreadyCleared;
            DungeonPlayer player = (DungeonPlayer)element$iv;
            boolean bl = false;
            Map<String, RoomClearInfo> whiteChecks = player.getWhiteChecks();
            Map<String, RoomClearInfo> greenChecks = player.getGreenChecks();
            boolean bl2 = alreadyCleared = whiteChecks.containsKey(roomKey) || greenChecks.containsKey(roomKey);
            if (!alreadyCleared) {
                int n;
                if (isSolo) {
                    n = player.getMinRooms();
                    player.setMinRooms(n + 1);
                }
                n = player.getMaxRooms();
                player.setMaxRooms(n + 1);
            }
            String colorKey = isGreen ? "GREEN" : "WHITE";
            Map<String, RoomClearInfo> map = player.getClearedRooms().get(colorKey);
            if (map == null) continue;
            map.putIfAbsent(roomKey, new RoomClearInfo(System.currentTimeMillis() - room.getClearTime(), room, isSolo));
        }
    }

    private final void dungeonPlayerError(String decorationId, String reason, int index) {
        Krypt.getLOGGER().error("[Dungeon Map] Dungeon player for map decoration '{}' {}. Player list index (zero-indexed): {}.", (Object)decorationId, (Object)reason, (Object)index);
    }

    private final double clampMap(double n, double inMin, double inMax, double outMin, double outMax) {
        return n <= inMin ? outMin : (n >= inMax ? outMax : (n - inMin) * (outMax - outMin) / (inMax - inMin) + outMin);
    }
}

