/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.dungeons.handlers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.KnitClient;
import xyz.meowing.knit.api.events.EventCall;
import xyz.meowing.krypt.annotations.Module;
import xyz.meowing.krypt.api.dungeons.DungeonAPI;
import xyz.meowing.krypt.api.dungeons.enums.DungeonFloor;
import xyz.meowing.krypt.api.location.SkyBlockIsland;
import xyz.meowing.krypt.events.EventBus;
import xyz.meowing.krypt.events.core.PacketEvent;
import xyz.meowing.krypt.events.core.TickEvent;
import xyz.meowing.krypt.managers.events.EventBusManager;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\u0006\n\u0002\b\u0014\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0003R\u0015\u0010\u0015\u001a\u00020\r*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0017\u001a\u00020\r*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0015\u0010\u001b\u001a\u00020\u0018*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR.\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\"\u0010(\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010#\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\"\u0010,\u001a\u00020+8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\"\u00102\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u0010\t\"\u0004\b5\u00106R$\u00107\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010\u0006\"\u0004\b:\u0010;R$\u0010<\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u00108\u001a\u0004\b=\u0010\u0006\"\u0004\b>\u0010;\u00a8\u0006?"}, d2={"Lxyz/meowing/krypt/api/dungeons/handlers/MapUtils;", "", "<init>", "()V", "Lnet/minecraft/class_22;", "getCurrentMapState", "()Lnet/minecraft/class_22;", "", "calibrateDungeonMap", "()Z", "", "colors", "Lkotlin/Pair;", "", "findEntranceCorner", "([B)Lkotlin/Pair;", "", "reset", "Lnet/minecraft/class_20;", "getMapX", "(Lnet/minecraft/class_20;)I", "mapX", "getMapZ", "mapZ", "", "getYaw", "(Lnet/minecraft/class_20;)F", "yaw", "mapCorners", "Lkotlin/Pair;", "getMapCorners", "()Lkotlin/Pair;", "setMapCorners", "(Lkotlin/Pair;)V", "mapRoomSize", "I", "getMapRoomSize", "()I", "setMapRoomSize", "(I)V", "mapGapSize", "getMapGapSize", "setMapGapSize", "", "coordMultiplier", "D", "getCoordMultiplier", "()D", "setCoordMultiplier", "(D)V", "calibrated", "Z", "getCalibrated", "setCalibrated", "(Z)V", "mapData", "Lnet/minecraft/class_22;", "getMapData", "setMapData", "(Lnet/minecraft/class_22;)V", "guessMapData", "getGuessMapData", "setGuessMapData", "Krypt"})
@SourceDebugExtension(value={"SMAP\nMapUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapUtils.kt\nxyz/meowing/krypt/api/dungeons/handlers/MapUtils\n+ 2 EventBus.kt\nxyz/meowing/krypt/events/EventBus\n+ 3 EventBus.kt\nxyz/meowing/knit/api/events/EventBus\n*L\n1#1,119:1\n106#2,6:120\n112#2,3:132\n106#2,6:135\n112#2,3:147\n14#3,6:126\n14#3,6:141\n*S KotlinDebug\n*F\n+ 1 MapUtils.kt\nxyz/meowing/krypt/api/dungeons/handlers/MapUtils\n*L\n33#1:120,6\n33#1:132,3\n48#1:135,6\n48#1:147,3\n33#1:126,6\n48#1:141,6\n*E\n"})
public final class MapUtils {
    @NotNull
    public static final MapUtils INSTANCE;
    @NotNull
    private static Pair<Integer, Integer> mapCorners;
    private static int mapRoomSize;
    private static int mapGapSize;
    private static double coordMultiplier;
    private static boolean calibrated;
    @Nullable
    private static class_22 mapData;
    @Nullable
    private static class_22 guessMapData;

    private MapUtils() {
    }

    public final int getMapX(@NotNull class_20 $this$mapX) {
        Intrinsics.checkNotNullParameter((Object)$this$mapX, (String)"<this>");
        return $this$mapX.comp_1843() + 128 >> 1;
    }

    public final int getMapZ(@NotNull class_20 $this$mapZ) {
        Intrinsics.checkNotNullParameter((Object)$this$mapZ, (String)"<this>");
        return $this$mapZ.comp_1844() + 128 >> 1;
    }

    public final float getYaw(@NotNull class_20 $this$yaw) {
        Intrinsics.checkNotNullParameter((Object)$this$yaw, (String)"<this>");
        return (float)$this$yaw.comp_1845() * 22.5f;
    }

    @NotNull
    public final Pair<Integer, Integer> getMapCorners() {
        return mapCorners;
    }

    public final void setMapCorners(@NotNull Pair<Integer, Integer> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"<set-?>");
        mapCorners = pair;
    }

    public final int getMapRoomSize() {
        return mapRoomSize;
    }

    public final void setMapRoomSize(int n) {
        mapRoomSize = n;
    }

    public final int getMapGapSize() {
        return mapGapSize;
    }

    public final void setMapGapSize(int n) {
        mapGapSize = n;
    }

    public final double getCoordMultiplier() {
        return coordMultiplier;
    }

    public final void setCoordMultiplier(double d) {
        coordMultiplier = d;
    }

    public final boolean getCalibrated() {
        return calibrated;
    }

    public final void setCalibrated(boolean bl) {
        calibrated = bl;
    }

    @Nullable
    public final class_22 getMapData() {
        return mapData;
    }

    public final void setMapData(@Nullable class_22 class_222) {
        mapData = class_222;
    }

    @Nullable
    public final class_22 getGuessMapData() {
        return guessMapData;
    }

    public final void setGuessMapData(@Nullable class_22 class_222) {
        guessMapData = class_222;
    }

    @Nullable
    public final class_22 getCurrentMapState() {
        class_746 stack;
        block5: {
            block4: {
                class_746 class_7462 = KnitClient.getPlayer();
                if (class_7462 == null || (class_7462 = class_7462.method_31548()) == null || (class_7462 = class_7462.method_5438(8)) == null) {
                    return null;
                }
                stack = class_7462;
                if (!(stack.method_7909() instanceof class_1806)) break block4;
                String string = stack.method_7964().getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Magical Map", (boolean)false, (int)2, null)) break block5;
            }
            return null;
        }
        return class_1806.method_8001((class_1799)stack, (class_1937)((class_1937)KnitClient.getWorld()));
    }

    public final boolean calibrateDungeonMap() {
        int size;
        class_22 class_222 = this.getCurrentMapState();
        if (class_222 == null) {
            return false;
        }
        class_22 mapState = class_222;
        Intrinsics.checkNotNullExpressionValue((Object)mapState.field_122, (String)"colors");
        Pair<Integer, Integer> pair = this.findEntranceCorner(mapState.field_122);
        if (pair == null) {
            return false;
        }
        Pair<Integer, Integer> entranceInfo = pair;
        int startIndex = ((Number)entranceInfo.component1()).intValue();
        mapRoomSize = size = ((Number)entranceInfo.component2()).intValue();
        mapGapSize = mapRoomSize + 4;
        int x = startIndex % 128 % mapGapSize;
        int z = startIndex / 128 % mapGapSize;
        DungeonFloor dungeonFloor = DungeonAPI.INSTANCE.getFloor();
        if (dungeonFloor == null) {
            return false;
        }
        int floor = dungeonFloor.getFloorNumber();
        Object[] objectArray = new Integer[]{0, 1};
        if (CollectionsKt.listOf((Object[])objectArray).contains(floor)) {
            x += mapGapSize;
        }
        if (floor == 0) {
            z += mapGapSize;
        }
        mapCorners = TuplesKt.to((Object)x, (Object)z);
        coordMultiplier = (double)mapGapSize / 32.0;
        return true;
    }

    @Nullable
    public final Pair<Integer, Integer> findEntranceCorner(@NotNull byte[] colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        int n = colors.length;
        for (int i = 0; i < n; ++i) {
            if (colors[i] != 30 || i + 15 >= colors.length || colors[i + 15] != 30 || i + 1920 >= colors.length || colors[i + 1920] != 30) continue;
            int length = 0;
            while (i + length < colors.length && colors[i + length] == 30) {
                ++length;
            }
            return new Pair((Object)i, (Object)length);
        }
        return null;
    }

    public final void reset() {
        mapCorners = new Pair((Object)5, (Object)5);
        mapRoomSize = 16;
        mapGapSize = 0;
        coordMultiplier = 0.625;
        calibrated = false;
        mapData = null;
        guessMapData = null;
    }

    /*
     * WARNING - void declaration
     */
    static {
        SkyBlockIsland[] islands$iv;
        boolean add$iv$iv;
        void $this$iv$iv;
        EventBus $this$iv;
        INSTANCE = new MapUtils();
        mapCorners = new Pair((Object)5, (Object)5);
        mapRoomSize = 16;
        coordMultiplier = 0.625;
        EventBus eventBus = EventBus.INSTANCE;
        SkyBlockIsland[] skyBlockIslandArray = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        Function1 callback$iv = 1.INSTANCE;
        boolean skyblockOnly$iv = false;
        boolean $i$f$registerIn = false;
        xyz.meowing.knit.api.events.EventBus eventBus2 = $this$iv;
        boolean bl = false;
        Function1 callback$iv$iv = callback$iv;
        int priority$iv$iv = 0;
        boolean $i$f$register = false;
        EventCall eventCall$iv = $this$iv$iv.registerInternal(PacketEvent.Received.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        Set islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = 2.INSTANCE;
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(TickEvent.Client.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
    }
}

