/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.location;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.KnitClient;
import xyz.meowing.knit.api.events.Event;
import xyz.meowing.knit.api.events.EventCall;
import xyz.meowing.krypt.annotations.Module;
import xyz.meowing.krypt.api.location.SkyBlockArea;
import xyz.meowing.krypt.api.location.SkyBlockAreas;
import xyz.meowing.krypt.api.location.SkyBlockIsland;
import xyz.meowing.krypt.events.EventBus;
import xyz.meowing.krypt.events.core.LocationEvent;
import xyz.meowing.krypt.events.core.ScoreboardEvent;
import xyz.meowing.krypt.events.core.ServerEvent;
import xyz.meowing.krypt.events.core.TablistEvent;
import xyz.meowing.krypt.managers.events.EventBusManager;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003R\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\rR\"\u0010\u0011\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R*\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00108F@BX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R(\u0010\u001a\u001a\u0004\u0018\u00010\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u001e8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R(\u0010#\u001a\u0004\u0018\u00010\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00078\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R$\u0010'\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00108\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b'\u0010\u0012\u001a\u0004\b'\u0010\u0014R$\u0010(\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00108\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b(\u0010\u0012\u001a\u0004\b)\u0010\u0014R$\u0010*\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00108\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b*\u0010\u0012\u001a\u0004\b+\u0010\u0014R$\u0010-\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020,8F@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u0013\u00103\u001a\u0004\u0018\u00010,8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R$\u00105\u001a\u0002042\u0006\u0010\u0017\u001a\u0002048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108\u00a8\u00069"}, d2={"Lxyz/meowing/krypt/api/location/LocationAPI;", "", "<init>", "()V", "", "reset", "", "", "Lxyz/meowing/krypt/api/location/SkyBlockIsland;", "unknownAreas", "Ljava/util/Map;", "Lkotlin/text/Regex;", "locationRegex", "Lkotlin/text/Regex;", "guestRegex", "playerCountRegex", "", "forceOnSkyblock", "Z", "getForceOnSkyblock", "()Z", "setForceOnSkyblock", "(Z)V", "value", "isOnSkyBlock", "setOnSkyBlock", "island", "Lxyz/meowing/krypt/api/location/SkyBlockIsland;", "getIsland", "()Lxyz/meowing/krypt/api/location/SkyBlockIsland;", "Lxyz/meowing/krypt/api/location/SkyBlockArea;", "area", "Lxyz/meowing/krypt/api/location/SkyBlockArea;", "getArea", "()Lxyz/meowing/krypt/api/location/SkyBlockArea;", "serverId", "Ljava/lang/String;", "getServerId", "()Ljava/lang/String;", "isGuest", "onHypixel", "getOnHypixel", "onAlpha", "getOnAlpha", "", "playerCount", "I", "getPlayerCount", "()I", "getMaxPlayerCount", "()Ljava/lang/Integer;", "maxPlayerCount", "Lkotlin/time/Instant;", "lastServerChange", "Lkotlin/time/Instant;", "getLastServerChange", "()Lkotlin/time/Instant;", "Krypt"})
@SourceDebugExtension(value={"SMAP\nLocationAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationAPI.kt\nxyz/meowing/krypt/api/location/LocationAPI\n+ 2 EventBus.kt\nxyz/meowing/knit/api/events/EventBus\n+ 3 EventBus.kt\nxyz/meowing/krypt/events/EventBus\n*L\n1#1,146:1\n14#2,6:147\n14#2,6:154\n14#2,6:164\n14#2,6:174\n14#2,6:183\n111#3:153\n112#3,3:160\n111#3:163\n112#3,3:170\n111#3:173\n112#3,3:180\n*S KotlinDebug\n*F\n+ 1 LocationAPI.kt\nxyz/meowing/krypt/api/location/LocationAPI\n*L\n88#1:147,6\n100#1:154,6\n105#1:164,6\n109#1:174,6\n126#1:183,6\n100#1:153\n100#1:160,3\n105#1:163\n105#1:170,3\n109#1:173\n109#1:180,3\n*E\n"})
public final class LocationAPI {
    @NotNull
    public static final LocationAPI INSTANCE;
    @NotNull
    private static final Map<String, SkyBlockIsland> unknownAreas;
    @NotNull
    private static final Regex locationRegex;
    @NotNull
    private static final Regex guestRegex;
    @NotNull
    private static final Regex playerCountRegex;
    private static boolean forceOnSkyblock;
    private static boolean isOnSkyBlock;
    @Nullable
    private static SkyBlockIsland island;
    @NotNull
    private static SkyBlockArea area;
    @Nullable
    private static String serverId;
    private static boolean isGuest;
    private static boolean onHypixel;
    private static boolean onAlpha;
    private static int playerCount;
    @NotNull
    private static Instant lastServerChange;

    private LocationAPI() {
    }

    public final boolean getForceOnSkyblock() {
        return forceOnSkyblock;
    }

    public final void setForceOnSkyblock(boolean bl) {
        forceOnSkyblock = bl;
    }

    public final boolean isOnSkyBlock() {
        return isOnSkyBlock || forceOnSkyblock;
    }

    private final void setOnSkyBlock(boolean value) {
        if (isOnSkyBlock != value) {
            isOnSkyBlock = value;
            boolean bl = value ? xyz.meowing.knit.api.events.EventBus.post$default((xyz.meowing.knit.api.events.EventBus)EventBus.INSTANCE, (Event)new LocationEvent.SkyblockJoin(), (boolean)false, (int)2, null) : xyz.meowing.knit.api.events.EventBus.post$default((xyz.meowing.knit.api.events.EventBus)EventBus.INSTANCE, (Event)new LocationEvent.SkyblockLeave(), (boolean)false, (int)2, null);
        }
    }

    @Nullable
    public final SkyBlockIsland getIsland() {
        return island;
    }

    @NotNull
    public final SkyBlockArea getArea() {
        return area;
    }

    @Nullable
    public final String getServerId() {
        return serverId;
    }

    public final boolean isGuest() {
        return isGuest;
    }

    public final boolean getOnHypixel() {
        return onHypixel;
    }

    public final boolean getOnAlpha() {
        return onAlpha;
    }

    public final int getPlayerCount() {
        return RangesKt.coerceAtLeast((int)playerCount, (int)KnitClient.getPlayers().size());
    }

    @Nullable
    public final Integer getMaxPlayerCount() {
        Integer n;
        String string = serverId;
        boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"mega", (boolean)false, (int)2, null) : false;
        if (bl) {
            n = 60;
        } else {
            SkyBlockIsland skyBlockIsland = island;
            switch (skyBlockIsland == null ? -1 : WhenMappings.$EnumSwitchMapping$0[skyBlockIsland.ordinal()]) {
                case 1: 
                case 2: {
                    n = null;
                    break;
                }
                case 3: {
                    n = 4;
                    break;
                }
                case 4: {
                    n = 4;
                    break;
                }
                case 5: {
                    n = 5;
                    break;
                }
                case 6: {
                    n = 16;
                    break;
                }
                case 7: {
                    n = 26;
                    break;
                }
                case 8: {
                    n = 27;
                    break;
                }
                case 9: {
                    n = 30;
                    break;
                }
                default: {
                    n = 24;
                }
            }
        }
        return n;
    }

    @NotNull
    public final Instant getLastServerChange() {
        return lastServerChange;
    }

    private final void reset() {
        this.setOnSkyBlock(false);
        isGuest = false;
        onHypixel = false;
        onAlpha = false;
        serverId = null;
        area = SkyBlockAreas.INSTANCE.getNONE();
        SkyBlockIsland old = island;
        island = null;
        if (old != null) {
            xyz.meowing.knit.api.events.EventBus.post$default((xyz.meowing.knit.api.events.EventBus)EventBus.INSTANCE, (Event)new LocationEvent.IslandChange(old, null), (boolean)false, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        boolean skyblockOnly$iv;
        SkyBlockIsland[] islands$iv;
        boolean add$iv$iv;
        void $this$iv$iv;
        EventBus this_$iv;
        EventBus $this$iv;
        INSTANCE = new LocationAPI();
        unknownAreas = new LinkedHashMap();
        locationRegex = new Regex(" *[\u23e3\u0444] *(?<location>(?:\\s?[^\u0d60\\s]+)*)(?: \u0d60 x\\d)?");
        guestRegex = new Regex("^ *\u270c *\\((?<guests>\\d+)/(?<max>\\d+)\\) *$");
        playerCountRegex = new Regex(" *(?:players|party) \\((?<count>\\d+)\\) *");
        area = SkyBlockAreas.INSTANCE.getNONE();
        lastServerChange = Instant.Companion.getDISTANT_PAST();
        xyz.meowing.knit.api.events.EventBus eventBus = EventBus.INSTANCE;
        Function1 callback$iv = 1.INSTANCE;
        int priority$iv22 = 0;
        boolean add$iv = true;
        boolean $i$f$register = false;
        $this$iv.registerInternal(LocationEvent.ServerChange.class, priority$iv22, add$iv, callback$iv);
        $this$iv = EventBus.INSTANCE;
        SkyBlockIsland[] priority$iv22 = new SkyBlockIsland[]{};
        add$iv = true;
        callback$iv = 2.INSTANCE;
        boolean $i$f$registerIn = false;
        xyz.meowing.knit.api.events.EventBus eventBus2 = this_$iv;
        boolean bl = false;
        Function1 callback$iv$iv = callback$iv;
        int priority$iv$iv = 0;
        boolean $i$f$register2 = false;
        EventCall eventCall$iv = $this$iv$iv.registerInternal(TablistEvent.Change.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        Set islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        this_$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{};
        skyblockOnly$iv = true;
        callback$iv = 3.INSTANCE;
        $i$f$registerIn = false;
        islandSet$iv = this_$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register2 = false;
        eventCall$iv = $this$iv$iv.registerInternal(ScoreboardEvent.UpdateTitle.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        this_$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{};
        skyblockOnly$iv = true;
        callback$iv = 4.INSTANCE;
        $i$f$registerIn = false;
        islandSet$iv = this_$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register2 = false;
        eventCall$iv = $this$iv$iv.registerInternal(ScoreboardEvent.Update.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        this_$iv = EventBus.INSTANCE;
        callback$iv = 5.INSTANCE;
        int priority$iv = 0;
        add$iv = true;
        $i$f$register = false;
        $this$iv.registerInternal(ServerEvent.Disconnect.class, priority$iv, add$iv, callback$iv);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SkyBlockIsland.values().length];
            try {
                nArray[SkyBlockIsland.PRIVATE_ISLAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkyBlockIsland.GARDEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkyBlockIsland.KUUDRA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkyBlockIsland.MINESHAFT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkyBlockIsland.THE_CATACOMBS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkyBlockIsland.BACKWATER_BAYOU.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkyBlockIsland.HUB.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkyBlockIsland.JERRYS_WORKSHOP.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SkyBlockIsland.DARK_AUCTION.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

