/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.mixins;

import net.minecraft.class_1297;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.meowing.krypt.features.highlights.TeammateHighlight;
import xyz.meowing.krypt.utils.EntityAccessor;

@Mixin(value={class_1297.class})
public class MixinEntity
implements EntityAccessor {
    @Unique
    private boolean krypt$glowing = false;
    @Unique
    private int krypt$glowingColor = 0;
    @Unique
    private long krypt$glowTime = -1L;
    @Unique
    private boolean krypt$glowingThisFrame = false;

    @Inject(method={"getTeamColor"}, at={@At(value="HEAD")}, cancellable=true)
    public void getTeamColor(CallbackInfoReturnable<Integer> cir) {
        Integer color;
        if (this.hasCustomGlow()) {
            cir.setReturnValue((Object)this.krypt$glowingColor);
            this.krypt$glowingThisFrame = false;
        }
        if ((color = TeammateHighlight.getTeammateColor((class_1297)this)) != null) {
            cir.setReturnValue((Object)color);
        }
    }

    @Inject(method={"isCurrentlyGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    public void isGlowing(CallbackInfoReturnable<Boolean> cir) {
        if (this.hasCustomGlow()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public void krypt$setGlowing(boolean glowing) {
        this.krypt$glowing = glowing;
    }

    @Override
    public void krypt$setGlowingColor(int color) {
        this.krypt$glowingColor = color;
    }

    @Override
    public void krypt$glowTime(long time) {
        this.krypt$glowTime = System.currentTimeMillis() + time;
        this.krypt$glowing = false;
    }

    @Override
    public void krypt$setGlowingThisFrame(boolean glowing) {
        this.krypt$glowingThisFrame = glowing;
    }

    @Unique
    private boolean hasCustomGlow() {
        if (this.krypt$glowingThisFrame) {
            return true;
        }
        if (this.krypt$glowTime > System.currentTimeMillis()) {
            return true;
        }
        this.krypt$glowTime = -1L;
        return this.krypt$glowing;
    }
}

