/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.dungeons.handlers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.krypt.Krypt;
import xyz.meowing.krypt.annotations.Module;
import xyz.meowing.krypt.api.dungeons.enums.map.RoomMetadata;
import xyz.meowing.krypt.utils.HttpRetryableException;
import xyz.meowing.krypt.utils.NetworkUtils;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00070\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lxyz/meowing/krypt/api/dungeons/handlers/RoomRegistry;", "", "<init>", "()V", "", "loadFromLocal", "", "Lxyz/meowing/krypt/api/dungeons/enums/map/RoomMetadata;", "rooms", "populateRooms", "(Ljava/util/List;)V", "", "core", "getByCore", "(I)Lxyz/meowing/krypt/api/dungeons/enums/map/RoomMetadata;", "getAll", "()Ljava/util/List;", "", "byCore", "Ljava/util/Map;", "", "allRooms", "Ljava/util/List;", "Ljava/io/File;", "LOCAL_ROOMS_FILE", "Ljava/io/File;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "RoomMetadataDeserializer", "Krypt"})
@SourceDebugExtension(value={"SMAP\nRoomRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomRegistry.kt\nxyz/meowing/krypt/api/dungeons/handlers/RoomRegistry\n+ 2 NetworkUtils.kt\nxyz/meowing/krypt/utils/NetworkUtils\n*L\n1#1,89:1\n62#2,7:90\n85#2:97\n*S KotlinDebug\n*F\n+ 1 RoomRegistry.kt\nxyz/meowing/krypt/api/dungeons/handlers/RoomRegistry\n*L\n51#1:90,7\n51#1:97\n*E\n"})
public final class RoomRegistry {
    @NotNull
    public static final RoomRegistry INSTANCE;
    @NotNull
    private static final Map<Integer, RoomMetadata> byCore;
    @NotNull
    private static final List<RoomMetadata> allRooms;
    @NotNull
    private static final File LOCAL_ROOMS_FILE;
    @NotNull
    private static final Gson gson;

    private RoomRegistry() {
    }

    public final void loadFromLocal() {
        block3: {
            Object object;
            Object object2 = this;
            try {
                RoomRegistry $this$loadFromLocal_u24lambda_u242 = object2;
                boolean bl = false;
                if (!LOCAL_ROOMS_FILE.exists()) {
                    throw new FileNotFoundException("rooms.json not found in config directory");
                }
                String json = FilesKt.readText((File)LOCAL_ROOMS_FILE, (Charset)Charsets.UTF_8);
                Type type2 = new TypeToken<List<? extends RoomMetadata>>(){}.getType();
                Object object3 = gson.fromJson(json, type2);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
                List rooms = (List)object3;
                $this$loadFromLocal_u24lambda_u242.populateRooms(rooms);
                Krypt.getLOGGER().info("RoomRegistry: Loaded " + rooms.size() + " rooms from local config");
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl = false;
            Krypt.getLOGGER().info("RoomRegistry: Failed to load local room data \u2014 " + ((Throwable)it).getMessage());
        }
    }

    private final void populateRooms(List<RoomMetadata> rooms) {
        CollectionsKt.addAll((Collection)allRooms, (Iterable)rooms);
        for (RoomMetadata room : rooms) {
            Iterator<Integer> iterator = room.getCores().iterator();
            while (iterator.hasNext()) {
                int core = ((Number)iterator.next()).intValue();
                byCore.put(core, room);
            }
        }
    }

    @Nullable
    public final RoomMetadata getByCore(int core) {
        return byCore.get(core);
    }

    @NotNull
    public final List<RoomMetadata> getAll() {
        return allRooms;
    }

    public static final /* synthetic */ void access$populateRooms(RoomRegistry $this, List rooms) {
        $this.populateRooms(rooms);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        INSTANCE = new RoomRegistry();
        byCore = new LinkedHashMap();
        allRooms = new ArrayList();
        LOCAL_ROOMS_FILE = new File("config/krypt/rooms.json");
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)RoomMetadata.class), (Object)new RoomMetadataDeserializer()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        RoomRegistry.gson = gson;
        NetworkUtils networkUtils = NetworkUtils.INSTANCE;
        String url$iv = "https://raw.githubusercontent.com/StellariumMC/zen-data/refs/heads/main/assets/roomData.json";
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$fetchJson = false;
        BuildersKt.launch$default((CoroutineScope)$this$iv.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(url$iv, headers$iv, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $url;
            final /* synthetic */ Map $headers;
            {
                this.$url = $url;
                this.$headers = $headers;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object $this$invokeSuspend_u24lambda_u241;
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object = $this$launch;
                        String string = this.$url;
                        Object object2 = this.$headers;
                        try {
                            Object object3;
                            $this$invokeSuspend_u24lambda_u241 = object;
                            boolean bl = false;
                            HttpURLConnection connection = NetworkUtils.INSTANCE.createConnection(string, MapsKt.plus((Map)object2, (Pair)TuplesKt.to((Object)"Accept", (Object)"application/json")));
                            connection.setRequestMethod("GET");
                            if (connection.getResponseCode() == 200) {
                                InputStream inputStream = connection.getInputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                                Closeable closeable = inputStream;
                                Object object4 = Charsets.UTF_8;
                                object3 = new InputStreamReader((InputStream)closeable, (Charset)object4);
                                int n = 8192;
                                closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                                object4 = null;
                                try {
                                    BufferedReader it = (BufferedReader)closeable;
                                    boolean bl2 = false;
                                    object3 = TextStreamsKt.readText((Reader)it);
                                }
                                catch (Throwable throwable) {
                                    object4 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object4);
                                }
                            } else {
                                String string2 = "HTTP " + connection.getResponseCode();
                                int n = connection.getResponseCode();
                                URL uRL = connection.getURL();
                                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getURL(...)");
                                throw new HttpRetryableException(string2, n, uRL);
                            }
                            Object response = object3;
                            Type type2 = new TypeToken<List<? extends RoomMetadata>>(){}.getType();
                            Object data = new Gson().fromJson((String)response, type2);
                            List rooms = (List)data;
                            boolean bl3 = false;
                            RoomRegistry.access$populateRooms(RoomRegistry.INSTANCE, rooms);
                            Krypt.getLOGGER().info("RoomRegistry: Loaded " + rooms.size() + " rooms.");
                            connection.disconnect();
                            $this$invokeSuspend_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable) {
                            $this$invokeSuspend_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        object = $this$invokeSuspend_u24lambda_u241;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                        if (throwable != null) {
                            Object it = object2 = throwable;
                            boolean bl = false;
                            Exception exception = it instanceof Exception ? (Exception)it : null;
                            if (exception == null) {
                                exception = new Exception((Throwable)it);
                            }
                            Exception error = exception;
                            boolean bl4 = false;
                            Krypt.getLOGGER().info("RoomRegistry: Failed to load room data \u2014 " + error.getMessage());
                            RoomRegistry.INSTANCE.loadFromLocal();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lxyz/meowing/krypt/api/dungeons/handlers/RoomRegistry$RoomMetadataDeserializer;", "Lcom/google/gson/JsonDeserializer;", "Lxyz/meowing/krypt/api/dungeons/enums/map/RoomMetadata;", "<init>", "()V", "Lcom/google/gson/JsonElement;", "json", "Ljava/lang/reflect/Type;", "typeOfT", "Lcom/google/gson/JsonDeserializationContext;", "context", "deserialize", "(Lcom/google/gson/JsonElement;Ljava/lang/reflect/Type;Lcom/google/gson/JsonDeserializationContext;)Lxyz/meowing/krypt/api/dungeons/enums/map/RoomMetadata;", "Krypt"})
    @SourceDebugExtension(value={"SMAP\nRoomRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomRegistry.kt\nxyz/meowing/krypt/api/dungeons/handlers/RoomRegistry$RoomMetadataDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1563#2:90\n1634#2,3:91\n*S KotlinDebug\n*F\n+ 1 RoomRegistry.kt\nxyz/meowing/krypt/api/dungeons/handlers/RoomRegistry$RoomMetadataDeserializer\n*L\n34#1:90\n34#1:91,3\n*E\n"})
    private static final class RoomMetadataDeserializer
    implements JsonDeserializer<RoomMetadata> {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public RoomMetadata deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)typeOfT, (String)"typeOfT");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsonObject obj = json.getAsJsonObject();
            String string = obj.get("name").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
            String string2 = obj.get("type").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            JsonArray jsonArray = obj.get("cores").getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            Iterable iterable = (Iterable)jsonArray;
            String string4 = string3;
            String string5 = string;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAsInt());
            }
            collection = (List)destination$iv$iv;
            JsonElement jsonElement = obj.get("secrets");
            JsonElement jsonElement2 = obj.get("crypts");
            JsonElement jsonElement3 = obj.get("trappedChests");
            JsonElement jsonElement4 = obj.get("shape");
            JsonElement jsonElement5 = obj.get("doors");
            JsonElement jsonElement6 = obj.get("roomID");
            JsonElement jsonElement7 = obj.get("clear");
            String string6 = jsonElement7 != null ? jsonElement7.getAsString() : null;
            Integer n = jsonElement6 != null ? Integer.valueOf(jsonElement6.getAsInt()) : null;
            String string7 = jsonElement5 != null ? jsonElement5.getAsString() : null;
            String string8 = jsonElement4 != null ? jsonElement4.getAsString() : null;
            int n2 = jsonElement3 != null ? jsonElement3.getAsInt() : 0;
            int n3 = jsonElement2 != null ? jsonElement2.getAsInt() : 0;
            int n4 = jsonElement != null ? jsonElement.getAsInt() : 0;
            List list = collection;
            String string9 = string4;
            String string10 = string5;
            return new RoomMetadata(string10, string9, list, n4, n3, n2, string8, string7, n, string6);
        }
    }
}

