/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.dungeons.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.skyblockapi.utils.regex.RegexUtils;
import xyz.meowing.knit.api.events.EventCall;
import xyz.meowing.krypt.api.dungeons.DungeonAPI;
import xyz.meowing.krypt.api.dungeons.enums.DungeonFloor;
import xyz.meowing.krypt.api.dungeons.enums.map.Checkmark;
import xyz.meowing.krypt.api.dungeons.enums.map.Room;
import xyz.meowing.krypt.api.dungeons.enums.map.RoomType;
import xyz.meowing.krypt.api.location.SkyBlockIsland;
import xyz.meowing.krypt.events.EventBus;
import xyz.meowing.krypt.events.core.ScoreboardEvent;
import xyz.meowing.krypt.events.core.TablistEvent;
import xyz.meowing.krypt.features.alerts.ScoreAlert;
import xyz.meowing.krypt.managers.events.EventBusManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0011R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0019R\"\u0010\u001d\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u001e\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\"\u0010&\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010\u001e\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R\"\u0010)\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010\u001e\u001a\u0004\b*\u0010 \"\u0004\b+\u0010\"R\"\u0010-\u001a\u00020,8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\"\u00103\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010\u001e\u001a\u0004\b4\u0010 \"\u0004\b5\u0010\"R\"\u00106\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b6\u0010\u001e\u001a\u0004\b7\u0010 \"\u0004\b8\u0010\"R\"\u00109\u001a\u00020\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010\u001e\u001a\u0004\b:\u0010 \"\u0004\b;\u0010\"R\"\u0010<\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010\u0019\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\"\u0010A\u001a\u00020\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bA\u0010\u0019\u001a\u0004\bB\u0010>\"\u0004\bC\u0010@R\u0016\u0010G\u001a\u0004\u0018\u00010D8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0016\u0010J\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0014\u0010L\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010 R\u0011\u0010N\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010 R\u0011\u0010P\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010 R\u0011\u0010R\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010 R \u0010T\u001a\u000e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020,0S8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bT\u0010UR \u0010V\u001a\u000e\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020\u001c0S8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010U\u00a8\u0006W"}, d2={"Lxyz/meowing/krypt/api/dungeons/handlers/ScoreCalculator;", "", "<init>", "()V", "", "reset", "", "line", "parseTablist", "(Ljava/lang/String;)V", "parseSidebar", "", "percentage", "getSpeedDeduction", "(F)F", "Lkotlin/text/Regex;", "secretsFoundPattern", "Lkotlin/text/Regex;", "secretsFoundPercentagePattern", "cryptsPattern", "completedRoomsRegex", "dungeonClearedPattern", "timeElapsedPattern", "", "bloodDone", "Z", "alerted300", "alerted270", "", "deathCount", "I", "getDeathCount", "()I", "setDeathCount", "(I)V", "totalSecrets", "getTotalSecrets", "setTotalSecrets", "foundSecrets", "getFoundSecrets", "setFoundSecrets", "cryptsCount", "getCryptsCount", "setCryptsCount", "", "secretPercentage", "D", "getSecretPercentage", "()D", "setSecretPercentage", "(D)V", "clearedPercentage", "getClearedPercentage", "setClearedPercentage", "completedRooms", "getCompletedRooms", "setCompletedRooms", "secondsElapsed", "getSecondsElapsed", "setSecondsElapsed", "mimicKilled", "getMimicKilled", "()Z", "setMimicKilled", "(Z)V", "princeKilled", "getPrinceKilled", "setPrinceKilled", "Lxyz/meowing/krypt/api/dungeons/enums/DungeonFloor;", "getDungeonFloor", "()Lxyz/meowing/krypt/api/dungeons/enums/DungeonFloor;", "dungeonFloor", "getDungeonFloorNumber", "()Ljava/lang/Integer;", "dungeonFloorNumber", "getTotalRooms", "totalRooms", "getScore", "score", "getBonusScore", "bonusScore", "getSpeedScore", "speedScore", "", "requiredSecrets", "Ljava/util/Map;", "timeLimits", "Krypt"})
@SourceDebugExtension(value={"SMAP\nScoreCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreCalculator.kt\nxyz/meowing/krypt/api/dungeons/handlers/ScoreCalculator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 EventBus.kt\nxyz/meowing/krypt/events/EventBus\n+ 6 EventBus.kt\nxyz/meowing/knit/api/events/EventBus\n*L\n1#1,244:1\n3829#2:245\n4344#2,2:246\n1788#3,4:248\n1#4:252\n106#5,6:253\n112#5,3:265\n106#5,6:268\n112#5,3:280\n14#6,6:259\n14#6,6:274\n*S KotlinDebug\n*F\n+ 1 ScoreCalculator.kt\nxyz/meowing/krypt/api/dungeons/handlers/ScoreCalculator\n*L\n64#1:245\n64#1:246,2\n69#1:248,4\n106#1:253,6\n106#1:265,3\n110#1:268,6\n110#1:280,3\n106#1:259,6\n110#1:274,6\n*E\n"})
public final class ScoreCalculator {
    @NotNull
    public static final ScoreCalculator INSTANCE;
    @NotNull
    private static final Regex secretsFoundPattern;
    @NotNull
    private static final Regex secretsFoundPercentagePattern;
    @NotNull
    private static final Regex cryptsPattern;
    @NotNull
    private static final Regex completedRoomsRegex;
    @NotNull
    private static final Regex dungeonClearedPattern;
    @NotNull
    private static final Regex timeElapsedPattern;
    private static boolean bloodDone;
    private static boolean alerted300;
    private static boolean alerted270;
    private static int deathCount;
    private static int totalSecrets;
    private static int foundSecrets;
    private static int cryptsCount;
    private static double secretPercentage;
    private static int clearedPercentage;
    private static int completedRooms;
    private static int secondsElapsed;
    private static boolean mimicKilled;
    private static boolean princeKilled;
    @NotNull
    private static final Map<DungeonFloor, Double> requiredSecrets;
    @NotNull
    private static final Map<DungeonFloor, Integer> timeLimits;

    private ScoreCalculator() {
    }

    public final int getDeathCount() {
        return deathCount;
    }

    public final void setDeathCount(int n) {
        deathCount = n;
    }

    public final int getTotalSecrets() {
        return totalSecrets;
    }

    public final void setTotalSecrets(int n) {
        totalSecrets = n;
    }

    public final int getFoundSecrets() {
        return foundSecrets;
    }

    public final void setFoundSecrets(int n) {
        foundSecrets = n;
    }

    public final int getCryptsCount() {
        return cryptsCount;
    }

    public final void setCryptsCount(int n) {
        cryptsCount = n;
    }

    public final double getSecretPercentage() {
        return secretPercentage;
    }

    public final void setSecretPercentage(double d) {
        secretPercentage = d;
    }

    public final int getClearedPercentage() {
        return clearedPercentage;
    }

    public final void setClearedPercentage(int n) {
        clearedPercentage = n;
    }

    public final int getCompletedRooms() {
        return completedRooms;
    }

    public final void setCompletedRooms(int n) {
        completedRooms = n;
    }

    public final int getSecondsElapsed() {
        return secondsElapsed;
    }

    public final void setSecondsElapsed(int n) {
        secondsElapsed = n;
    }

    public final boolean getMimicKilled() {
        return mimicKilled;
    }

    public final void setMimicKilled(boolean bl) {
        mimicKilled = bl;
    }

    public final boolean getPrinceKilled() {
        return princeKilled;
    }

    public final void setPrinceKilled(boolean bl) {
        princeKilled = bl;
    }

    private final DungeonFloor getDungeonFloor() {
        return DungeonAPI.INSTANCE.getFloor();
    }

    private final Integer getDungeonFloorNumber() {
        DungeonFloor dungeonFloor = DungeonAPI.INSTANCE.getFloor();
        return dungeonFloor != null ? Integer.valueOf(dungeonFloor.getFloorNumber()) : null;
    }

    private final int getTotalRooms() {
        return completedRooms > 0 && clearedPercentage > 0 ? (int)Math.floor((double)completedRooms / ((double)clearedPercentage / 100.0) + 0.4) : 36;
    }

    /*
     * WARNING - void declaration
     */
    public final int getScore() {
        int n;
        void $this$count$iv;
        void $this$filterTo$iv$iv;
        DungeonFloor dungeonFloor = DungeonAPI.INSTANCE.getFloor();
        if (dungeonFloor == null) {
            return 0;
        }
        DungeonFloor currentFloor = dungeonFloor;
        int effectiveCompletedRooms = completedRooms + (!bloodDone ? 1 : 0) + (!DungeonAPI.INSTANCE.getInBoss() ? 1 : 0);
        Room[] $this$filter$iv = DungeonAPI.INSTANCE.getRooms();
        boolean $i$f$filter = false;
        Room[] roomArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        int n2 = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            void v1 = it;
            if (!((v1 != null ? v1.getType() : null) == RoomType.PUZZLE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List puzzles = (List)destination$iv$iv;
        Double d = requiredSecrets.get((Object)currentFloor);
        Intrinsics.checkNotNull((Object)d);
        int secretsScore = (int)RangesKt.coerceIn((double)Math.floor(secretPercentage / ((Number)d).doubleValue() / 100.0 * 40.0), (double)0.0, (double)40.0);
        int completedRoomScore = (int)RangesKt.coerceIn((double)((double)effectiveCompletedRooms / (double)this.getTotalRooms() * 60.0), (double)0.0, (double)60.0);
        int skillRooms = (int)RangesKt.coerceIn((double)Math.floor((double)effectiveCompletedRooms / (double)this.getTotalRooms() * (double)80.0f), (double)0.0, (double)80.0);
        Iterable $i$f$filterTo22 = puzzles;
        int n3 = puzzles.size();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Room it = (Room)element$iv;
                boolean bl = false;
                Room room = it;
                if (!((room != null ? room.getCheckmark() : null) == Checkmark.GREEN) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n4 = n;
        int puzzlePenalty = (n3 - n4) * 10;
        int deathPenalty = RangesKt.coerceAtLeast((int)(deathCount * 2 - 1), (int)0);
        int score = secretsScore + completedRoomScore + RangesKt.coerceIn((int)(20 + skillRooms - puzzlePenalty - deathPenalty), (int)20, (int)100) + this.getBonusScore() + this.getSpeedScore();
        if (score >= 270 && !alerted270) {
            ScoreAlert.INSTANCE.show270();
            alerted270 = true;
        }
        if (score >= 300 && !alerted300) {
            ScoreAlert.INSTANCE.show300();
            alerted300 = true;
        }
        return score;
    }

    public final int getBonusScore() {
        int score = RangesKt.coerceAtMost((int)cryptsCount, (int)5);
        if (mimicKilled) {
            Integer n = this.getDungeonFloorNumber();
            if ((n != null ? n : 0) > 5) {
                score += 2;
            }
        }
        if (princeKilled) {
            ++score;
        }
        if (DungeonAPI.INSTANCE.isPaul()) {
            score += 10;
        }
        return score;
    }

    public final int getSpeedScore() {
        Integer n = timeLimits.get((Object)this.getDungeonFloor());
        if (n == null) {
            return 100;
        }
        int limit = n;
        if (secondsElapsed <= limit) {
            return 100;
        }
        float percentageOver = (float)(secondsElapsed - limit) * 100.0f / (float)limit;
        return RangesKt.coerceAtLeast((int)((int)((float)100 - this.getSpeedDeduction(percentageOver))), (int)0);
    }

    public final void reset() {
        deathCount = 0;
        foundSecrets = 0;
        cryptsCount = 0;
        secretPercentage = 0.0;
        clearedPercentage = 0;
        completedRooms = 0;
        secondsElapsed = 0;
        mimicKilled = false;
        princeKilled = false;
        bloodDone = false;
        alerted270 = false;
        alerted300 = false;
    }

    private final void parseTablist(String line) {
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Crypts:", (boolean)false, (int)2, null)) {
            Integer n;
            String string = RegexUtils.INSTANCE.findGroup(cryptsPattern, (CharSequence)line, "crypts");
            if (string != null && (n = StringsKt.toIntOrNull((String)string)) != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                cryptsCount = it;
            }
        } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Completed Rooms:", (boolean)false, (int)2, null)) {
            Integer n;
            String string = RegexUtils.INSTANCE.findGroup(completedRoomsRegex, (CharSequence)line, "count");
            if (string != null && (n = StringsKt.toIntOrNull((String)string)) != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                completedRooms = it;
            }
        } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)"Secrets Found:", (boolean)false, (int)2, null)) {
            if (StringsKt.contains$default((CharSequence)line, (char)'%', (boolean)false, (int)2, null)) {
                Double d;
                String string = RegexUtils.INSTANCE.findGroup(secretsFoundPercentagePattern, (CharSequence)line, "percentage");
                if (string != null && (d = StringsKt.toDoubleOrNull((String)string)) != null) {
                    double it = ((Number)d).doubleValue();
                    boolean bl = false;
                    secretPercentage = it;
                }
            } else {
                Integer n;
                String string = RegexUtils.INSTANCE.findGroup(secretsFoundPattern, (CharSequence)line, "secrets");
                if (string != null && (n = StringsKt.toIntOrNull((String)string)) != null) {
                    int it = ((Number)n).intValue();
                    boolean bl = false;
                    foundSecrets = it;
                }
            }
            totalSecrets = secretPercentage > 0.0 ? (int)(100.0 / secretPercentage * (double)foundSecrets + 0.5) : 0;
        }
    }

    private final void parseSidebar(String line) {
        block3: {
            block2: {
                Integer n;
                if (!StringsKt.startsWith$default((String)line, (String)"Cleared:", (boolean)false, (int)2, null)) break block2;
                String string = RegexUtils.INSTANCE.findGroup(dungeonClearedPattern, (CharSequence)line, "percentage");
                if (string == null || (n = StringsKt.toIntOrNull((String)string)) == null) break block3;
                int newCompletedRooms = ((Number)n).intValue();
                boolean bl = false;
                if (newCompletedRooms != clearedPercentage && DungeonAPI.INSTANCE.getBloodKilledAll()) {
                    bloodDone = true;
                }
                clearedPercentage = newCompletedRooms;
                break block3;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"Time Elapsed:", (boolean)false, (int)2, null)) break block3;
            MatchResult matchResult = Regex.find$default((Regex)timeElapsedPattern, (CharSequence)line, (int)0, (int)2, null);
            if (matchResult != null && (matchResult = matchResult.getGroups()) != null) {
                MatchResult groups = matchResult;
                boolean bl = false;
                Object object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"hrs");
                int hours = object != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
                Object object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"min");
                int minutes = object2 != null && (object2 = object2.getValue()) != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
                Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)groups, (String)"sec");
                int seconds = object3 != null && (object3 = object3.getValue()) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : 0;
                secondsElapsed = hours * 3600 + minutes * 60 + seconds;
            }
        }
    }

    private final float getSpeedDeduction(float percentage) {
        float remaining = percentage;
        float deduction = 0.0f;
        deduction += RangesKt.coerceAtMost((float)remaining, (float)20.0f) / 2.0f;
        if ((remaining -= 20.0f) <= 0.0f) {
            return deduction;
        }
        deduction += RangesKt.coerceAtMost((float)remaining, (float)20.0f) / 3.5f;
        if ((remaining -= 20.0f) <= 0.0f) {
            return deduction;
        }
        deduction += RangesKt.coerceAtMost((float)remaining, (float)10.0f) / 4.0f;
        if ((remaining -= 10.0f) <= 0.0f) {
            return deduction;
        }
        deduction += RangesKt.coerceAtMost((float)remaining, (float)10.0f) / 5.0f;
        if ((remaining -= 10.0f) <= 0.0f) {
            return deduction;
        }
        return deduction += remaining / 6.0f;
    }

    /*
     * WARNING - void declaration
     */
    static {
        SkyBlockIsland[] islands$iv;
        boolean add$iv$iv;
        void $this$iv$iv;
        EventBus $this$iv;
        INSTANCE = new ScoreCalculator();
        secretsFoundPattern = new Regex("Secrets Found: (?<secrets>\\d+)");
        secretsFoundPercentagePattern = new Regex("Secrets Found: (?<percentage>[\\d.]+)%");
        cryptsPattern = new Regex("Crypts: (?<crypts>\\d+)");
        completedRoomsRegex = new Regex("Completed Rooms: (?<count>\\d+)");
        dungeonClearedPattern = new Regex("Cleared: (?<percentage>\\d+)% \\(\\d+\\)");
        timeElapsedPattern = new Regex(" Elapsed: (?:(?<hrs>\\d+)h )?(?:(?<min>\\d+)m )?(?:(?<sec>\\d+)s)?");
        Pair[] pairArray = EventBus.INSTANCE;
        SkyBlockIsland[] skyBlockIslandArray = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        Function1 callback$iv = 1.INSTANCE;
        boolean skyblockOnly$iv = false;
        boolean $i$f$registerIn = false;
        xyz.meowing.knit.api.events.EventBus eventBus = $this$iv;
        boolean bl = false;
        Function1 callback$iv$iv = callback$iv;
        int priority$iv$iv = 0;
        boolean $i$f$register = false;
        EventCall eventCall$iv = $this$iv$iv.registerInternal(TablistEvent.Change.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        Set islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        $this$iv = EventBus.INSTANCE;
        islands$iv = new SkyBlockIsland[]{SkyBlockIsland.THE_CATACOMBS};
        callback$iv = 2.INSTANCE;
        skyblockOnly$iv = false;
        $i$f$registerIn = false;
        islandSet$iv = $this$iv;
        add$iv$iv = false;
        callback$iv$iv = callback$iv;
        priority$iv$iv = 0;
        $i$f$register = false;
        eventCall$iv = $this$iv$iv.registerInternal(ScoreboardEvent.Update.class, priority$iv$iv, add$iv$iv, callback$iv$iv);
        islandSet$iv = !(islands$iv.length == 0) ? ArraysKt.toSet((Object[])islands$iv) : null;
        EventBusManager.INSTANCE.trackConditionalEvent(islandSet$iv, skyblockOnly$iv, eventCall$iv);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)DungeonFloor.E), (Object)0.3), TuplesKt.to((Object)((Object)DungeonFloor.F1), (Object)0.3), TuplesKt.to((Object)((Object)DungeonFloor.F2), (Object)0.4), TuplesKt.to((Object)((Object)DungeonFloor.F3), (Object)0.5), TuplesKt.to((Object)((Object)DungeonFloor.F4), (Object)0.6), TuplesKt.to((Object)((Object)DungeonFloor.F5), (Object)0.7), TuplesKt.to((Object)((Object)DungeonFloor.F6), (Object)0.85), TuplesKt.to((Object)((Object)DungeonFloor.F7), (Object)1.0), TuplesKt.to((Object)((Object)DungeonFloor.M1), (Object)1.0), TuplesKt.to((Object)((Object)DungeonFloor.M2), (Object)1.0), TuplesKt.to((Object)((Object)DungeonFloor.M3), (Object)1.0), TuplesKt.to((Object)((Object)DungeonFloor.M4), (Object)1.0), TuplesKt.to((Object)((Object)DungeonFloor.M5), (Object)1.0), TuplesKt.to((Object)((Object)DungeonFloor.M6), (Object)1.0), TuplesKt.to((Object)((Object)DungeonFloor.M7), (Object)1.0)};
        requiredSecrets = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)DungeonFloor.E), (Object)600), TuplesKt.to((Object)((Object)DungeonFloor.F1), (Object)600), TuplesKt.to((Object)((Object)DungeonFloor.F2), (Object)600), TuplesKt.to((Object)((Object)DungeonFloor.F3), (Object)600), TuplesKt.to((Object)((Object)DungeonFloor.F4), (Object)720), TuplesKt.to((Object)((Object)DungeonFloor.F5), (Object)600), TuplesKt.to((Object)((Object)DungeonFloor.F6), (Object)720), TuplesKt.to((Object)((Object)DungeonFloor.F7), (Object)840), TuplesKt.to((Object)((Object)DungeonFloor.M1), (Object)480), TuplesKt.to((Object)((Object)DungeonFloor.M2), (Object)480), TuplesKt.to((Object)((Object)DungeonFloor.M3), (Object)480), TuplesKt.to((Object)((Object)DungeonFloor.M4), (Object)480), TuplesKt.to((Object)((Object)DungeonFloor.M5), (Object)480), TuplesKt.to((Object)((Object)DungeonFloor.M6), (Object)600), TuplesKt.to((Object)((Object)DungeonFloor.M7), (Object)840)};
        timeLimits = MapsKt.mapOf((Pair[])pairArray);
    }
}

