/*
 * Decompiled with CFR 0.152.
 */
package xyz.meowing.krypt.api.hypixel;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import net.hypixel.data.region.Environment;
import net.hypixel.data.type.ServerType;
import net.hypixel.modapi.HypixelModAPI;
import net.hypixel.modapi.fabric.event.HypixelModAPICallback;
import net.hypixel.modapi.packet.ClientboundHypixelPacket;
import net.hypixel.modapi.packet.impl.clientbound.ClientboundHelloPacket;
import net.hypixel.modapi.packet.impl.clientbound.event.ClientboundLocationPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.meowing.knit.api.events.Event;
import xyz.meowing.knit.api.scheduler.TimeScheduler;
import xyz.meowing.krypt.Krypt;
import xyz.meowing.krypt.annotations.Module;
import xyz.meowing.krypt.events.EventBus;
import xyz.meowing.krypt.events.core.LocationEvent;
import xyz.meowing.krypt.utils.HttpRetryableException;
import xyz.meowing.krypt.utils.NetworkUtils;

@Module
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lxyz/meowing/krypt/api/hypixel/HypixelAPI;", "", "<init>", "()V", "", "uuid", "", "cacheMs", "Lkotlin/Function1;", "", "", "onResult", "fetchSecrets", "(Ljava/lang/String;JLkotlin/jvm/functions/Function1;)V", "SecretsCache", "Krypt"})
@SourceDebugExtension(value={"SMAP\nHypixelAPI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HypixelAPI.kt\nxyz/meowing/krypt/api/hypixel/HypixelAPI\n+ 2 NetworkUtils.kt\nxyz/meowing/krypt/utils/NetworkUtils\n*L\n1#1,82:1\n68#2:83\n85#2:84\n*S KotlinDebug\n*F\n+ 1 HypixelAPI.kt\nxyz/meowing/krypt/api/hypixel/HypixelAPI\n*L\n44#1:83\n44#1:84\n*E\n"})
public final class HypixelAPI {
    @NotNull
    public static final HypixelAPI INSTANCE = new HypixelAPI();

    private HypixelAPI() {
    }

    /*
     * WARNING - void declaration
     */
    public final void fetchSecrets(@NotNull String uuid, long cacheMs, @NotNull Function1<? super Integer, Unit> onResult) {
        void headers$iv;
        void url$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(onResult, (String)"onResult");
        if (SecretsCache.INSTANCE.isFresh(uuid, cacheMs)) {
            Integer n = SecretsCache.INSTANCE.get(uuid);
            if (n != null) {
                onResult.invoke((Object)n);
            }
            return;
        }
        NetworkUtils networkUtils = NetworkUtils.INSTANCE;
        String string = "https://api.tenios.dev/secrets/" + uuid;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"User-Agent", (Object)"Krypt"));
        boolean $i$f$fetchJson = false;
        BuildersKt.launch$default((CoroutineScope)this_$iv.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((String)url$iv, (Map)headers$iv, null, uuid, onResult, uuid, onResult){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $url;
            final /* synthetic */ Map $headers;
            final /* synthetic */ String $uuid$inlined;
            final /* synthetic */ Function1 $onResult$inlined;
            final /* synthetic */ String $uuid$inlined$1;
            final /* synthetic */ Function1 $onResult$inlined$1;
            {
                this.$url = $url;
                this.$headers = $headers;
                this.$uuid$inlined = string;
                this.$onResult$inlined = function1;
                this.$uuid$inlined$1 = string2;
                this.$onResult$inlined$1 = function12;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object $this$invokeSuspend_u24lambda_u241;
                        void $this$launch;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object = $this$launch;
                        String string = this.$url;
                        Object object2 = this.$headers;
                        try {
                            Object object3;
                            $this$invokeSuspend_u24lambda_u241 = object;
                            boolean bl = false;
                            HttpURLConnection connection = NetworkUtils.INSTANCE.createConnection(string, MapsKt.plus((Map)object2, (Pair)TuplesKt.to((Object)"Accept", (Object)"application/json")));
                            connection.setRequestMethod("GET");
                            if (connection.getResponseCode() == 200) {
                                InputStream inputStream = connection.getInputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                                Closeable closeable = inputStream;
                                Object object4 = Charsets.UTF_8;
                                object3 = new InputStreamReader((InputStream)closeable, (Charset)object4);
                                int n = 8192;
                                closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
                                object4 = null;
                                try {
                                    BufferedReader it = (BufferedReader)closeable;
                                    boolean bl2 = false;
                                    object3 = TextStreamsKt.readText((Reader)it);
                                }
                                catch (Throwable throwable) {
                                    object4 = throwable;
                                    throw throwable;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object4);
                                }
                            } else {
                                String string2 = "HTTP " + connection.getResponseCode();
                                int n = connection.getResponseCode();
                                URL uRL = connection.getURL();
                                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getURL(...)");
                                throw new HttpRetryableException(string2, n, uRL);
                            }
                            Object response = object3;
                            Type type2 = new TypeToken<Integer>(){}.getType();
                            Object data = new Gson().fromJson((String)response, type2);
                            int secrets = ((Number)data).intValue();
                            boolean bl3 = false;
                            SecretsCache.INSTANCE.put(this.$uuid$inlined, secrets);
                            this.$onResult$inlined.invoke((Object)Boxing.boxInt((int)secrets));
                            connection.disconnect();
                            $this$invokeSuspend_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable) {
                            $this$invokeSuspend_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        object = $this$invokeSuspend_u24lambda_u241;
                        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                        if (throwable != null) {
                            Object it = object2 = throwable;
                            boolean bl = false;
                            Exception exception = it instanceof Exception ? (Exception)it : null;
                            if (exception == null) {
                                exception = new Exception((Throwable)it);
                            }
                            Exception error = exception;
                            boolean bl4 = false;
                            Krypt.getLOGGER().error("Failed to fetch secrets for " + this.$uuid$inlined$1 + ": " + error.getMessage());
                            this.$onResult$inlined$1.invoke((Object)Boxing.boxInt((int)0));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final void _init_$lambda$0(ClientboundHypixelPacket event) {
        ClientboundHypixelPacket clientboundHypixelPacket = event;
        if (clientboundHypixelPacket instanceof ClientboundLocationPacket) {
            xyz.meowing.knit.api.events.EventBus eventBus = EventBus.INSTANCE;
            String string = ((ClientboundLocationPacket)event).getServerName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getServerName(...)");
            Optional optional = ((ClientboundLocationPacket)event).getServerType();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getServerType(...)");
            ServerType serverType = (ServerType)OptionalsKt.getOrNull((Optional)optional);
            Optional optional2 = ((ClientboundLocationPacket)event).getLobbyName();
            Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"getLobbyName(...)");
            String string2 = (String)OptionalsKt.getOrNull((Optional)optional2);
            Optional optional3 = ((ClientboundLocationPacket)event).getMode();
            Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"getMode(...)");
            String string3 = (String)OptionalsKt.getOrNull((Optional)optional3);
            Optional optional4 = ((ClientboundLocationPacket)event).getMap();
            Intrinsics.checkNotNullExpressionValue((Object)optional4, (String)"getMap(...)");
            xyz.meowing.knit.api.events.EventBus.post$default((xyz.meowing.knit.api.events.EventBus)eventBus, (Event)new LocationEvent.ServerChange(string, serverType, string2, string3, (String)OptionalsKt.getOrNull((Optional)optional4)), (boolean)false, (int)2, null);
        } else if (clientboundHypixelPacket instanceof ClientboundHelloPacket) {
            xyz.meowing.knit.api.events.EventBus eventBus = EventBus.INSTANCE;
            Environment environment = ((ClientboundHelloPacket)event).getEnvironment();
            Intrinsics.checkNotNullExpressionValue((Object)environment, (String)"getEnvironment(...)");
            xyz.meowing.knit.api.events.EventBus.post$default((xyz.meowing.knit.api.events.EventBus)eventBus, (Event)new LocationEvent.HypixelJoin(environment), (boolean)false, (int)2, null);
        }
    }

    static {
        HypixelModAPI.getInstance().subscribeToEventPacket(ClientboundLocationPacket.class);
        HypixelModAPICallback.EVENT.register(HypixelAPI::_init_$lambda$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012R,\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\b0\u00140\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lxyz/meowing/krypt/api/hypixel/HypixelAPI$SecretsCache;", "", "<init>", "()V", "", "cleanup", "", "uuid", "", "get", "(Ljava/lang/String;)Ljava/lang/Integer;", "secrets", "put", "(Ljava/lang/String;I)V", "", "cacheMs", "", "isFresh", "(Ljava/lang/String;J)Z", "", "Lkotlin/Pair;", "data", "Ljava/util/Map;", "EXPIRY_MS", "J", "Krypt"})
    public static final class SecretsCache {
        @NotNull
        public static final SecretsCache INSTANCE = new SecretsCache();
        @NotNull
        private static final Map<String, Pair<Long, Integer>> data = new LinkedHashMap();
        private static final long EXPIRY_MS = 300000L;

        private SecretsCache() {
        }

        public final void cleanup() {
            long now = System.currentTimeMillis();
            data.entrySet().removeIf(arg_0 -> SecretsCache.cleanup$lambda$0((Function1)new Function1<Map.Entry<String, Pair<? extends Long, ? extends Integer>>, Boolean>(now){
                final /* synthetic */ long $now;
                {
                    this.$now = $now;
                    super(1);
                }

                public final Boolean invoke(Map.Entry<String, Pair<Long, Integer>> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return this.$now - ((Number)it.getValue().getFirst()).longValue() > 300000L;
                }
            }, arg_0));
        }

        @Nullable
        public final Integer get(@NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Pair<Long, Integer> pair = data.get(uuid);
            return pair != null ? (Integer)pair.getSecond() : null;
        }

        public final void put(@NotNull String uuid, int secrets) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            data.put(uuid, (Pair<Long, Integer>)TuplesKt.to((Object)System.currentTimeMillis(), (Object)secrets));
        }

        public final boolean isFresh(@NotNull String uuid, long cacheMs) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Pair<Long, Integer> pair = data.get(uuid);
            if (pair == null) {
                return false;
            }
            long timestamp = ((Number)pair.getFirst()).longValue();
            return System.currentTimeMillis() - timestamp < cacheMs;
        }

        private static final boolean cleanup$lambda$0(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        static {
            TimeScheduler.repeat$default((TimeScheduler)TimeScheduler.INSTANCE, (long)60000L, (long)0L, (Function0)1.INSTANCE, (int)2, null);
        }
    }
}

