/*
 * Decompiled with CFR 0.152.
 */
package me.zipestudio.talkingheads.client;

import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.ClientReceiveSoundEvent;
import de.maxhenkel.voicechat.api.events.ClientSoundEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import java.util.UUID;
import me.zipestudio.talkingheads.client.THClient;
import me.zipestudio.talkingheads.config.LeafyConfig;
import me.zipestudio.talkingheads.utils.talkingheads.AudioUtils;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVoiceAddon
implements VoicechatPlugin {
    private static final Logger log = LoggerFactory.getLogger(SimpleVoiceAddon.class);
    private static VoicechatApi voicechatApi;

    public String getPluginId() {
        return "vc-addon-talkingheads";
    }

    public void initialize(VoicechatApi api) {
        voicechatApi = api;
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(ClientReceiveSoundEvent.EntitySound.class, this::onReceiveAudioEntity);
        registration.registerEvent(ClientSoundEvent.class, this::onClientSoundEvent);
    }

    public void onReceiveAudioEntity(ClientReceiveSoundEvent.EntitySound event) {
        LeafyConfig leafyConfig = THClient.getLeafyConfig();
        if (!leafyConfig.isEnableMod() || !leafyConfig.isUseSimpleVoiceChat()) {
            return;
        }
        UUID sourceUuid = event.getId();
        double audioLevel = AudioUtils.calculateAudioLevel(event.getRawAudio());
        AudioUtils.applyHeadVolume(sourceUuid, audioLevel);
    }

    public void onClientSoundEvent(ClientSoundEvent event) {
        LeafyConfig leafyConfig = THClient.getLeafyConfig();
        if (!leafyConfig.isEnableMod() || !leafyConfig.isUseSimpleVoiceChat()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        UUID sourceUuid = player.method_5667();
        double audioLevel = AudioUtils.calculateAudioLevel(event.getRawAudio());
        AudioUtils.applyHeadVolume(sourceUuid, audioLevel);
    }

    public static VoicechatApi getVoicechatApi() {
        return voicechatApi;
    }
}

