/*
 * Decompiled with CFR 0.152.
 */
package me.zipestudio.talkingheads.config;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import me.zipestudio.talkingheads.utils.CodecUtils;
import me.zipestudio.talkingheads.utils.ConfigUtils;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeafyConfig {
    public static final Codec<LeafyConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("enableMod", true, Codec.BOOL, LeafyConfig::isEnableMod), CodecUtils.option("usePlasmoVoice", true, Codec.BOOL, LeafyConfig::isUsePlasmoVoice), CodecUtils.option("useSimpleVoiceChat", true, Codec.BOOL, LeafyConfig::isUseSimpleVoiceChat), CodecUtils.option("removedVolume", 0.002, Codec.DOUBLE, LeafyConfig::getRemovedVolume), CodecUtils.option("scaleX", 0.3, Codec.DOUBLE, LeafyConfig::getScaleX), CodecUtils.option("scaleY", 0.3, Codec.DOUBLE, LeafyConfig::getScaleY), CodecUtils.option("scaleZ", 0.3, Codec.DOUBLE, LeafyConfig::getScaleZ), CodecUtils.option("helmetHideWhileTalking", false, Codec.BOOL, LeafyConfig::isHelmetHideWhileTalking), CodecUtils.option("helmetShowDelay", 0.1, Codec.DOUBLE, LeafyConfig::getHelmetShowDelay)).apply((Applicative)instance, LeafyConfig::new));
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("talkingheads.json5").toFile();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Talking Heads/Config");
    private static LeafyConfig INSTANCE;
    private boolean enableMod;
    private boolean usePlasmoVoice;
    private boolean useSimpleVoiceChat;
    private double removedVolume;
    private double scaleX;
    private double scaleY;
    private double scaleZ;
    private boolean helmetHideWhileTalking;
    private double helmetShowDelay;

    private LeafyConfig() {
        throw new IllegalArgumentException();
    }

    public static LeafyConfig getInstance() {
        return INSTANCE == null ? LeafyConfig.reload() : INSTANCE;
    }

    public static LeafyConfig reload() {
        INSTANCE = LeafyConfig.read();
        return INSTANCE;
    }

    public static LeafyConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static LeafyConfig read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    public boolean isEnableMod() {
        return this.enableMod;
    }

    public boolean isUsePlasmoVoice() {
        return this.usePlasmoVoice;
    }

    public boolean isUseSimpleVoiceChat() {
        return this.useSimpleVoiceChat;
    }

    public double getRemovedVolume() {
        return this.removedVolume;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public double getScaleZ() {
        return this.scaleZ;
    }

    public boolean isHelmetHideWhileTalking() {
        return this.helmetHideWhileTalking;
    }

    public double getHelmetShowDelay() {
        return this.helmetShowDelay;
    }

    public void setEnableMod(boolean enableMod) {
        this.enableMod = enableMod;
    }

    public void setUsePlasmoVoice(boolean usePlasmoVoice) {
        this.usePlasmoVoice = usePlasmoVoice;
    }

    public void setUseSimpleVoiceChat(boolean useSimpleVoiceChat) {
        this.useSimpleVoiceChat = useSimpleVoiceChat;
    }

    public void setRemovedVolume(double removedVolume) {
        this.removedVolume = removedVolume;
    }

    public void setScaleX(double scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(double scaleY) {
        this.scaleY = scaleY;
    }

    public void setScaleZ(double scaleZ) {
        this.scaleZ = scaleZ;
    }

    public void setHelmetHideWhileTalking(boolean helmetHideWhileTalking) {
        this.helmetHideWhileTalking = helmetHideWhileTalking;
    }

    public void setHelmetShowDelay(double helmetShowDelay) {
        this.helmetShowDelay = helmetShowDelay;
    }

    public LeafyConfig(boolean enableMod, boolean usePlasmoVoice, boolean useSimpleVoiceChat, double removedVolume, double scaleX, double scaleY, double scaleZ, boolean helmetHideWhileTalking, double helmetShowDelay) {
        this.enableMod = enableMod;
        this.usePlasmoVoice = usePlasmoVoice;
        this.useSimpleVoiceChat = useSimpleVoiceChat;
        this.removedVolume = removedVolume;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.helmetHideWhileTalking = helmetHideWhileTalking;
        this.helmetShowDelay = helmetShowDelay;
    }
}

