/*
 * Decompiled with CFR 0.152.
 */
package me.zipestudio.talkingheads.utils.talkingheads;

import java.util.HashMap;
import java.util.UUID;
import me.zipestudio.talkingheads.client.THManager;
import me.zipestudio.talkingheads.utils.talkingheads.THPlayerProfile;

public class AudioUtils {
    private static final HashMap<UUID, THPlayerProfile> ACTIVE_PLAYERS_MAP = THManager.PLAYERS_MAP;

    public static double calculateAudioLevel(short[] samples) {
        if (samples == null || samples.length == 0) {
            return -127.0;
        }
        double sum = 0.0;
        for (short sample : samples) {
            double normalized = (double)sample / 32767.0;
            sum += normalized * normalized;
        }
        double rms = Math.sqrt(sum / (double)samples.length);
        double db = rms > 0.0 ? Math.max(20.0 * Math.log10(rms), -127.0) : -127.0;
        return db;
    }

    public static void applyHeadVolume(UUID playerUuid, double audioLevel) {
        if (audioLevel <= -50.0) {
            ACTIVE_PLAYERS_MAP.put(playerUuid, new THPlayerProfile(playerUuid, 0.0f));
            return;
        }
        double voiceVolume = 0.8 * (1.0 - Math.abs(audioLevel) / 60.0);
        ACTIVE_PLAYERS_MAP.put(playerUuid, new THPlayerProfile(playerUuid, (float)voiceVolume));
    }
}

